/**
 * Copyright hacker_szoe51ih ( http://wonderfl.net/user/hacker_szoe51ih )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5hUb
 */

package {
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.TimerEvent;
	import flash.net.URLRequest;
	import flash.utils.Timer;

	[SWF(width = "465",height = "465",backgroundColor = "0xffffff",frameRate = "30")]
	import flash.display.Shape;
	public class AnalogClock extends Sprite {

		private var centerX:Number = 465 / 2;
		private var centerY:Number = 465 / 2;

		private var hourHand:Shape;
		private var minutesHand:Shape;
		private var secondsHand:Shape;
		private var cf:Shape;

		public var _date:Date;
		public var dateHours:int;
		public var dateMinutes:int;
		public var dateSeconds:int;




		public function AnalogClock() {

			setup();
			addEventListener(Event.ENTER_FRAME,enterFrame);

		}

		public function setup():void {
			
			//時計の部品を用意
			hourHand = makeHand(80,8,0x333333,0xa2fe22);
			minutesHand = makeHand(150,6,0x333333,0xa2a2fe);
			secondsHand = makeHand(150,1,0x333333,0xee2222);
			cf = clockFace(160,0x444444,0x111111);
			
			//時計のパーツを表示リストに追加して表示する
			addChild(cf);
			cf.x = 465 / 2;
			cf.y = 465 / 2;

			addChild(hourHand);
			hourHand.x = centerX;
			hourHand.y = centerY;

			addChild(minutesHand);
			minutesHand.x = centerX;
			minutesHand.y = centerY;

			addChild(secondsHand);
			secondsHand.x = centerX;
			secondsHand.y = centerY;

		}
		
		//時計を更新
		public function enterFrame(e:Event):void {
			_date = new Date();
			dateHours = _date.hours;
			dateMinutes = _date.minutes;
			dateSeconds = _date.seconds;
			hourHand.rotation = hoursDegree(dateHours);
			minutesHand.rotation = minutesDegree(dateMinutes);
			secondsHand.rotation = secondsDegree(dateSeconds);
		}
		
		
		//計算する
		public function hoursDegree(h:Number):Number {
			return (h%12) * 360/12  + dateMinutes/60 + dateSeconds/60  -90;
		}
		public function minutesDegree(m:Number):Number {
			return m * 360/60  + dateSeconds/60 -90;
		}
		public function secondsDegree(s:Number):Number {
			return s * 360/60 -90;
		}

		//時計のボディを作る
		public function clockFace(r:Number,lineCol:uint,fillCol:uint):Shape {
			var body:Shape = new Shape  ;
			body.graphics.lineStyle(4,lineCol);
			body.graphics.beginFill(fillCol);
			body.graphics.drawCircle(0,0,r);
			body.graphics.endFill();
			return body;
		}

		//時計の針を作る
		public function makeHand(len:Number,w:Number,lineCol:uint,fillCol:uint):Shape {
			var hand:Shape = new Shape  ;
			hand.graphics.beginFill(fillCol);
			hand.graphics.drawRect( -  w / 2, -  w / 2,len,w);
			hand.graphics.endFill();
			return hand;
		}


	}

}