/**
 * Copyright featherlife ( http://wonderfl.net/user/featherlife )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5hMp
 */

package {
    import flash.display.Sprite;
    import flash.display.Stage;
    import flash.display.StageQuality;
    import flash.display.BlendMode;
    import flash.filters.BlurFilter;
    import flash.filters.GlowFilter;
    import flash.geom.Matrix;
    
    public class FlashTest extends Sprite {
        private var _stage:Stage;
        public function FlashTest() {
            _stage = stage;
            
            var sp:Sprite = new Sprite();
            sp.graphics.beginFill(0x0);
            sp.graphics.drawRect(0, 0, stage.stageWidth, stage.stageWidth);
            sp.graphics.endFill();
            //sp.graphics.lineStyle(2, 0xFFFFFFFF);
            //sp.graphics.lineTo(100, 100);
            
            addChild(sp);
            
            var sp2:Sprite = new Sprite();
            sp2 = createFlare(128);
            sp2.x = 128;
            sp2.y = 128;
            //sp2.rotation = 15;
            addChild(sp2);
        }
        //虹リングセットを生成
        private function createFlare(size:Number = 100):Sprite {
            var ring:Sprite = createRing(size);
            ring.alpha = 0.5;
            var ray:Sprite = new Sprite();
            ray.addChild(createStar(size*2, 100, 0.2));
            ray.addChild(createStar(size*2.5, 175, 0.15));
            ray.addChild(createGlow(size, 0x000000));
            var sp:Sprite = new Sprite();
            sp.addChild(ring);
            sp.addChild(Painter.captureSprite(ray, false, _stage));
            sp.blendMode = BlendMode.ADD;
            return sp;
        }
        //光の放射イメージを生成
        private function createFlash(size:Number = 100, count:int = 50, color:uint = 0xffffff):Sprite {
            var sp:Sprite = new Sprite();
            sp.graphics.lineStyle();
            var mat:Matrix = new Matrix();
            mat.createGradientBox(size * 2, size * 2, 0, -size, -size);
            sp.graphics.beginGradientFill("radial", [color, color], [1, 0], [0, 255], mat);
            sp.graphics.drawCircle(0, 0, size);
            sp.graphics.endFill();
            sp.graphics.beginFill(0x000000, 1);
            var random:Array = new Array();
            var total:Number = 0;
            for (var n:int = 0; n < count*2; n ++) {
                total += Math.random() * 50 + 10;
                random.push(total);
            }
            for (var m:int = 0; m < random.length; m ++) {
                random[m] /= total / 360;
                var px:Number = Math.cos(Math.PI/180 * random[m]) * (size*1.2);
                var py:Number = Math.sin(Math.PI/180 * random[m]) * (size*1.2);
                if (m % 2) {
                    sp.graphics.moveTo(px, py);
                }else {
                    sp.graphics.lineTo(px, py);
                    sp.graphics.lineTo(0, 0);
                }
            }
            sp.graphics.endFill();
            sp.filters = [new BlurFilter(2, 2, 3)];
            return Painter.captureSprite(sp, false, _stage);
        }
        
        //オーブイメージを生成
        private function createOrb(size:Number = 100, color:uint = 0xFFFFFF):Sprite {
            var sp:Sprite = new Sprite();
            sp.graphics.lineStyle();
            var mat:Matrix = new Matrix();
            mat.createGradientBox(size * 2, size * 2, 0, -size, -size);
            sp.graphics.beginGradientFill("radial", [color, color], [0.2, 1], [0, 255], mat);
            sp.graphics.drawCircle(0, 0, size);
            sp.graphics.endFill();
            sp.filters = [new GlowFilter(color, 1, 3, 3, 1, 3, false, true), new BlurFilter(2, 2, 3)];
            sp.blendMode = BlendMode.ADD;
            return Painter.captureSprite(sp, false, _stage);
        }
        
        //グローイメージを生成
        private function createGlow(size:Number = 100, color:uint = 0xFFFFFF):Sprite {
            var sp:Sprite = new Sprite();
            sp.graphics.lineStyle();
            var mat:Matrix = new Matrix();
            mat.createGradientBox(size * 2, size * 2, 0, -size, -size);
            sp.graphics.beginGradientFill("radial", [color, color], [1, 0], [0, 255], mat);
            sp.graphics.drawCircle(0, 0, size);
            sp.graphics.endFill();
            return Painter.captureSprite(sp, false, _stage);
        }
        
        //虹リングイメージを生成
        private function createRing(size:Number = 100):Sprite {
            var sp:Sprite = new Sprite();
            sp.graphics.lineStyle();
            var mat:Matrix = new Matrix();
            mat.createGradientBox(size * 2, size * 2, 0, -size, -size);
            sp.graphics.beginGradientFill("radial", [0xFF0000, 0xFFdd00, 0x00FF00, 0x0066FF, 0x0000FF], [0, 1, 1, 0.5, 0], [180, 205, 215, 235, 255], mat);
            sp.graphics.drawCircle(0, 0, size);
            sp.graphics.endFill();
            return Painter.captureSprite(sp, false, _stage);
        }
        
        //星イメージを生成
        private function createStar(size:Number = 100, count:uint = 8, per:Number = 0.05, color:uint = 0x000000, blur:Number = 0):Sprite {
            var sp:Sprite = new Sprite();
            sp.graphics.lineStyle();
            sp.graphics.beginFill(color, 1);
            var step:Number = 360 / (count * 2);
            for (var i:int = 0; i < count * 2; i ++) {
                var radius:Number = (i % 2)? size * per : size;
                var px:Number = Math.cos(Math.PI / 180 * i * step) * radius;
                var py:Number = Math.sin(Math.PI / 180 * i * step) * radius;
                if (i == 0) sp.graphics.moveTo(px, py);
                else sp.graphics.lineTo(px, py);
            }
            sp.graphics.endFill();
            sp.filters = (blur)? [new BlurFilter(blur, blur, 3)] : [];
            return Painter.captureSprite(sp, false, _stage);
        }
    }
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.BlendMode;
import flash.display.Sprite;
import flash.display.Stage;
import flash.display.StageQuality;
import flash.filters.BlurFilter;
import flash.filters.GlowFilter;
import flash.geom.Matrix;
import flash.geom.Point;
import flash.geom.Rectangle;
import flash.utils.Dictionary;
import flash.utils.getTimer;
import org.papervision3d.materials.ColorMaterial;
import org.papervision3d.materials.utils.MaterialsList;
import org.papervision3d.objects.primitives.Cube;

class Painter {
    /**
     * グラデーションスプライト生成
     */
    static public function createGradientRect(width:Number, height:Number, colors:Array, alphas:Array, ratios:Array = null, rotation:Number = 0, x:Number = 0, y:Number = 0):Sprite {
        var i:int;
        if (!ratios) ratios = [];
        if(!ratios.length) for (i = 0; i < colors.length; i++) ratios.push(int(255 * i / (colors.length - 1)));
        else for (i = 0; i < ratios.length; i++) ratios[i] = Math.round(ratios[i] * 255);
        var sp:Sprite = new Sprite();
        var mtx:Matrix = new Matrix();
        mtx.createGradientBox(width, height, Math.PI / 180 * rotation, 0, 0);
        if (colors.length == 1 && alphas.length == 1) sp.graphics.beginFill(colors[0], alphas[0]);
        else sp.graphics.beginGradientFill("linear", colors, alphas, ratios, mtx);
        sp.graphics.drawRect(0, 0, width, height);
        sp.graphics.endFill();
        sp.x = x;
        sp.y = y;
        return sp;
    }
    
    /**
     * スプライトをキャプチャしてBitmap化する
     * @param    target    キャプチャするSprite
     * @param    smooth    Bitmapのsmoothに設定する値
     * @param    stage    Stageクラスを渡すと最高画質でキャプチャします
     */
    static public function captureSprite(target:Sprite, smooth:Boolean = true, stage:Stage = null):Sprite {
        var sp:Sprite = new Sprite();
        sp.blendMode = target.blendMode;
        
        if (stage) {
            //キャプチャする瞬間だけ最高画質にする
            var saveQuality:String = stage.quality;
            stage.quality = StageQuality.BEST;
        }
        
        var rect:Rectangle = getFilterBounds(target);
        var bmd:BitmapData = new BitmapData(rect.width, rect.height, true, 0);
        bmd.draw(target, new Matrix(1, 0, 0, 1, -rect.x, -rect.y));
        
        if(stage) stage.quality = saveQuality;
        var bmp:Bitmap = sp.addChild(new Bitmap(bmd, "auto", smooth)) as Bitmap;
        bmp.x = rect.x;
        bmp.y = rect.y;
        return sp;
    }
    
    /**
     * フィルターも含めたSpriteの矩形範囲を返す
     * @param    target    サイズを調べるSprite
     * @return
     */
    static public function getFilterBounds(target:Sprite):Rectangle {
        var rect:Rectangle = target.getBounds(target);
        if (!rect.width) rect.width = 1;
        if (!rect.height) rect.height = 1;
        var bmd:BitmapData;
        var basePos:Point = rect.topLeft;
        rect.x = rect.y = 0;
        for each (var filter:* in target.filters) {
            bmd = new BitmapData(rect.width, rect.height, true, 0);
            rect = bmd.generateFilterRect(rect, filter);
            basePos.offset(rect.x, rect.y);
            rect.x = rect.y = 0;
        }
        rect.offsetPoint(basePos);
        return rect;
    }
}