/**
 * Copyright hogemaruo ( http://wonderfl.net/user/hogemaruo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5hBU
 */

package  
{
    import flash.display.Shape;
    import flash.display.Sprite
    import flash.display.Bitmap
    import flash.display.BitmapData
    import flash.events.Event
    import flash.events.MouseEvent;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.display.GradientType;
    import flash.display.BlendMode;
    /**
     * ...
     * @author hoge
     */
    public class SmokeMokuMoku extends Sprite
    {
        public function SmokeMokuMoku() 
        {
            var i:int;
            var bmp:Bitmap = new Bitmap( new BitmapData(stage.stageWidth,stage.stageHeight, true, 0));
            var cnt:int = 0;
            var ar:Array = new Array();
            var arNext:Array = new Array();
            var mat:Matrix = new Matrix();
            var ox:int=stage.stageWidth/2;
            var oy:int=stage.stageHeight;
            const MINLEN:int = 30;
            var tbl:Array = [createSmokyCircle( 100, 100 ), createSmokyCircle( 100, 100 ), createSmokyCircle( 100, 100, 0)];
            addChild( bmp );
            var addSmoke:Function = function(x:int, y:int):void {
                var r:Number = 0.4 + Math.random() * 0.4;
                ar.push( [x + Math.random() * 20, y + Math.random() * 20, r, 0, 0.06, 0,tbl[(int)(Math.random()*3)],0,Math.random()*0.02-0.01]);
            };
            stage.addEventListener( MouseEvent.MOUSE_MOVE, function (e:Event ):void {
                var vx:Number = mouseX - ox;
                var vy:Number = mouseY - oy;
                var len:Number = Math.sqrt( vx * vx + vy * vy );
                if ( len < MINLEN ) return;
                vx = vx * MINLEN / len;
                vy = vy * MINLEN / len;
                var _x:Number = ox;
                var _y:Number = oy;
                for ( i = 0; i < int(len); i+=MINLEN,_x+=vx,_y+=vy ) {
                    addSmoke(_x,_y);
                }
                ox = mouseX;
                oy = mouseY;
            });
            stage.addEventListener( Event.ENTER_FRAME, function (e:Event ):void {
                bmp.bitmapData.lock();
                bmp.bitmapData.fillRect(bmp.bitmapData.rect, 0xff4060f0);
                if ( ( cnt & 3 ) == 0 ) { 
                    var r:Number = (cnt & 15 )>>2;
                    addSmoke(ox+Math.cos( r * Math.PI/4)*24, oy+Math.sin( r*Math.PI/4)*24);
                }
                arNext = new Array();
                for each( var obj:Array in ar ) {
                    obj[1] -= 2;
                    obj[2] += 0.005;
                    obj[3] += obj[4];
                    obj[5] += 0.03;
                    obj[7] += obj[8];
                    if ( obj[3] > 1.3 )obj[4] = -0.007;
                    if ( obj[3] < 0 ) obj[3] = 0;
                    if ( obj[5] > 1 ) obj[5] = 1;
                    mat.identity();
                    mat.translate( -50, -50);
                    mat.scale( obj[2],obj[2] );
                    mat.rotate( obj[7]);
                    mat.translate( obj[0], obj[1]);
                    bmp.bitmapData.draw(obj[6], mat, new ColorTransform(obj[5], obj[5], obj[5], obj[3]));
                    if ( obj[1] > -100 && obj[3] > 0 )arNext.push( obj );
                }
                bmp.bitmapData.unlock();
                ar = arNext;
                cnt++;
            });
        }
        public function createSmokyCircle( w:int, h:int, col:int = 0xffffff ):BitmapData {
            var buf:BitmapData = new BitmapData( w, h );
            var buf2:BitmapData = new BitmapData( w, h );
            var buf3:BitmapData = new BitmapData( w, h );
            var sh:Shape = new Shape();
            var colors:Array = [0xd0d0d0, 0xa0a0a0, 0x000000];
            var alphas:Array = [1, 1, 1];
            var ratios:Array = [0, 127, 255];
            var matrix:Matrix = new Matrix();

            buf.perlinNoise( w, w, 4, Math.random() * 0xffff, true, true, 4);
            matrix.createGradientBox(w, h, 0, 0, 0);
            sh.graphics.beginGradientFill(GradientType.RADIAL, colors, alphas, ratios,matrix);
            sh.graphics.drawRect(0, 0, w, h );
            sh.graphics.endFill();

            buf3.draw( sh );
            buf.draw(buf3, null, null, BlendMode.MULTIPLY );

            colors = [col,0,0];
            alphas = [1, 1,1];
            ratios = [0, 192,255];
            matrix.createGradientBox(w, h, 45);
            sh.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios,matrix);
            sh.graphics.drawRect(0, 0, w, h );
            sh.graphics.endFill();
            
            buf2.perlinNoise( buf2.width, buf2.height, 4, Math.random() * 0xffff, true, false, 7, true );
            buf2.draw( sh, null,null,BlendMode.ADD );
            
            buf2.copyChannel( buf, buf.rect, new Point(0, 0), 4, 8);
            return buf2;
        }
    }
}