/**
 * Copyright codeonwort ( http://wonderfl.net/user/codeonwort )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5gEt
 */

// forked from codeonwort's stage3D base
package {
    
    import flash.display.Sprite
    import flash.events.Event
    
    import flash.display3D.Context3D
    
    public class Stage3DBase extends Sprite {
        
        private var context:Context3D
        
        public function Stage3DBase() {
            // write as3 code here..
            stage ? init() : addEventListener("addedToStage", init)
        }
        
        private function init(e:Event = null):void {
            // never mind
            if(e) removeEventListener(e.type, arguments.callee)
            
            // request context 3d
            stage.stage3Ds[0].addEventListener(Event.CONTEXT3D_CREATE, contextGained)
            stage.stage3Ds[0].requestContext3D("auto")
        }
        
        // when I request context3D by Stage3D::requestContext3D
        // or when device loss occurs this listener is called.
        // make this listener to handle both situations.
        private function contextGained(e:Event):void {
            context = e.target.context3D
            
            var study:StudyBase = new StudyExample
            study.init(this, context)
        }
        
    }
    
}

import flash.display.Stage
import flash.display.Sprite
import flash.display3D.Context3D
import flash.display3D.Program3D
import flash.display3D.IndexBuffer3D
import flash.display3D.VertexBuffer3D
import com.adobe.utils.AGALMiniAssembler
class StudyBase {
    
    protected var document:Sprite
    protected var stage:Stage
    protected var context:Context3D
    protected var asm:AGALMiniAssembler
    
    protected var hardwareAccelerated:Boolean
    
    protected var vertBuf:VertexBuffer3D
    protected var idxBuf:IndexBuffer3D
    protected var program:Program3D
    
    public function StudyBase() {
        asm = new AGALMiniAssembler
    }
    
    public function init(doc:Sprite, cont:Context3D):void {
        if(context) context.dispose()
        context = cont
        document = doc
        stage = document.stage
        
        hardwareAccelerated = context.driverInfo.toLowerCase().indexOf("software") == -1
        
        program = context.createProgram()
    }
    
    protected function makeVertBuf(verts:Vector.<Number>, data32PerVert:uint):void {
        vertBuf = context.createVertexBuffer(verts.length / data32PerVert, data32PerVert)
        vertBuf.uploadFromVector(verts, 0, verts.length / data32PerVert)
    }
    protected function makeIdxBuf(indices:Vector.<uint>):void {
        idxBuf = context.createIndexBuffer(indices.length)
        idxBuf.uploadFromVector(indices, 0, indices.length)
    }
    
}

import flash.text.TextField;
import flash.utils.ByteArray
class StudyExample extends StudyBase {
    
    public override function init(doc:Sprite, cont:Context3D):void {
        super.init(doc, cont)
        context.configureBackBuffer(stage.stageWidth, stage.stageHeight, 4, false)
        context.setCulling("back")
        
        var verts:Vector.<Number> = new Vector.<Number>
        var indices:Vector.<uint> = new Vector.<uint>
        
        const num_cols:uint = 7, num_rows:uint = 7
        const left:Number = -1, top:Number = -1
        const width:Number = 2, height:Number = 2
        
        var x:Number, y:Number, z:Number
        var rand_color:uint
        var a:uint, b:uint, c:uint, d:uint
        for(var i:int = 0 ; i <= num_cols ; i++){
            for(var j:int = 0 ; j <= num_rows ; j++){
                // vertex position
                x = left + width * i/num_cols
                y = top + height * j/num_rows
                z = 0
                verts.push(x, y, z)
                
                // vertex color
                rand_color = Math.random() * 0xffffff
                verts.push((rand_color & 0xff) / 255)
                verts.push((rand_color >> 8 & 0xff) / 255)
                verts.push((rand_color >> 16 & 0xff) / 255)
                
                // indices
                if( i != num_cols && j != num_rows){
                    a = i * (num_rows + 1) + j
                    b = a + 1
                    c = (i + 1) * (num_rows + 1) + j
                    d = c + 1
                    indices.push(a,b,c, b,d,c)
                }
            }
        }
        
        var tf:TextField = new TextField
        tf.width = stage.stageWidth
        tf.height = stage.stageHeight
        tf.text = "num verts : " + verts.length / 6 + "\n-----------------------------\n"
        for(i=0 ; i<verts.length ; i+=6){
            tf.appendText("x : " + verts[i] + "\n")
            tf.appendText("y : " + verts[i+1] + "\n")
            tf.appendText("z : " + verts[i+2] + "\n")
            tf.appendText("r : " + verts[i+3] + "\n")
            tf.appendText("g : " + verts[i+4] + "\n")
            tf.appendText("b : " + verts[i+5] + "\n\n")
        }
        document.addChild(tf)
        
        makeVertBuf(verts, 3 + 3)
        makeIdxBuf(indices)
        
        context.setVertexBufferAt(0, vertBuf, 0, "float3")
        context.setVertexBufferAt(1, vertBuf, 3, "float3")
        
        var vertShader:ByteArray = asm.assemble("vertex", "mov v0, va1\n" + "mov op, va0")
        var fragShader:ByteArray = asm.assemble("fragment", "mov oc, v0")
        program.upload(vertShader, fragShader)
        context.setProgram(program)
        
        context.clear(0.5, 0.5, 0.5)
        context.drawTriangles(idxBuf, 0, indices.length / 3)
        context.present()
    }
    
}
