/**
 * Copyright n0wri ( http://wonderfl.net/user/n0wri )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5f9h
 */

// forked from n0wri's lifegame
// lifegame ver 2.0
// viewに渡す配列を別途作るようにした

package
{
	import net.hires.debug.Stats;
	import flash.text.TextField;
	import flash.display.StageScaleMode;
	import flash.display.StageAlign;
	import flash.display.Bitmap;
	import flash.display.Sprite;

	public class LifeGame extends Sprite
	{
//		private static var txt:TextField;
		public function LifeGame()
		{
			stage.align=StageAlign.TOP_LEFT;
			stage.scaleMode=StageScaleMode.NO_SCALE;
//			txt=new TextField();
			
			var lifeGame:LifeGameBase = new LifeGameBase(70,13,[0xff00ffff, 0xff00ff00,0xff333333,0xff666666,0xff999999],128);
			var bmp:Bitmap = new Bitmap(lifeGame.view);
			bmp.scaleX=bmp.scaleY=10;
			bmp.y=200;
			addChild(bmp);
			
			
//			txt.y=stage.stageHeight-20;
//			addChild(txt);
//			

			stage.addChild(new Stats());
			lifeGame.start();
		}
		
//		public static function setText(nanika:*):void
//	    {
//	        txt.text =(nanika is String)? (nanika as String)+"\n":String(nanika) + "\n";
//	    }
	    
	}
	
    
}


import flash.events.TimerEvent;
import flash.utils.Timer;
import flash.geom.Rectangle;
import flash.display.BitmapData;

class LifeGameBase
{
	private var _view:LifeGameView;
	private var _model:LifeGameModel;
	private var _control:LifeGameControl;
	
	public function LifeGameBase(x:int,y:uint,colorar:Array,interval:uint) 
	{
		
		_view = new LifeGameView(x,y,colorar);
		_model = new LifeGameModel(_view,x,y,interval);
		_control = new LifeGameControl(_model);
		
		
	}
	
	public function start():void
	{
		
		_control.start();
	}

	public function get view():LifeGameView
	{
		return _view;
	}
}

class LifeGameControl
{
	private var _model:LifeGameModel;
	public function LifeGameControl(model:LifeGameModel) 
	{
		_model = model;
	}
	
	public function start():void
	{
		_model.setColorsRandom();
		_model.start();
	}
}

class LifeGameModel
{
	private var _view:LifeGameView;
	private var color_List:Array=[];
	private var color_ListX:uint;
	private var color_ListY:uint;
	private var timer:Timer;
	private var mustUpdate:Boolean;
	public function LifeGameModel(view:LifeGameView,x:int,y:int,interval:uint) 
	{
		_view = view;
		color_ListX = x;
		color_ListY = y;
		for(var i:uint=0; i<color_ListX;i++)
		{
			color_List[i]=[];
			for (var j : int = 0; j < color_ListY; j++) 
			{
				color_List[i][j] = false;
			};
		};
		timer = new Timer(interval);
		timer.addEventListener(TimerEvent.TIMER, timerFunc);
	}


	public function setColorsRandom():void
	{
		var len:uint = int(color_ListX*color_ListY*0.5);
                var sendAr:Array = [];
		for(var i : int = 0; i<len; i++) 
		{
                        var x:uint = uint( Math.random()*color_ListX );
                        var y:uint = uint( Math.random()*color_ListY );
			color_List[x][y]=true;
                        sendAr.push([x,y]);
		};
		mustUpdate=true;
		noteUpdate(sendAr);
	}

	public function start():void
	{
		timer.start();
	}
	
	private function noteUpdate(sendar:Array):void
	{
		_view.update(sendar);
	}
	
	private function timerFunc(event:TimerEvent):void
	{
		var oldAr:Array = color_List.concat();
		var sendAr:Array = [];
		var calc:Function = function(x:uint,y:uint):uint
		{
			var flg:uint=0;
			var xAr:Array=[];
			var yAr:Array=[];
			 
			if(x)
			{
				xAr.push(x-1);
			};
			xAr.push(x);
			if(x+1<color_ListX)
			{
				xAr.push(x+1);
			};
			
			if(y)
			{
				yAr.push(y-1);
			}
			yAr.push(y);
			if(y+1 < color_ListY)
			{
				yAr.push(y+1);
			};
			
			var xArLen:uint=xAr.length;
			var yArLen:uint=yAr.length;
			
			for (var i : int = 0; i <xArLen; i++)
			{
				
				for(var j : int = 0; j < yArLen; j++) 
				{
					if(oldAr[xAr[i]][yAr[j]] && !(xAr[i]==x && yAr[j]==y))
					{
						flg++;
					};
				}
			}
			return flg;
		};
		
		mustUpdate =false;
		for(var i:uint=0; i<color_ListX;i++)
		{
			for (var j : int = 0; j < color_ListY; j++) 
			{
				var flg:uint = calc(i,j);
				
				var myState:Boolean = oldAr[i][j];
				
				if(!myState && flg==3)
				{
					if(!mustUpdate)mustUpdate=true;
					color_List[i][j]=true;
					sendAr.push([i,j]);
				}
				else if(myState && (flg==2 || flg ==3))
				{
					if(!mustUpdate)mustUpdate=true;
					color_List[i][j]=true;
					sendAr.push([i,j]);
				}
				else
				{
					color_List[i][j]=false;
				};
			};
		};
		noteUpdate(sendAr);
		if(!mustUpdate){timer.stop();trace("timerstop");}
	}
}

class LifeGameView extends BitmapData
{
	private var _colorAr:Array;
	private var _colorArLen:uint;
	private var xLen:uint;
	private var yLen:uint;
	private var rec:Rectangle;
	private var recSrc:Rectangle;
	
	public function LifeGameView(w:uint,h:uint,colorAr:Array) 
	{
		super(w,h,true);
		_colorAr = colorAr;
		_colorArLen = _colorAr.length;
		xLen = w;
		yLen = h;
		rec=new Rectangle(0,0,1,1);
		recSrc=new Rectangle(0,0,w,h);
	}
	
	public function update(ar:Array):void
	{
		this.fillRect(recSrc, 0x00);
		var len:uint = ar.length;
		var target:Array;
		for(var i:int=0; i<len; i++) 
		{
			target = ar[i];
			rec.x=target[0];
			rec.y=target[1];
			this.fillRect(rec, _colorAr[uint(Math.random()*_colorArLen)]);
		}
	}
}