/**
 * Copyright hiro_rec ( http://wonderfl.net/user/hiro_rec )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5ewS
 */

package
{
	import __AS3__.vec.Vector;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.AsyncErrorEvent;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.NetStatusEvent;
	import flash.events.SecurityErrorEvent;
	import flash.geom.Matrix;
	import flash.media.Camera;
	import flash.media.Video;
	import flash.net.NetConnection;
	import flash.net.NetStream;
	import flash.system.Security;
	
	
	[SWF (width="456", height="456", backgroundColor='#000000', frameRate=30)]
	
	public class GridCameraMovie extends Sprite
	{	
		private static const VIDEO_WIDTH:int = 456, VIDEO_HEIGHT:int = 456;
		
		private var colMax:int = 1;
		private var rowMax:int = 1;
		
		private var video:Video;
		private var connection:NetConnection;
		private var stream:NetStream;
		
		private var imageWidth:int, imageHeight:int;
		private var imageList:Vector.<MovieClip> = new Vector.<MovieClip>();
		private var imageBuffer:Vector.<BitmapData>;
		private var bufferIndex:int = -1;
		private var container:Sprite;
		
		private var count:int = 0;
		private var togle:Boolean = true;
		
		
		public function GridCameraMovie()
		{
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			
			imageWidth = stage.stageWidth / colMax;
			imageHeight = stage.stageHeight / rowMax;
			
			initContainer();
			initVideo();
			initBitmap();
			
			addEventListener(Event.ENTER_FRAME, updateBuffer);
			
			stage.addEventListener(MouseEvent.CLICK, rest);
		}
		
		private function initContainer():void
		{
			container = new Sprite();
			addChild(container);
		}
		
		private function initVideo():void
		{
			var camera:Camera = Camera.getCamera();
			
			if (camera)
			{
				video = new Video(VIDEO_WIDTH, VIDEO_HEIGHT);
				video.smoothing = true;
				video.attachCamera(camera);
				//addChild(video);
			}
			else
			{
				trace("No camera.");
			}
		}
		
		private function initBitmap():void
		{
			imageWidth = stage.stageWidth / colMax;
			imageHeight = stage.stageHeight / rowMax;
			
			imageBuffer = new Vector.<BitmapData>();
			
			var imageScaleX:Number = imageWidth / stage.stageWidth;
			var imageScaleY:Number = imageHeight / stage.stageHeight;
			
			var count:int = 0;
			
			for (var i:int = 0; i < colMax; i++)
			{
				for (var j:int = 0; j < rowMax; j++)
				{
					var bmd:BitmapData = new BitmapData(imageWidth, imageHeight, true, 0x00000000);
					var bmp:Bitmap = new Bitmap(bmd, "auto", true);
					var mc:MovieClip = new MovieClip();
					
					mc.index = count;
					mc.child = bmp;
					
					if (togle)
					{
						mc.x = imageWidth * i;
						mc.y = imageHeight * j;
					}
					else
					{
						mc.x = imageWidth * j;
						mc.y = imageHeight * i;
					}
					
					
					mc.addEventListener(Event.ENTER_FRAME, render);
					mc.addChild(bmp);
					
					container.addChild(mc);
					
					imageList.push(mc);
					
					imageBuffer.push(bmd); 
					
					count++;
				}
			}
			
		}
		
		private function rest(event:MouseEvent):void
		{
			bufferIndex = 0;
			
			colMax *= 2;
			rowMax *= 2;
			
			count++;
			
			if (count >= 5)
			{
				colMax = 1;
				rowMax = 1;
				count = 0;
				togle = !togle;
			}
			
			imageWidth = stage.stageWidth / colMax;
			imageHeight = stage.stageHeight / rowMax;
			
			//initVideo();
			
			for each (var mc:MovieClip in imageList)
			{
				mc.removeEventListener(Event.ENTER_FRAME, render);
				
				if (mc.child)
					Bitmap(mc.child).bitmapData.dispose();
				
				mc.child = null;
				
				container.addChild(mc);
			}
			
			for each (var bmd:BitmapData in imageBuffer)
			{
				bmd.dispose();
			}
			
			initBitmap();
		}
		
		private function updateBuffer(event:Event):void
		{
			if (bufferIndex < 0)
				bufferIndex = imageBuffer.length - 1;
			
			if (bufferIndex >= imageBuffer.length)
				bufferIndex = 0;
			
			var matrix:Matrix = new Matrix();
			matrix.scale(imageWidth / video.width, imageHeight / video.height);
			var bmd:BitmapData = imageBuffer[bufferIndex];
			bmd.draw(video, matrix);
			
			bufferIndex--;
		}
		
		
		private function render(event:Event):void
		{
			var mc:MovieClip = event.target as MovieClip;
			var bmp:Bitmap = mc.child;
			
			if (mc.index >= imageBuffer.length)
				mc.index = 0;
			
			if (mc.index < 0)
				mc.index = imageBuffer.length - 1;
			
			var bmd:BitmapData = imageBuffer[mc.index];
			bmp.bitmapData = bmd;
			bmp.smoothing = true;
			
			mc.index--;
		}

	}
}
