/**
 * Copyright Quasimondo ( http://wonderfl.net/user/Quasimondo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5eQM0
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.DisplayObject;
    import flash.utils.ByteArray;
    import flash.display.Sprite;
    
    public class BinaryMultiplication extends Sprite {
        
        private var binaryMap:Vector.<uint>;
        
        
        public function BinaryMultiplication() {
            
            stage.scaleMode = "noScale";
            stage.align = "TL";
            run();
           
            
        }
        
        private function run():void
        {
            var w:int = 256 * 6;
            var h:int = 256 * 6;
            var map:BitmapData = new BitmapData( w, h, false, 0xff434038 );
            
            binaryMap = map.getVector( map.rect );
            
            for ( var y:int = 0; y < 256; y++ )
            {
                for ( var x:int = 0; x < 256; x++ )
                {
                    var value:int = x*y;
                    var offset:int = y * 6 * w + x * 6;
                    for ( var i:int = 4; --i > -1; )
                    {
                        binaryMap[ offset + 4 - i ] = ( (value >> (i+12)) & 1 ? 0xffffffff : 0xff000000 );
                        binaryMap[ offset + 4 - i + w] = ( (value >> ( i + 8 ) ) & 1 ? 0xffffffff : 0xff000000 );
                        binaryMap[ offset + 4 - i + w + w] = ( (value >> (i + 4)) & 1 ? 0xffffffff : 0xff000000 );
                        binaryMap[ offset + 4 - i + w + w + w] = ( (value >> i ) & 1 ? 0xffffffff : 0xff000000 );
                    }
                }
            }

            map.setVector( map.rect, binaryMap );
            var b:DisplayObject = addChild( new Bitmap( map ) );
            b.scaleX = b.scaleY = 2;
            
        }
        

        
    }
}