/**
 * Copyright sandai ( http://wonderfl.net/user/sandai )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5eQ1
 */

//はじめてASさわって適当に作った見事なスパゲッティー
//これいじょうめんどくさいし時間がもったいないのでこの区切りで終わり。
//あ、でも音楽終わった後の処理忘れてた…。でももうやらん。
//JSで制御できるようにと思っていたのだけれど、
//ムキになって普通の簡易Flash音楽プライヤーになってしまった。
//ということで、
//もうしらないッ！


//音楽はこちら
//http://muzie.s3.amazonaws.com/songs182/yumeno.mp3
//http://www.heefoo.com/index.html


package {
	import flash.display.*;
	import flash.media.*;
	import flash.events.*;
	import flash.net.URLRequest;
	import flash.text.*;
	
	[SWF(width="150", height="30")]
	public class Mp3 extends Sprite {
		private var btn:SimpleButton;
		private var sound:Sound;
		private var soundChannel:SoundChannel;
		private var change:Boolean = false; // trueで再生, falseで停止
		private	var urlRequest:URLRequest;
		private var soundPosition:Number = 0;
		private var basePlayBar:Sprite;
		private var progressBar:Sprite;
		private var playBar:Sprite;
		private var statusStr:String;
		private var statusText:TextField;
		private var loadComp:Boolean = false; // trueでサウンドロードが完了したことにする
		
		public function Mp3() {
			btn = new SimpleButton();
			btn.upState = makeBase(makeTriangle(0x000000));
			btn.overState = makeBase(makeTriangle(0xffffff));
			btn.hitTestState = btn.upState;
			btn.x = 5;
			btn.y = 2.5;
			addChild(btn);
			btn.addEventListener(MouseEvent.MOUSE_DOWN, btnDown);
			
			basePlayBar = makeBasePlayBar();
			addChild(basePlayBar);
			progressBar = new Sprite();
			progressBar.buttonMode = true;
			addChild(progressBar);
			progressBar.addEventListener(MouseEvent.MOUSE_DOWN, clickProgressBar);
			
			playBar = new Sprite();
			playBar.buttonMode = true;
			addChild(playBar);
			playBar.addEventListener(MouseEvent.MOUSE_DOWN, clickPlayBar);
			
                        //音源
			urlRequest = new URLRequest("http://muzie.s3.amazonaws.com/songs182/yumeno.mp3");
			sound = new Sound(urlRequest);
			sound.addEventListener(ProgressEvent.PROGRESS,makeProgressBar);
			sound.addEventListener(Event.COMPLETE, completeSound);

			statusText = new TextField();
			statusText.autoSize = TextFieldAutoSize.CENTER;
			statusText.selectable = false;
			statusText.x = 110;
			statusText.y = 12.5;
			addChild(statusText);
		}
		
		//click button event
		private function btnDown(event:MouseEvent):void {
			if (loadComp == true && change == false) {
				change = true;
				btn.upState = makeBase(makeSquare(0x000000));
				btn.overState = makeBase(makeSquare(0xffffff));
				soundChannel = sound.play(soundPosition);
				addEventListener(Event.ENTER_FRAME, showStatus);
				addEventListener(Event.ENTER_FRAME, makePlayBar);
			} else if (loadComp == true && change == true) {
				change = false;
				btn.upState = makeBase(makeTriangle(0x000000));
				btn.overState = makeBase(makeTriangle(0xffffff));
				removeEventListener(Event.ENTER_FRAME, makePlayBar);
				soundPosition = soundChannel.position;
				soundChannel.stop();
			}
		}
		
		//click play bar
		private function clickPlayBar(event:MouseEvent):void {
			var numX:Number = event.localX;
			if (numX > 140) { numX = 140; }
			if (numX < 40) { numX = 40; }
			var soundP:Number = (numX - 40) / 100;
			if (change == true) { //鳴っているとき
				playBar.graphics.clear();
				soundPosition = sound.length * soundP;
				soundChannel.stop();
				soundChannel = sound.play(sound.length * soundP);
				playBar.addEventListener(MouseEvent.MOUSE_DOWN, clickPlayBar);
			} else if (change == false) { // 鳴っていないとき
				playBar.graphics.clear();
				soundPosition = sound.length * soundP;
				secondPlayBar(soundPosition);
				addEventListener(Event.ENTER_FRAME, showStatus);
				playBar.addEventListener(MouseEvent.MOUSE_DOWN, clickPlayBar);
			}
		}
		
		//click progress bar
		private function clickProgressBar(event:MouseEvent):void {
			var numX:Number = event.localX;
			if (numX > 140) { numX = 140; }
			if (numX < 40) { numX = 40; }
			var soundP:Number = (numX - 40) / 100;
			if (change == true) { //鳴っているとき
				soundChannel.stop();
				soundChannel = sound.play(sound.length * soundP);
				playBar.addEventListener(MouseEvent.MOUSE_DOWN, clickPlayBar);
			} else if (change == false) { //鳴っていないとき
				playBar.graphics.clear();
				soundPosition = sound.length * soundP;
				secondPlayBar(soundPosition);
				addEventListener(Event.ENTER_FRAME, showStatus);
				playBar.addEventListener(MouseEvent.MOUSE_DOWN, clickPlayBar);
			}
		}

		//create play bar
		private function secondPlayBar(position:Number):void {
			var length:Number = 100 * (position / sound.length);
			playBar.graphics.clear();
			playBar.graphics.lineStyle(5, 0xFF3399);
			playBar.graphics.moveTo(40, 7.5);
			playBar.graphics.lineTo(length + 40, 7.5);
		}
		
		//make play bar
		private function makePlayBar(event:Event):void {
			var length:Number = 100 * (soundChannel.position / sound.length);
			playBar.graphics.clear();
			playBar.graphics.lineStyle(5, 0xFF3399);
			playBar.graphics.moveTo(40, 7.5);
			playBar.graphics.lineTo(length + 40, 7.5);
		}
		
		//make progress bar
		private function makeProgressBar(event:ProgressEvent):void {
			var bar:Sprite = new Sprite();
			var length:Number = 100 * (event.bytesLoaded / event.bytesTotal);
			bar.graphics.lineStyle(5, 0xffffff);
			bar.graphics.moveTo(40, 7.5);
			bar.graphics.lineTo(length+40, 7.5);
			progressBar.addChild(bar);
		}
		
		//status
		private function showStatus(event:Event):void {
			if(change == true) {
				statusStr =  convertTimeValue(soundChannel.position) + " / " + convertTimeValue(sound.length);
				statusText.text = statusStr;
			} else if(change == false) {
				statusStr =  convertTimeValue(soundPosition) + " / " + convertTimeValue(sound.length);
				statusText.text = statusStr;
			}
		}
		
		//load flag
		private function completeSound(event:Event):void {
			loadComp = true;
		}
		
		//status ms→second
		private function convertTimeValue(n:Number):String {
			var m:String = ("00" + ((n / (1000 * 60)) >> 0)).substr( -2);
			var s:String = ("00" + (((n % (1000 * 60)) / 1000) >> 0)).substr( -2);
			return m + ":" + s;
		}
		
		//makeBasePlayBar
		private function makeBasePlayBar():Sprite {
			var bar:Sprite = new Sprite();
			bar.graphics.lineStyle(10, 0x000000);
			bar.graphics.moveTo(40, 7.5);
			bar.graphics.lineTo(140, 7.5);
			return bar;
		}
		
		//btnBase, param:makeTriangle(color) or makeSquare(color)
		private function makeBase(shape:Sprite):Sprite {
			var btnBoard:Sprite = new Sprite();
			btnBoard.graphics.lineStyle(3);
			btnBoard.graphics.beginFill(0xFF3399);
			btnBoard.graphics.drawRoundRect(0, 0, 25, 25, 1);
			btnBoard.graphics.endFill();
			btnBoard.addChild(shape);
			return btnBoard;
		}
		
		//▲
		private function makeTriangle(color:uint):Sprite {
			var tri:Sprite = new Sprite();
			tri.graphics.lineStyle(1, color);
			tri.graphics.beginFill(color);
			tri.graphics.moveTo(5, 3);
			tri.graphics.lineTo(22, 12.5);
			tri.graphics.lineTo(5, 22.0);
			tri.graphics.lineTo(5, 3);
			tri.graphics.endFill();
			return tri;
		}
		
		//■
		private function makeSquare(color:uint):Sprite {
			var square:Sprite = new Sprite();
			square.graphics.lineStyle(1, color);
			square.graphics.beginFill(color);
			square.graphics.drawRoundRect(4, 4, 17, 17, 1);
			square.graphics.endFill();
			return square;
		}
	}
}