/**
 * Copyright Albert ( http://wonderfl.net/user/Albert )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5drS
 */

// forked from andyshang's depth sort
package
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Rectangle;
    import flash.ui.Keyboard;
    
    [SWF(width="465", height="465", backgroundColor="#FF0FFF")]
    public class Main extends Sprite
    {
        private var keyManager:KeyManager = new KeyManager();
        private var debugSprite:Sprite;
        
        public function Main()
        {
            var canvas:Canvas = new Canvas();
            
            drawDebugRect = function(x:int, y:int):void
            {
                debugSprite.graphics.clear();
                debugSprite.graphics.lineStyle(2,0xAB0000);
                debugSprite.graphics.drawRect(
                    x * Tile.tileSize + canvas.viewPort.x,
                    y*Tile.tileSize + canvas.viewPort.y
                    , Tile.tileSize, Tile.tileSize);
            };
            
            
            addChild(canvas);
            canvas.viewPort = new Rectangle(0,0,stage.stageWidth, stage.stageHeight); 
            canvas.panTo(canvas.role.x * 16, canvas.role.y * 16);
            
            debugSprite = new Sprite();
            //addChild(debugSprite);
            
            keyManager.listen(stage); 
        
            addEventListener(Event.ENTER_FRAME, function(event:Event):void
            {
                if(keyManager.isDown(Keyboard.UP))
                {
                    canvas.role.move(0,-1)
                }
                if(keyManager.isDown(Keyboard.DOWN))
                {
                    canvas.role.move(0,1)
                }
                if(keyManager.isDown(Keyboard.LEFT))
                {
                    canvas.role.move(-1,0)
                }
                if(keyManager.isDown(Keyboard.RIGHT ))
                {
                    canvas.role.move(1,0)
                }
            })
        }
    }
}

import flash.display.DisplayObject;
import flash.display.DisplayObjectContainer;
import flash.display.Graphics;
import flash.display.Shape;
import flash.display.Sprite;
import flash.display.Stage;
import flash.events.KeyboardEvent;
import flash.geom.Matrix;
import flash.geom.Rectangle;
 
class Canvas extends Sprite
{
    public static var mapWidth:int = 19;
    
    private var _viewPort:Rectangle;
    public function set viewPort(viewPort:Rectangle):void
    {
        _viewPort = viewPort;
        draw();
    }
    
    public function get viewPort():Rectangle
    {
        return _viewPort;
    }
    
    public var role:Role;
    
    private var tiles:Vector.<Tile> = new Vector.<Tile>;
    private var depthIndexTable:Array = []
    
    public var back :Sprite=new Sprite();
    public var front:Sprite=new Sprite();
    
    public function Canvas()
    {
        addChild(back);
        addChild(front);
        var tile:Tile;
        for(var i:int=0;i<pathMap.length;i++)
        {
            if(pathMap[i] == "0")
            {
                tile = new Grass();
            }
            else if(pathMap[i] == "1")
            {
                tile = new Floor();
            }            
            else if(pathMap[i] == "x")
            {
                tile = new Block();
            }
            else if(pathMap[i] == "w")
            {
                tile = new Wall();
            }
            else if(pathMap[i] == "A")
            {
                role = new Role();
                tile = role;
            }
            else
            {
                continue; 
            }
            tile.x = i % mapWidth;
            tile.y = i / mapWidth;
            tile.container = this;
            tiles.push(tile);
            if (tile.asset)
            { 
                if(isNaN(depthIndexTable[tile.y]))
                {
                    depthIndexTable[tile.y] = 0;
                }
                depthIndexTable[tile.y]++;
            }
        }
    }
    
    public function updateDepth(object:Tile, from:int, to:int):void
    {
        //look up depth table first
        var depth:int = 0;
        depthIndexTable[from] --;
        depthIndexTable[to] ++;
        for(var i:int;i<=to;i++)
        {
            depth += depthIndexTable[i];
        }
        object.setDepth(depth);
        if(depth == 0 || depth == front.numChildren)
        {
            return;
        }
        if(object.asset.y < front.getChildAt(depth-1).y)
        {
            depth -= depthIndexTable[i-1];
            object.setDepth(depth);
        }
        //now the object's depth is highest in the same line.
        //adjust by asset.y , to see if it should be put to next line.
        //for the map is closed, we do not check out of range.
        if(object.asset.y > front.getChildAt(depth+1).y)
        {
            depth += depthIndexTable[i];
            object.setDepth(depth);
        }
    }
    
    public function pan(x:int ,y:int):void
    {
        _viewPort.x -= x;
        _viewPort.y -= y;
        draw();
    }
    
    public function panTo(x:int ,y:int):void
    {
        _viewPort.x = x;
        _viewPort.y = y;
        draw();
    }
    
    public function draw():void
    {
        for each(var tile:Tile in tiles)
        {
            tile.render(_viewPort);
        }
    }
}

class Tile
{ 
    public static var tileSize:int = 64;
    
    public var x:int;
    public var y:int;
    
    public var container:Canvas;
    public var asset:Shape=null;
    public var assetBack:Shape=null;
    protected var rect:Rectangle;
    
    public function render(rect:Rectangle):void
    {
        this.rect = rect;
        if (assetBack) {
            if(!container.back.contains(assetBack))
            {
                container.back.addChild(assetBack);
            }
            assetBack.x = x * tileSize + rect.x;
            assetBack.y = y * tileSize + rect.y; 
        }        
        if (asset) { 
            if(!container.front.contains(asset))
            {
                container.front.addChild(asset);
            }
            asset.x = x * tileSize + rect.x;
            asset.y = y * tileSize + rect.y;
        }
    }
    
    public function setDepth(depth:int):void
    {
        if (asset)
            container.front.setChildIndex(asset, depth);         
    }
}

class Role extends Tile
{
    public static const SPEED:Number = 5;
        
    public function Role():void
    {
        asset = new Shape();
        asset.graphics.beginFill(0x0, 1.0);
        asset.graphics.drawRoundRect(tileSize/4,-tileSize*.5,tileSize/2,1.5*tileSize,8,8);
        asset.graphics.beginFill(0x202020, 1.0);
        asset.graphics.lineStyle(1, 0xffffff, 0.5, true);
        asset.graphics.drawRoundRect(tileSize/4,-tileSize*.5,tileSize/2,0.5*tileSize,8,8);
    }
        
    public function move(dx:int, dy:int):void
    {
        moved = true
        container.pan(dx * SPEED, dy * SPEED);
        
        var lastY:int = y;
        x = Math.round((asset.x - rect.x) / tileSize);
        y = Math.round((asset.y - rect.y) / tileSize);

        //swap depth if y changed
        if(pathMap[y*Canvas.mapWidth + x] == "x" || pathMap[y*Canvas.mapWidth + x] == "w")
        {
            container.pan(-dx * SPEED, -dy * SPEED);
            return;
        }        

        
        if(dy != 0)
        {
            container.updateDepth(this, lastY, y); 
        }
        drawDebugRect(x,y);
    }
    
    private var moved:Boolean = false;
    override public function render(rect:Rectangle):void
    {
        if(!moved)
        {
            super.render(rect);
        }
    }
}

class Block extends Tile
{    
    private var colors:Array = [0xFF0000, 0xFFFF00, 0x00FF00, 0x00FFFF, 0x0000FF, 0xFF00FF, 0xFF0000];
    private var alphas:Array = [100, 100, 100, 100, 100, 100, 100];
    private var ratios:Array = [0x00, 0x2A, 0x55, 0x7F, 0xAA, 0xD4, 0xFF];
    
    public function Block()
    {
        assetBack = new Shape();
        asset = new Shape();
        assetBack.graphics.beginFill(0xa0f0a0, 1);
        assetBack.graphics.drawRect(0,0,tileSize,tileSize);  
        asset.graphics.beginFill(0x806060, 1);
        asset.graphics.drawRect(16,0,tileSize-32,tileSize-4);
        asset.graphics.beginFill(0x80A080, 1);
        //asset.graphics.lineStyle(1);
        asset.graphics.drawRoundRect(1,-.5*tileSize,tileSize-2,tileSize,8,8);
        asset.graphics.beginFill(0xA0D0A0, 1.0);
        asset.graphics.lineStyle(1, 0xffffff, 0.5, true);
        asset.graphics.drawRoundRect(1,-.9*tileSize,tileSize-2,tileSize,8,8);        
    }
}

class Wall extends Tile {
    function Wall(){
        var color:uint=0x606060;
        asset = new Shape();
        asset.graphics.lineStyle(1, color);
        asset.graphics.beginFill(color);
        asset.graphics.drawRect(0,0,tileSize,tileSize);        
        asset.graphics.endFill();

        var offsx:int=0;
        var offsy:int=-tileSize/2;
        color=0x808080;
        
        asset.graphics.lineStyle(1, color);
        asset.graphics.beginFill(color);
        asset.graphics.drawRect(offsx,offsy,tileSize,tileSize);
        asset.graphics.endFill();

        color=0x909090;
        var size:int=tileSize/2-2;
        var r:int=tileSize/4-1;
        asset.graphics.lineStyle(1, color);
        //this.graphics.beginFill(color);
        asset.graphics.drawRoundRect(2+offsx,   2+offsy,   size,size, r,r);
        asset.graphics.drawRoundRect(2+size+offsx, 2+offsy,   size,size, r,r);
        asset.graphics.drawRoundRect(2+offsx,   2+size+offsy, size,size, r,r);
        asset.graphics.drawRoundRect(2+size+offsx, 2+size+offsy, size,size, r,r);     
    }
}

class Floor extends Tile
{    
    public function Floor()
    {
        assetBack = new Shape();
        assetBack.graphics.beginFill(0x444444, 1);
        assetBack.graphics.drawRect(0,0,tileSize,tileSize);  
    }

}

class Grass extends Tile
{    
    public function Grass()
    {
        assetBack = new Shape();
        assetBack.graphics.beginFill(0xa0f0a0, 1);
        assetBack.graphics.drawRect(0,0,tileSize,tileSize);  
    }
}



interface IKeyboard
{
    function actPress(keyCode:int, shift:Boolean):void;
    function actRelease(keyCode:int, shift:Boolean):void;
}

class KeyManager
{
    private var _isDownFunc:Function;
    private var downKeys:Vector.<int> = new Vector.<int>(256);
    private var keyboards:Vector.<IKeyboard> = new Vector.<IKeyboard>;
    
    private var isLocked:Boolean = false;
    
    public function addKeyboard(keyboard:IKeyboard):void
    {
        keyboards.push(keyboard);
    }
    
    
    public function lock():void
    {
        isLocked = true;
    }
    
    public function unlock():void
    {
        isLocked = false;
    }
    
    public function listen(stage:Stage):void
    {
        stage.addEventListener(KeyboardEvent.KEY_UP, function(event:KeyboardEvent):void
        {
            actRelease(event.keyCode, Boolean(downKeys[event.keyCode] & 0x100));
            downKeys[event.keyCode] = 0;
        })
        
        stage.addEventListener(KeyboardEvent.KEY_DOWN, function(event:KeyboardEvent):void
        {
            if(isDown(event.keyCode))
            {
                return;
            }
            actPress(event.keyCode, event.shiftKey);
            downKeys[event.keyCode] = 1;
        })
        _isDownFunc = function(keyCode:int):Boolean
        {
            return downKeys[keyCode] > 0;
        }
    }
    
    public function isDown(keyCode:int):Boolean
    {
        return _isDownFunc(keyCode);
    }
    
    public function actPress(keyCode:int, shift:Boolean):void
    {
        for each(var k:IKeyboard in keyboards)
        {
            k.actPress(keyCode, shift);
        }
    }
    
    public function actRelease(keyCode:int, shift:Boolean):void
    {
        for each(var k:IKeyboard in keyboards)
        {
            k.actRelease(keyCode, shift);
        }
    }
}
var pathMap:Array = 
"\
wwwwwwwwwwwwwwwwwww\
w    w11111111w111w\
w  A w11111w11ww1ww\
w    w11111w111111w\
www wwww11wwwww11ww\
x000000x00x0000000x\
x00x000x00x000xxxxx\
x0000xxx00x0000000x\
x0x0000000xxxxxx00x\
x0000xx000x0000000x\
x000000000000x0000x\
xxxxxxxxxxxxxxxxxxx\
".
split("");

var drawDebugRect:Function;