/**
 * Copyright tsu_droid ( http://wonderfl.net/user/tsu_droid )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5czN
 */

// forked from shapevent's Perlin Outlines
package {

        // perlin outlines
        // move your mouse around
        // http://actionsnippet.com/?p=1878 
    import flash.display.*;
    import flash.geom.*;
    import flash.events.*;
        import flash.filters.*;


    [SWF(width = 600, height=600, backgroundColor=0xCCCCCC, frameRate=24)]

       public class PerlinOutlines extends MovieClip {
        private var canvas:BitmapData;
        private var blur:BitmapData;
        private var w:int;
        private var hw:int;
        private var size:int;
        private var seed:Number;
        private var pnt:Point;
        private var dy:Number;
        private var dx:Number;
        private var blr:BlurFilter;
        
        private var shape0:Shape = new Shape();
        private var gr:Graphics = shape0.graphics;


        public function PerlinOutlines(){
            // init
            canvas = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x000000);
            blur = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x000000);
            addChild(new Bitmap(canvas, "auto", true));
            w = canvas.width
            hw = w / 2;
            size = w * w;
            seed = Math.random()*100;
            pnt = new Point();
            dy = 0, dx = 0;
            blr = new BlurFilter(10,10,1);
            
            addChild(shape0);
            gr.lineStyle (1, 0x000000, 1.0); 
            gr.beginFill (0x666666, 1.0);   
            gr.drawCircle  ( stage.stageWidth/2, stage.stageHeight/2, stage.stageWidth/2*0.98);
            this.mask = shape0;

            addEventListener(Event.ENTER_FRAME, onLoop);
            

               }
               // private methods

        private function onLoop(evt:Event):void {
            dx += (mouseX - dx) / 4;
            dy += (mouseY - dy) / 4;
            canvas.lock();
            canvas.perlinNoise(hw,hw,2,seed,false, false, 1, true, [new Point(dx, dy), new Point(-dx, -dy)]);
            var pix:Vector.<uint> = canvas.getVector(canvas.rect);
            for (var i:int = 0; i<size; i++){
                var col:uint = 255 - pix[i] <<4 & 0x00FF00;
                pix[i] = col <<8 | col | col>> 8;
            }
            canvas.setVector(canvas.rect, pix);
            blur.copyPixels(canvas, canvas.rect, pnt);
            blur.applyFilter(blur, blur.rect, pnt, blr);
            canvas.draw(blur, null, null, BlendMode.DIFFERENCE);
            canvas.draw(canvas, null, null, BlendMode.INVERT);
            canvas.unlock();
        }
        

       }

}