/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5cy6
 */






package 
{
    import flash.events.Event;
    import flash.geom.Point;
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    
    
    public class PinkPerlin extends Sprite 
    {
        private const SW:Number = stage.stageWidth;
        private const SH:Number = stage.stageHeight;
        private var canvasBitmapData:BitmapData;
        private var canvas:Bitmap;
        private var offsets:Array=[];
        private var speeds:Array=[];
        private var octaves:int=2;
        
        public function PinkPerlin() 
        {            
            canvasBitmapData = new BitmapData( SW,SH,true );
            canvas = new Bitmap(canvasBitmapData);
            addChild(canvas);
            
            for(var i:int; i<octaves; i++)
            {
                offsets[i] = new Point(0,0);
            }
            
            speeds[0] = new Point(-2,-1); 
            speeds[1] = new Point(2,1); 
            addEventListener(Event.ENTER_FRAME, tick);  

        }
        
        private function tick(e:Event):void
        {
            for(var i:int=0;i<octaves;i++)
            {
                offsets[i].x += speeds[i].x;
                offsets[i].y += speeds[i].y;
            }
            canvasBitmapData.perlinNoise(174,217,octaves,3,false,true,13,false,offsets);
            //canvasBitmapData.perlinNoise(174,217,octaves,20950,false,true,13,false,offsets);
        }
    }

}