/**
 * Copyright civet ( http://wonderfl.net/user/civet )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5ckc
 */

//2011-02-14 01:15:17
package
{
    import flash.display.*;
    import flash.events.*;
    import flash.filters.GlowFilter;
    import flash.geom.Matrix;
    import flash.media.Sound;
    import flash.net.URLRequest;
    import flash.text.TextField;
    import flash.text.TextFormat;
    
    [SWF(backgroundColor="0xffffff", frameRate="25")]
    
    public class Cardioid extends Sprite
    {
        public function Cardioid()
        {
            this.addEventListener(Event.ADDED_TO_STAGE, onAdded);
        }
        private function onAdded(e:Event):void
        {
            this.removeEventListener(Event.ADDED_TO_STAGE, onAdded);
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            init();
        }
        
        
        private var _buffer:BitmapData;
        private var _sparkleBuffer:BitmapData;
        private var _sparkleMatrix:Matrix;
        
        private function init():void
        {
            graphics.beginFill(0xff99cc);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            graphics.endFill();
            
            _buffer = new BitmapData(320, 240, true, 0x0);
            var canvas:Bitmap = new Bitmap(_buffer);
            canvas.x = (stage.stageWidth - canvas.width) >> 1;
            canvas.y = (stage.stageHeight - canvas.height) >> 1;
            this.addChild(canvas);
                     
            var scale:Number = 4;
            _sparkleBuffer = new BitmapData(320/scale, 240/scale, true, 0x0);
            var sparkle:Bitmap = new Bitmap(_sparkleBuffer, "never", true);
            sparkle.scaleX = scale;
            sparkle.scaleY = scale;
            sparkle.x = (stage.stageWidth - sparkle.width) >> 1;
            sparkle.y = (stage.stageHeight - sparkle.height) >> 1;
            sparkle.blendMode = BlendMode.ADD;
            sparkle.alpha = 0.5;
            this.addChild(sparkle);
            
            _sparkleMatrix = new Matrix(1/scale, 0, 0, 1/scale, 0, 0);
            
            var label:TextField = new TextField();
            label.mouseEnabled = false;
            label.selectable = false;
            label.defaultTextFormat = new TextFormat('_san', 36, 0x808080, true);
            label.autoSize = "left";
            label.text = "Happy Valentine's Day!";
            label.x = (stage.stageWidth - label.width) >> 1;
            label.y = (stage.stageHeight - label.height) >> 1;
            this.addChild(label);
            
            label.filters = [new GlowFilter(0xffffff, 1, 4, 4, 2)];
            
            //Cardioid -DATEKEN(http://piapro.jp/t/kr-3)
            new Sound(new URLRequest("http://c1.piapro.jp/amp3/32iqmw1uicn6shoc_20100214210520_audition.mp3")).play();
            
            this.addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function draw(target:BitmapData, ox:int, oy:int, size:Number, rotation:Number, color:uint=0x0):void
        {
            var a:Number = size;
            var r:Number, px:Number, py:Number;
            for(var j:int=0; j < 360; j+=4)
            {
                for(var i:int=0; i < 360; i+=4)
                {
                    //Cardioid
                    var theta:Number = Math.PI/180 * (i + rotation);
                    r = a * (1 - Math.sin(theta));
                    px = r * Math.cos(theta);
                    py = r * Math.sin(theta);
                    
                    //deco
                    var phi:Number = Math.PI/180 * j;
                    px *= phi * Math.sin(phi) * 1.1;
                    py *= phi;
                    
                    target.setPixel32(px + ox, -py + oy, color);
                }
            }
        }
        
        private var t:int = 0;
        public function onEnterFrame(e:Event):void
        {
            var size:Number = Math.sin(0.01745 * t) * 0.5 + 16;
            t = (t + 12) % 360;
            
            _buffer.lock();
            _buffer.fillRect(_buffer.rect, 0x0);
            draw(_buffer, 160, 32, size, t/24, 0xffffffff);
            _buffer.unlock();
            
            _sparkleBuffer.lock();
            _sparkleBuffer.fillRect(_sparkleBuffer.rect, 0x0);
            _sparkleBuffer.draw(_buffer, _sparkleMatrix);
            _sparkleBuffer.unlock();
        }
    }
}