/**
 * Copyright junab ( http://wonderfl.net/user/junab )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5cDt
 */

// forked from nilab's Tweener's Tweens
// マウスクリックするといろんな41種類のトランジション効果を適用して移動するサンプル。
// クリックする度に移動スピードがダウンしていく。
package {
 
  import flash.display.*;
  import flash.text.*;
  import flash.events.*;
  import caurina.transitions.Tweener;
 
  [SWF(width="600", height="600", backgroundColor="#000000", frameRate="30")]
 
  public class TweenersTweens2 extends Sprite {
 
    private var nextpos:Number = 20;
    private var speed:Number   = 0.1;
 
    private var colors:Array = [
      0xffffff, // WHITE
      0xff0000, // RED
      0x00ff00, // GREEN
      0x00ffff, // CYAN
      0xff00ff, // MAGENTA
      0xffc800, // ORANGE
      0xffafaf, // PINK
      0xffff00, // YELLOW
    ];
 
    private var names:Array = [
      "linear",
      "easeinquad",    "easeoutquad",    "easeinoutquad",    "easeoutinquad",
      "easeincubic",   "easeoutcubic",   "easeinoutcubic",   "easeoutincubic",
      "easeinquart",   "easeoutquart",   "easeinoutquart",   "easeoutinquart",
      "easeinquint",   "easeoutquint",   "easeinoutquint",   "easeoutinquint",
      "easeinsine",    "easeoutsine",    "easeinoutsine",    "easeoutinsine",
      "easeincirc",    "easeoutcirc",    "easeinoutcirc",    "easeoutincirc",
      "easeinexpo",    "easeoutexpo",    "easeinoutexpo",    "easeoutinexpo",
      "easeinelastic", "easeoutelastic", "easeinoutelastic", "easeoutinelastic",
      "easeinback",    "easeoutback",    "easeinoutback",    "easeoutinback",
      "easeinbounce",  "easeoutbounce",  "easeinoutbounce",  "easeoutinbounce"
    ];
 
    private var texts:Object   = {};
 
    public function TweenersTweens2() {
      loaderInfo.addEventListener(Event.COMPLETE, onLoaded);
    }
 
    private function onLoaded(event:Event):void{
 
      const offset:Number = 20;
      const unitHeight:Number = Number(loaderInfo.height - offset * 2) / Number(names.length);
 
      for (var i:int=0; i<names.length; i++) {
        var tf:TextField = new TextField();
        tf.text          = names[i];
        tf.autoSize      = TextFieldAutoSize.CENTER;
        tf.textColor     = colors[i % colors.length];
        // scaling
        var scale:Number = Number(tf.height) / unitHeight; // なんか分母と分子が逆な気が……
        tf.scaleX = scale;
        tf.scaleY = scale;
        // position
        tf.x = nextpos;
        tf.y = unitHeight * i + offset;
        // add
        addChild(tf);
        texts[names[i]] = tf;
      }
 
      stage.addEventListener(MouseEvent.CLICK, function(event:MouseEvent):void {
        var center:Number = loaderInfo.width / 2.0 - 80;
        nextpos = (nextpos - center) * -1 + center;
        speed = speed * 1.5;
        for (var i:int=0; i<names.length; i++) {
          Tweener.addTween(texts[names[i]], {x:nextpos, time:speed, transition:names[i]});
        }
      });
    }
 
  }
}
