/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5cBk
 */

package  {
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.media.Sound;
    import flash.media.SoundTransform;
    import flash.net.*;
    import flash.system.LoaderContext;
    import caurina.transitions.Tweener;
    import flash.utils.Timer;
    import net.hires.debug.Stats;
    
    import Box2D.Collision.*;
    import Box2D.Collision.Shapes.*;
    import Box2D.Common.Math.*;
    import Box2D.Dynamics.*;
    
    import com.bit101.components.*;

    public class Coins extends Sprite {
        //private var imgs:Array = [];
        private var radiuses:Array = [
            10, 11, 11.75, 10.5, 11.3, 13.25
        ];
        private var densities:Array = [
            2.066947313, 6.488961867, 7.980747225, 7.699105335, 7.038588188, 6.345800508
        ];
        private var coinsThreshold:int = 20;
        private var coins:Array = [];
        
        private static const DRAW_SCALE:Number = 100;
        private var world:b2World;
        
        public function Coins() {
            
            var g:Graphics = graphics;
            g.beginFill(0xdddddd);
            g.drawRect(0, 0, stage.stageWidth, stage.stageHeight);

            init();
            debugDraw();
        }
        private function init():void 
        {
            //world
            var worldAABB:b2AABB = new b2AABB();
            worldAABB.lowerBound.Set(-100, -100);
            worldAABB.upperBound.Set(100, 100);
            var gravity:b2Vec2 = new b2Vec2(0, 10);
            world = new b2World(worldAABB, gravity, true);
            
            //wall
            makeWall();

            addEventListener(Event.ENTER_FRAME, enterFrameHandler);

            
            stage.addEventListener(MouseEvent.MOUSE_DOWN, function ():void 
            {
                addCoin();
            });
        }
        private function addCoin():void 
        {
            var i:int = Math.floor(Math.random() * radiuses.length);
            addCircle(
                mouseX, mouseY, 
                radiuses[i] * 4, 
                densities[i]);
        }
        private function debugDraw():void 
        {
            var debugDraw:b2DebugDraw = new b2DebugDraw();
            debugDraw.m_sprite = this;
            debugDraw.m_drawScale = DRAW_SCALE;
            debugDraw.m_fillAlpha = 0.3;
            debugDraw.m_lineThickness = 1;
            debugDraw.m_drawFlags = b2DebugDraw.e_shapeBit | b2DebugDraw.e_jointBit;
            world.SetDebugDraw(debugDraw);
        }
        private function makeWall():void {
            
            var bd:b2BodyDef = new b2BodyDef();
            bd.position.Set(0, 0);
            
            var wall:b2Body = world.CreateBody(bd);
            
            var w:Number = stage.stageWidth / DRAW_SCALE;
            var h:Number = stage.stageHeight / DRAW_SCALE;
            var wallSize:Number = 50 / DRAW_SCALE;
            
            var sd:b2PolygonDef = new b2PolygonDef();
            sd.filter.categoryBits = parseInt("010",2);
            
            //top
            sd.SetAsOrientedBox(w / 2 + wallSize * 2, wallSize, new b2Vec2(w / 2, -wallSize - h/2));
            wall.CreateShape(sd);
            //bottom
            sd.SetAsOrientedBox(w / 2 + wallSize * 2, wallSize, new b2Vec2(w / 2,  h + wallSize));
            wall.CreateShape(sd);
            //left
            sd.SetAsOrientedBox(wallSize, h, new b2Vec2(-wallSize, h / 2));
            wall.CreateShape(sd);
            //right
            sd.SetAsOrientedBox(wallSize, h, new b2Vec2(w + wallSize,  h / 2));
            wall.CreateShape(sd);

        }
        
        
        private function enterFrameHandler(event:Event):void {
            for (var b:b2Body = world.GetBodyList(); b; b = b.GetNext()) {
                if (b.GetUserData() is Sprite) {
                    if (b.GetWorldCenter().y *DRAW_SCALE > 500)
                    {
                        removeChild(b.GetUserData());
                        world.DestroyBody(b);
                    }
                    else
                    {
                        b.GetUserData().x = b.GetWorldCenter().x * DRAW_SCALE;
                        b.GetUserData().y = b.GetWorldCenter().y * DRAW_SCALE;
                        b.GetUserData().rotation = b.GetAngle() * 180 / Math.PI;
                    }
                }
            }
            if (coinsThreshold < coins.length)
            {
                var coinsLeft:int = coinsThreshold * Math.random() * 0.5;
                coinsThreshold = Math.random() * 10 + 20;
                while(coinsLeft < coins.length)
                {
                    var b1:b2Body = coins.shift() as b2Body;
                    var sp:b2Shape = b1.GetShapeList();
                    var f:b2FilterData = new b2FilterData();
                    
                    f.maskBits = parseInt("001",2);
                    sp.SetFilterData(f);
                    world.Refilter(sp);
                }
            }
        
            world.Step(1 / stage.frameRate, 10);
        }
        
        private function addCircle(posX:Number , posY:Number, radius:Number, density:Number):void 
        {
            //body def
            var bd:b2BodyDef = new b2BodyDef();
            bd.position.Set(posX / DRAW_SCALE, posY / DRAW_SCALE);
            
            //shape def
            var sd:b2CircleDef = new b2CircleDef();
            sd.radius = radius / DRAW_SCALE;
            sd.density = density;
            sd.restitution = 0.5;
 
            var sh:Shape = new Shape();
            sh.graphics.lineStyle(0,0x0);
            sh.graphics.beginFill(0x0,0.2);
            sh.graphics.drawCircle(0,0,radius);
            sh.graphics.endFill();
            //sh.x = sh.y = -radius;
            //body
            var body:b2Body = world.CreateBody(bd);
            body.CreateShape(sd);
            body.SetMassFromShapes();
            var num:Number = Math.random() - 0.5;
            body.SetAngularVelocity(num * Math.PI*2 * 10);
            body.SetLinearVelocity(new b2Vec2(num * 10, -Math.random() * 2 - 5));
            
            body.m_userData = new Sprite();
            body.GetUserData().x = body.GetWorldCenter().x * DRAW_SCALE;
            body.GetUserData().y = body.GetWorldCenter().y * DRAW_SCALE;
            //body.GetUserData().addChild(bmp);
            body.GetUserData().addChild(sh);
            
            coins.push(body);
            addChild(body.GetUserData());
        }
    }
}

