/**
 * Copyright Kay ( http://wonderfl.net/user/Kay )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5b1b
 */

// forked from mash's QuickBox2D sample
package {
    import flash.display.*;
    import com.actionsnippet.qbox.*;
    import flash.geom.*;
    import flash.events.*;

    public class FlashTest extends MovieClip {
    		public var circles:Array = new Array();
        public var nColor:int = 0x66ccff;
        public var sim:QuickBox2D;
        private const SW:Number = stage.stageWidth;
        private const SH:Number = stage.stageHeight;
        public var steps:Array = new Array();
        public var stepNum:int = 8;
        public var stepStroke:Number = (SH+20)/30;
        
        public function FlashTest():void {
            // write as3 code here..
 
            stage.frameRate = 60;
 
            sim = new QuickBox2D(this, { debug:true, gravityY:10 });

			// BALLS
			for (var b:int = 0; b < 8; b++) {
            		sim.addCircle({draggable:false, x:(SW/2-120)/30, y:SH/2/30, radius:16/30, restitution:0.1, allowSleep:false });
			}

            // SHOOT SYSTEM
			const DCX:Number = (SW/2+160)/30; 
        		const DCY:Number = (SH/2)/30; 
            var dumper:QuickObject = sim.addBox({x:DCX, y:DCY, width:36/30, height:60/30 });
	        var stopperL:QuickObject = sim.addBox({x:DCX-16/30, y:DCY-10/30, width:2/30, height:2/30, density:0});
            var stopperR:QuickObject = sim.addBox({x:DCX+16/30, y:DCY-10/30, width:2/30, height:2/30, density:0});
            sim.addBox({x:DCX-20/30, y:DCY+65/30, width:4/30, height:180/30, density:0, friction:0});
            sim.addBox({x:DCX+20/30, y:DCY+65/30, width:4/30, height:180/30, density:0, friction:0});
            sim.addBox({x:DCX, y:DCY+153/30, width:36/30, height:4/30, density:0, friction:0});
			sim.addJoint({a:dumper.body, b:stopperL.body, x1:DCX-15/30, y1:DCY, frequencyHz:1, dampingRation:1 });            
			sim.addJoint({a:dumper.body, b:stopperR.body, x1:DCX+15/30, y1:DCY, frequencyHz:1, dampingRation:1 });            
            
            // AROUND CORNER
            var RCX:Number = (SW/2)/30;
            var RCY:Number = 150/30;
            var pNum:int = 20;
            var pWidth:Number = 28/30;
            var pRadius:Number = 180/30;
            var roofParts:Array = new Array();
            for (var i:int=1; i < pNum; i++) {
            		var r:Number = Math.PI/pNum*i+Math.PI;
            		sim.addBox({x:RCX+pRadius*Math.cos(r), y:RCY+pRadius*Math.sin(r), width:pWidth, height:4/30, angle:r+Math.PI/2, density:0});
            }
            
            // SIDE WALL
            sim.addBox({x:(SW-4)/30, y:SH/2/30, width:4/30, height:(SH+60)/30, density:0});
            sim.addBox({x:52/30, y:(SH/2+32)/30, width:4/30, height:(SH-206)/30, density:0});
            
            // BOTTOM
            sim.addBox({x:SW/2/30,y:(SH-50)/30, width:(SW-98)/30, height:4/30, angle:0.1, density:0});
            
            
            // CONVEYOR
            var stepStep:Number = stepStroke/stepNum;
            for (i = 0; i < stepNum; i++) {
            		var step:QuickObject = sim.addBox({x:(SW-26)/30, width:36/30, height:0.1, angle:0.1, density:0});
            		step.y = (SH+10)/30-i*stepStep;
            		steps.push(step);
            }
       		addEventListener(Event.EXIT_FRAME, xLoop);
       		
            // CUSSION
            sim.addCircle({x:70/30, y:(SH/2-80)/30, restitution:0.7, density:0});
            
       		// PINS
       		sim.setDefault( {radius:0.1, density:0, restitution:0.7} );

       		sim.addCircle({x:(SW/2-60)/30, y:(SH/2-90)/30});
       		sim.addCircle({x:(SW/2+0)/30,  y:(SH/2-90)/30});
       		sim.addCircle({x:(SW/2+60)/30, y:(SH/2-90)/30});
 		
       		sim.addCircle({x:(SW/2-90)/30, y:(SH/2-40)/30});
       		sim.addCircle({x:(SW/2-30)/30, y:(SH/2-40)/30});
       		sim.addCircle({x:(SW/2+30)/30, y:(SH/2-40)/30});
       		sim.addCircle({x:(SW/2+90)/30, y:(SH/2-40)/30});
 		
       		sim.addCircle({x:(SW/2-60)/30, y:(SH/2+10)/30});
       		sim.addCircle({x:(SW/2+0)/30,  y:(SH/2+10)/30});
       		sim.addCircle({x:(SW/2+60)/30, y:(SH/2+10)/30});

       		sim.addCircle({x:(SW/2-90)/30, y:(SH/2+60)/30});
       		sim.addCircle({x:(SW/2-30)/30, y:(SH/2+60)/30});
       		sim.addCircle({x:(SW/2+30)/30, y:(SH/2+60)/30});
       		sim.addCircle({x:(SW/2+90)/30, y:(SH/2+60)/30});
 		
			sim.start();
			dumper.y = (SH/2+120)/30;
			
			
			sim.mouseDrag();
			
        }
        
        private function xLoop(e:Event):void {
        		for (var i:int = 0; i < stepNum; i++) {
        			steps[i].y-=0.01;
        			if (steps[i].y < -10/30) {
        				steps[i].y += stepStroke;
        				steps[i].angle = 0.1;
        			} else if (steps[i].y < (SH/2-80)/30) {
        				steps[i].angle = 0.1;
        			} else if (steps[i].y < (SH/2-60)/30) {
        				steps[i].angle = -0.5;
        			}
        		}
        }
    }
}