/**
 * Copyright minodisk ( http://wonderfl.net/user/minodisk )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5ar3
 */

package
{
	import flash.display.Sprite;
	import flash.system.Capabilities;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	import flash.utils.ByteArray;
	
	[SWF(width="465", height="465", backgroundColor="0xFFFFFF", frameRate="30")]
	public class UnicodeFFFE extends Sprite
	{
		private var _textField:TextField;
		
		public function UnicodeFFFE()
		{
			_textField = new TextField();
			_textField.x = 10;
			_textField.y = 10;
			_textField.width = 445;
			_textField.height = 445;
			_textField.wordWrap = true;
			_textField.defaultTextFormat = new TextFormat('_sans', 16, 0x333333, true);
			addChild(_textField);
			
			_check('わんだwonderふる');
		}
		
		private function _check(text:String):void
		{
			var i:int, length:int;
			
			var bytes0:ByteArray = new ByteArray();
			bytes0.writeMultiByte(text, 'unicodeFFFE');
			bytes0.position = 0;
			
			var bytes1:ByteArray = new ByteArray();
			_writeUnicodeFFFE(bytes1, text);
			bytes1.position = 0;
			
			var code0:String = '';
			length = bytes0.length / 2;
			for (i = 0; i < length; i ++)
			{
				code0 += 'U+' + _toHexString(bytes0.readUnsignedShort()).toUpperCase() + ' ';
			}
			
			var code1:String = '';
			length = bytes1.length / 2;
			for (i = 0; i < length; i ++)
			{
				code1 += 'U+' + _toHexString(bytes1.readUnsignedShort()).toUpperCase() + ' ';
			}
			
			_textField.text = '"' + text + '" というテキストをデフォルトのメソッドとバグ対応済みのメソッドで utf-16 BE として ByteArray に書き込むテスト' + '\r' +
			                          '\r' +
			                          '- writeMultibyte を使った場合 (バグ有り)' + '\r' +
			                          '     bytes0.length = ' + bytes0.length.toString() + '\r' +
			                          '     code0 = ' + code0 + '\r' +
			                          '\r' +
			                          '- writeShort/writeUnsignedInt を使った場合 (バグ対応)' + '\r' +
			                          '     bytes1.length = ' + bytes1.length.toString() + '\r' +
			                          '     code1 = ' + code1 + '\r' +
			                          '\r' +
			                          'Capabilities.version = ' + Capabilities.version;
		}

		private function _writeUnicodeFFFE(bytes:ByteArray, text:String):void
		{
			var length:int = text.length;
			var charCode:int;
			for (var i:int = 0; i < length; i ++)
			{
				charCode = text.charCodeAt(i);
				if (charCode < 0x10000)
					bytes.writeShort(charCode);
				else
					bytes.writeUnsignedInt(charCode);
			}
		}
		
		private function _toHexString(value:int, length:int = 2):String
		{
			var hex:String = value.toString(16);
			while (hex.length < length * 2)
			{
				hex = '0' + hex;
			}
			trace(hex);
			return hex;
		}
	}
}
