/**
 * Copyright selflash ( http://wonderfl.net/user/selflash )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5aq5
 */

package
{
    import flash.display.*;
    import flash.events.*;
    import flash.utils.*;
    /*
     * @see http://yurikx.tumblr.com/post/661578199/as3
     */
    public class DrawFractalBox extends Sprite
    {
        private var w : Number;
        private var h : Number;
        private var g : Graphics = graphics;
        private var fractalData : Array = new Array();
        private var minSize : Number = 120;
        private var reDrawPar : Number = 0.4;
        private var now : uint = getTimer();
        private var then : uint = now;

        public function DrawFractalBox ()
        {
            //ステージの幅と高さを設定
            w = 800;
            h = 800;
            //クリックしたらスタート
            stage.addEventListener( MouseEvent.CLICK , startDraw );
            w
        }
        private function startDraw ( event : MouseEvent ) : void
        {
            g.clear();
            fractalData = [];
            //描画開始
            //addEventListener( Event.ENTER_FRAME , loop );
            //最初の行が領域を設定
            var _data : Data = new Data( 0 , 0 , w , h );
            fractalData.push( _data );
            
            loop();
        }
        private function loop ( e : Event = null) : void
        {
            //リストからデータの引き出し
            now = getTimer();
            for ( var i : uint = 0 ; i < now - then ; i++ )
            {
                var dat : Data = fractalData.pop();
                if ( dat != null )
                {
                    var _x : Number = dat.a;
                    var _y : Number = dat.b;
                    var _w : Number = dat.c;
                    var _h : Number = dat.d;
                    //ビット演算だとずれちゃうので普通に半分
                    var __w : Number = _w * 0.5;
                    var __h : Number = _h * 0.5;
                    //draw( _x, _y, _w, _h );
                    //幅もしくは高さがminSize以上あればふらくたるする
                    if ( _w > minSize || _h > minSize )
                    {
                        //ステージサイズの半分以上なら描画、もしくは4つにひとつくらいは描画を停止するようにしてます
                        //if ( _w > w >> 4 || Math.random() > reDrawPar )
                        //{
                            fractalData.push( new Data( _x , _y , __w , __h ));
                            fractalData.push( new Data( _x + __w , _y , __w , __h ));
                            fractalData.push( new Data( _x , _y + __h , __w , __h ));
                            fractalData.push( new Data( _x + __w , _y + __h , __w , __h ));
                        //}
                        //else
                        //{
                        //    draw( _x , _y , _w , _h );
                        //}
                    }
                    else
                    {
                        draw( _x , _y , _w , _h );
                    }
                }
                else
                {
                    //描画するデータがなくなったら終了
                    removeEventListener( Event.ENTER_FRAME , loop );
                    break;
                }
            }
            then = now;
        }
        //図形描画
        private function draw ( _x : Number , _y : Number , _w : Number , _h : Number ) : void
        {
            g.beginFill( 0xffffff );
            g.lineStyle( 1 , 0x000000 , 1 , false , "none" );
            g.drawRect( _x , _y , _w , _h );
            g.endFill();
        }
    }
}
class Data
{
    public var a : Number;
    public var b : Number;
    public var c : Number;
    public var d : Number;
    public function Data ( a : Number , b : Number , c : Number , d : Number )
    {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
    }
}