/**
 * Copyright mousepancyo ( http://wonderfl.net/user/mousepancyo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5agI
 */

package {
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.geom.Matrix;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.filters.ColorMatrixFilter

    [SWF(width="465", height="465", backgroundColor="0", frameRate="60")]
    
    public class Main extends Sprite {        
        private const W:int = 465 + 25
        private const H:int = 465 + 25
        private const WORMS:uint = 6;
        private var _bmd:BitmapData;
        private var _mapData:BitmapData;
        private var _bm:Bitmap;
        private var _vecList:Array;
        private var _ct:ColorTransform;
        private var _circleBmd:BitmapData
        private var _glowBmd:BitmapData
        private var _glowBm:Bitmap
        private var _blure:BlurFilter = new BlurFilter(10, 10, 2)
        private var _isRct:Boolean
        private var _isGct:Boolean
        private var _isBct:Boolean
        private var _container:Sprite = new Sprite()

        public function Main() {
            stage.scaleMode = "noScale";
            addChild(_container);
            setup();
        }
        
        private function setup():void {
            var sp:Shape = new Shape();
            sp.graphics.beginFill(0x99FFFF);
            sp.graphics.drawCircle(25, 25, 10);
            sp.graphics.endFill()
            //
            _circleBmd = new BitmapData(50, 50, true, 0)
            _circleBmd.draw(sp);
            //
            _mapData= new BitmapData( W, H, false, 0x000000);
            //addChild(new Bitmap(_mapData));
            //
            _bmd = new BitmapData( W, H, false, 0x000000);
            _bm= new Bitmap( _bmd );
            _bm.x = _bm.y = -25;
            _bm.filters = [_blure];
            _container.addChild(_bm);
            //
            _glowBmd = _bmd.clone();
            _glowBm = new Bitmap(_glowBmd);
            _glowBm.filters = [_blure];
            _glowBm.blendMode = "add";
            _glowBm.x = _glowBm.y = -25;
            _container.addChild(_glowBm);
            //
            _ct= new ColorTransform( .90, .93, .95);
            _vecList= [];
            //
            go()
        }
        
        private function go():void {
            _mapData.perlinNoise( 115, 115, 10, Math.random() * 0xFFFFFF | 0, false, true, 1 | 2);
            _vecList= new Array();
            //
            for (var i:uint = 0; i < WORMS; i++){
                var r:Number = 360 /WORMS * i;
                var px:Number = Math.cos(r * Math.PI / 180) * 60 + stage.stageWidth * .5;
                var py:Number = Math.sin(r * Math.PI / 180) * 60 + stage.stageHeight * .5;
                var av:Point = new Point(0, 0);
                var vv:Point = new Point(0, 0);
                var pv:Point = new Point(px, py);
                var vec:Vec = new Vec(av, vv, pv);
                _vecList.push(vec);
            }
            //
            addEventListener( Event.ENTER_FRAME, update);
        }
        
        private function update(e:Event):void {
            _bmd.colorTransform(_bmd.rect, _ct);
            var i:uint = 0;
            while (i < _vecList.length){
                var posX:Number;
                var posY:Number;
                var dots:Vec = _vecList[i];
                var col:Number = _mapData.getPixel(dots.pv.x, dots.pv.y);
                var r:uint = col >> 16 & 0xff;
                var g:uint = col >> 8 & 0xff;
                var b:uint = col & 0xff;
                //
                dots.av.x += ( r - 128 ) * .0002;
                dots.av.y += ( g - 128 ) * .0002;
                dots.vv.x += dots.av.x;
                dots.vv.y += dots.av.y;
                dots.pv.x += dots.vv.x;
                dots.pv.y += dots.vv.y;
                dots.av.x *= .97;
                dots.av.y *= .97;
                dots.vv.x *= .93;
                dots.vv.y *= .93;
                //
                posX = dots.pv.x;
                posY = dots.pv.y;
                //
                if (posX > W) {
                      dots.pv.x = 0;
                    dots.pv.y = Math.random() * H | 0;
                 } else {
                     if (posX < 0) {
                          dots.pv.x = W;
                        dots.pv.y = Math.random() * H | 0;
                    }else {
                          0;
                     }
                 }
                 if (posY > H) {
                      dots.pv.y = 0;
                    dots.pv.x = Math.random() * W | 0;
                 } else {
                     if (posY < 0) {
                          dots.pv.y = H;
                        dots.pv.x = Math.random() * W | 0;
                    }else {
                          0;
                     }
                 }
                 //
                _bmd.copyPixels(_circleBmd, _circleBmd.rect, new Point(dots.pv.x, dots.pv.y));
                i++;
            }
            //
            _glowBmd.copyPixels(_bmd, _bmd.rect, new Point());
            colorChange();
        }
        
        private function colorChange():void{
            if(_isRct){
                _ct.redMultiplier += 0.001;
                if(_ct.redMultiplier > 0.99){
                   _mapData.perlinNoise( 115, 115, 10, Math.random() * 0xFFFFFF | 0, false, true, 1 | 2);
                   _isRct = false;
                   }
            }else{
                _ct.redMultiplier -= 0.001;
                if(_ct.redMultiplier < 0.8) _isRct = true;
            }
            if(_isGct){
                _ct.greenMultiplier += 0.002;
                if(_ct.greenMultiplier > 0.99) _isGct = false;
            }else{
                _ct.greenMultiplier -= 0.002;
                if(_ct.greenMultiplier < 0.8) _isGct = true;
            }
            if(_isBct){
                _ct.blueMultiplier += 0.003;
                if(_ct.blueMultiplier > 0.99) _isBct = false;
            }else{
                _ct.blueMultiplier -= 0.003;
                if(_ct.blueMultiplier < 0.8) _isBct = true;
            }
        }
    }
}


//
import flash.geom.Point;
class Vec {
    public var av:Point; //加速度
    public var vv:Point; //移動量
    public var pv:Point; //現在位置
    
    function Vec( $av:Point, $vv:Point, $pv:Point ){
        av = $av;
        vv = $vv;
        pv = $pv;
    }
}