/**
 * Copyright bigfish ( http://wonderfl.net/user/bigfish )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5aO6
 */

package {

    import flash.display.Sprite;

    public class FlashTest extends Sprite {

		namespace ami = "urn:bluecoat.com:ami";
		use namespace ami;

        public function FlashTest() {

			var downloadXML:XML = <ami:Comet-Response xmlns:ami="urn:bluecoat.com:ami">
  <channel>/comet/connect</channel>
  <value>
    <events>
      <item>
        <channel>3</channel>
        <data>
          <ami:Loadable-File-Event>
            <state>
              <downloading>
                <loaded>26887315</loaded>
                <total>127770624</total>
              </downloading>
            </state>
          </ami:Loadable-File-Event>
        </data>
      </item>
    </events>
  </value>
</ami:Comet-Response>;

			var duplicateXML:XML = <ami:Comet-Response xmlns:ami="urn:bluecoat.com:ami">
  <channel>/comet/connect</channel>
  <value>
    <events>
      <item>
        <channel>2</channel>
        <data>
          <ami:Loadable-File-Event>
            <state>
              <error>
                <ami:Duplicate-System>
                  <context/>
                </ami:Duplicate-System>
              </error>
            </state>
          </ami:Loadable-File-Event>
        </data>
      </item>
    </events>
  </value>
</ami:Comet-Response>;
	
			var successXML:XML = 
			<ami:Comet-Response xmlns:ami="urn:bluecoat.com:ami">
			  <channel>/comet/connect</channel>
			  <value>
				<events>
				  <item>
					<channel>3</channel>
					<data>
					  <ami:Loadable-File-Event>
						<state>success</state>
					  </ami:Loadable-File-Event>
					</data>
				  </item>
				</events>
			  </value>
			</ami:Comet-Response>;
			
			var installingXML:XML = <ami:Comet-Response xmlns:ami="urn:bluecoat.com:ami">
					  <channel>/comet/connect</channel>
					  <value>
						<events>
						  <item>
							<channel>3</channel>
							<data>
							  <ami:Loadable-File-Event>
								<state>
								  <installing>
									<loaded>123731968</loaded>
									<total>127770624</total>
								  </installing>
								</state>
							  </ami:Loadable-File-Event>
							</data>
						  </item>
						</events>
					  </value>
					</ami:Comet-Response>;
		
			parseEvent(downloadXML);
			parseEvent(duplicateXML);
			parseEvent(successXML);
			parseEvent(installingXML);

			function parseEvent(xml:XML):void {
				for each (var eventNode:XML in xml..data.children()) {
					var nodeName:String = eventNode.localName();
					if (nodeName == "Loadable-File-Event") {

						//check for success
						if (eventNode.state.text() == "success") {
							trace("success");
							return;
						}
						var stateNode:XML = eventNode.state.children()[0]
						var stateStr:String = stateNode.localName();

						switch(stateStr) {
							
							case "downloading":
								trace("downloading");
								parseDownloadProgress(stateNode);
								break;

							case "error":
								trace("error");
								break;

							 case "installing":
									trace("installing");
									parseInstallProgress(stateNode);
									break;

							 default:
								trace ("unknown file load state");
						}

					}
				}
			}

			function parseDownloadProgress(downloadingNode:XML):void {
				trace ( getProgress(downloadingNode));
			}

			function getProgress(progressNode:XML):Number {
				var blocksLoaded:int = parseInt(progressNode.loaded);
				var blocksTotal:int = parseInt(progressNode.total);
				return Math.round(100*blocksLoaded/blocksTotal);

			}
			

			function parseInstallProgress(installingNode:XML):void {
				trace ( getProgress(installingNode));
			}
			
        }
    }
}
