/**
 * Copyright _wonder ( http://wonderfl.net/user/_wonder )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5ZvB
 */

// forked from _wonder's セグメントを描画：IK drag (1)
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;
    
    public class InverseKinematics extends Sprite {
            private var seg0:Segment;
            private var seg1:Segment;
            
        public function InverseKinematics() {
            init();
        }
        
        private function init():void {
                seg0 = new Segment(100, 20);
                addChild( seg0 );
                
                seg1 = new Segment(100, 20);
                addChild( seg1 );
                seg1.x = stage.stageWidth / 2;
                seg1.y = stage.stageHeight / 2;
                
                addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void {
            var dx:Number = mouseX - seg1.x;
            var dy:Number = mouseY - seg1.y;
            var dist:Number = Math.sqrt( dx*dx + dy*dy );
            
            var a:Number = 100;
            var b:Number = 100;
            var c:Number = Math.min( dist, a+b );
            var B:Number = Math.acos( (b*b-a*a-c*c)/(-2*a*c) );
            var C:Number = Math.acos( (c*c-a*a-b*b)/(-2*a*b) );
            var D:Number = Math.atan2( dy, dx );
            var E:Number = D + B + Math.PI + C;
            
            seg1.rotation = (D+B) * 180 / Math.PI;
            seg0.x = seg1.getPin().x;
            seg0.y = seg1.getPin().y;
            seg0.rotation = E * 180 / Math.PI;
        }

    }
}
import flash.display.Sprite;
import flash.geom.Point;

class Segment extends Sprite {
    private var color:uint;
    private var segmentWidth:Number;
    private var segmentHeight:Number;
    
    public var vx:Number = 0;
    public var vy:Number = 0;
    
    public function Segment(segmentWidth:Number,segmentHeight:Number,color:uint=0xffffff){
        this.segmentWidth = segmentWidth;
        this.segmentHeight = segmentHeight;
        this.color = color;
        init();
    }
    
    public function init():void {
        //セグメントの描画
        graphics.lineStyle( 0 );
        graphics.beginFill( color );
        graphics.drawRoundRect( -segmentHeight / 2, -segmentHeight / 2, segmentWidth+segmentHeight, segmentHeight, segmentHeight, segmentHeight );
        graphics.endFill();
        
        //ピン
        graphics.drawCircle( 0, 0, 2 );
        
        graphics.lineStyle( 0, 0xcc0000 );
        graphics.beginFill( 0xcc0000 );
        graphics.drawCircle( segmentWidth, 0, 2 );
    }
    
    public function getPin():Point {
        var angle:Number = rotation * Math.PI / 180;
        var xPos:Number = x + Math.cos( angle ) * segmentWidth;
        var yPos:Number = y + Math.sin( angle ) * segmentWidth;
        return new Point( xPos, yPos );
    }
}