/**
 * Copyright okoi ( http://wonderfl.net/user/okoi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5Zbx
 */

//
//	うねうねラインのアイディアを流用
//	PathクラスのPOWER1とPOWER2の調整で色々変わる。
//
//	@author	okoi
//
package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	
	public class Main extends Sprite 
	{
		private static const PATHNUM:int = 360;
		private var list:Array = new Array();
		
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
			
			for ( var i:int = 0; i < PATHNUM; i++ )
			{
				var obj:Path = new Path();
				obj._x = stage.stageWidth / 2;
				obj._y = stage.stageHeight / 2;
				list.push( obj );
			}
			addEventListener( Event.ENTER_FRAME, Update );
		}
		
		private function Update( e:Event ) : void 
		{
			var i:int;
			for ( i = 0; i < list.length; i++ )
			{
				if ( i > 0 )	list[i].Update( list[i - 1]._x, list[i - 1]._y );
				else			list[i].Update( stage.mouseX, stage.mouseY );
			}			
			
			graphics.clear();
			graphics.lineStyle( 5, 0 );
			for ( i = 0; i < list.length; i++ )
			{
				var obj:Path = list[i];				
				if ( i == 0 ) graphics.moveTo( obj._x, obj._y );
				else 		  graphics.lineTo( obj._x, obj._y );
			}			
		}	
	}	
}
class Path {
	
	public	var _x:Number;
	public	var _y:Number;
	
	private	var _mx:Number;
	private var _my:Number;
	
	private static const POWER1:Number = 0.6;
	private static const POWER2:Number = 0.4;
	
	public	function Path():void 
	{
		_x = 0;
		_y = 0;
		_mx = 0;
		_my = 0;
	}
	
	/**
	 * 
	 * @param	tx	目標地点
	 * @param	ty	目標地点
	 */
	public	function Update(tx:Number, ty:Number):void 
	{
		if ( Math.abs( tx - _x ) < 1 && Math.abs( ty - _y ) < 1 ) return;
		
		_mx += (tx - _x) * POWER1;
		_mx *= POWER2;
		
		_my += (ty - _y) * POWER1;
		_my *= POWER2;
		
		_x += _mx;
		_y += _my;
	}
	
}
