/**
 * Copyright zahir ( http://wonderfl.net/user/zahir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5ZQB
 */

/* 
 * （多分）ラスト
 * BitmapData.draw()でscale9Gridを表現
 * Bitmapはひとつなのでエコロジー？
 * drawの処理時間が不安すぎる
 *
 * 自作コンポーネントでスキン的なことをしようとしたら
 * 画像にscale9Gridによるスライスがかからなかったので
 * 自分で作成。
 *
 * 9つのBitmap
 * beginBitmapFill
 * BitmapData.drawを駆使
 * の三パターンを作ったけど
 * どれが一番いいことやら…
 *
 */
package{
	import flash.display.Bitmap;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;

	public class Scale9Grid_test4 extends Sprite{
		private const URL:String = "http://assets.wonderfl.net/images/related_images/6/65/65fb/65fb02d96036069076e3e206b6b6e1f50679de67";
		private var scale:Number = 0.99;
		
		private var l:Loader;
		private var img:BitmapScale9Grider;
		
		public function Scale9Grid_test4(){
			l = new Loader();
			l.contentLoaderInfo.addEventListener(Event.COMPLETE, onComp);
			l.load( new URLRequest( URL ), new LoaderContext( true ) );
		}
		private function onComp(e:Event):void{
			l.contentLoaderInfo.removeEventListener(Event.COMPLETE, onComp);
			
			var bmp:Bitmap = l.content as Bitmap;
			img = new BitmapScale9Grider(bmp.bitmapData, 36, 36, 36, 36, "auto", true);
			addChild(img);
			
			//img.width = 300;
			
			addEventListener(Event.ENTER_FRAME, onEnter);
		}
		private function onEnter(e:Event):void{
			//*
			if(img.scaleX >= 1.5) scale = 0.99;
			if(img.scaleX <= 0.5) scale = 1.01;
			img.scaleX *= scale;
			//*/
			
			/*
			if(img.scaleY >= 1.5) scale = 0.99;
			if(img.scaleY <= 0.5) scale = 1.01;
			img.scaleY *= scale;
			//*/
		}
	}
}
	import flash.display.Sprite;
	import flash.display.BitmapData;
	import flash.geom.Rectangle;
	import flash.display.Graphics;
	import flash.geom.Matrix;
	import org.papervision3d.core.render.sort.NullSorter;
	import flash.display.Bitmap;
	import flash.geom.Point;
	


class BitmapScale9GridBaseClass extends Sprite{
	private var _orig:BitmapData;
	
	private var _sX:Number = 1;
	private var _sY:Number  = 1;
	
	private var _l:int, _t:int, _r:int, _b:int;
	private var _iw:int, _ih:int;
	
	public function BitmapScale9GridBaseClass(	source:BitmapData,
																				left:int, top:int, right:int, bottom:int){
		//
		setBitmapData( source, left, top, right, bottom);
	}
	
	public function setBitmapData(	source:BitmapData,
															left:int, top:int, right:int, bottom:int):void{
		this.source = source;
		this.left = left;
		this.right = right;
		this.top = top;
		this.bottom = bottom;
		this.insideWidth = source.width - ( left + right );
		this.insideHeight = source.height - ( top + bottom);
		
		draw(source.width, source.height);
	}
	
	protected function draw( width:int, height:int):void{
	}
	
	protected function get source():BitmapData{
		return _orig;
	}
	protected function set source( data:BitmapData ):void{
		_orig = data;
	}
	
	protected function get left():int{
		return _l;
	}
	protected function set left( value:int ):void{
		_l = value < 0 ? 0 : value;
	}
	
	protected function get top():int{
		return _t;
	}
	protected function set top( value:int ):void{
		_t = value < 0 ? 0 : value;
	}
	
	protected function get right():int{
		return _r;
	}
	protected function set right( value:int ):void{
		_r = value < 0 ? 0 : value;
	}
	
	protected function get bottom():int{
		return _b;
	}
	protected function set bottom( value:int ):void{
		_b = value < 0 ? 0 : value;
	}
	
	protected function get insideWidth():int{
		return _iw;
	}
	protected function set insideWidth( value:int ):void{
		_iw = value < 0 ? 0 : value;
	}
	
	protected function get insideHeight():int{
		return _ih;
	}
	protected function set insideHeight( value:int ):void{
		_ih = value < 0 ? 0 : value;
	}
	
	public override function get scale9Grid():Rectangle{
		return new Rectangle( left, top, insideWidth, insideHeight);
	}
	public override function set scale9Grid(innerRectangle:Rectangle):void{
		//とりあえずつぶしておく
	}
	public override function get scaleX():Number{
		return _sX;
	}
	public override function set scaleX(value:Number):void{
		_sX = value;
		draw( Math.round( source.width * value ), source.height);
	}
	
	public override function get scaleY():Number{
		return _sY;
	}
	public override function set scaleY(value:Number):void{
		_sY = value;
		draw( source.width, Math.round( source.height*value ) );
	}
	
	public override function set height(value:Number):void{
		draw( source.width, Math.round( value ));
	}
	public override function set width(value:Number):void{
		draw( Math.round( value ), source.height);
	}
}
class BitmapScale9Grider extends BitmapScale9GridBaseClass{
	private var bmp:Bitmap;
	private var _smooth:Boolean = false;
	public function BitmapScale9Grider(	source:BitmapData,
																left:int = 0, top:int = 0, right:int = 0, bottom:int = 0,
																pixelSnapping:String = "auto", smooth:Boolean = false){
																	
		_smooth = smooth;
		bmp = new Bitmap( source.clone(), pixelSnapping, smooth);
		addChild( bmp );
		
		
		super(source, left, top, right, bottom);
		
	}
	protected override function draw( width:int, height:int):void{
		bmp.bitmapData.dispose();
		var _right:int = width - right;
		var _bottom:int = height - bottom;
		var bd:BitmapData = new BitmapData( width, height, true, 0x0 );
		var p:Point = new Point();
		
		var w:int = width -(left + right);
		var iw:Number = w / insideWidth;
		var offsetX1:Number =  left - left * iw;
		var offsetX2:int = width - source.width;
		
		var h:int = height - ( top + bottom);
		var ih:Number = h / insideHeight;
		var offsetY1:Number = top - top * ih;
		var offsetY2:int = height - source.height;
		
		// TOP
		bd.draw( source, createBox(1,1, 0,0), null, null, new Rectangle(0,0, left, top), _smooth); // LT
		bd.draw( source, createBox(iw,1, offsetX1,0), null, null, new Rectangle(left,0, w, top), _smooth); // T
		bd.draw( source, createBox(1,1, offsetX2,0), null, null, new Rectangle(_right,0, right, top), _smooth); // RT
		
		// Middle
		bd.draw( source, createBox(1,ih, 0,offsetY1), null, null, new Rectangle(0,top, left, h), _smooth); // L
		bd.draw( source, createBox(iw,ih, offsetX1,offsetY1), null, null, new Rectangle(left,top, w, h), _smooth); // innerRect
		bd.draw( source, createBox(1,ih, offsetX2,offsetY1), null, null, new Rectangle(_right,top, right, h), _smooth); // R
		
		//Bottom
		bd.draw( source, createBox(1,1, 0,offsetY2), null, null, new Rectangle(0, _bottom, left, bottom), _smooth); // LB
		bd.draw( source, createBox(iw,1, offsetX1,offsetY2), null, null, new Rectangle(left, _bottom, w, bottom), _smooth); // B
		bd.draw( source, createBox(1,1, offsetX2,offsetY2), null, null, new Rectangle(_right,_bottom, right, bottom), _smooth); // RB
		
		bmp.bitmapData = bd;
	}
	protected function createBox( sx:Number, sy:Number, offsetX:Number, offsetY:Number):Matrix{
		var m:Matrix = new Matrix();
		m.scale( sx, sy );
		m.translate( offsetX, offsetY);
		return m;
		
	}
}