/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5ZPb
 */

package {
    import flash.display.BlendMode;
    import flash.display.BitmapData;
    import flash.events.KeyboardEvent;
    import flash.events.Event;
    //import flash.media.Camera;
    
    //http://alternativaplatform.com/en/docs/7.7.0/index.html
    
    import alternativ7.engine3d.containers.ConflictContainer;
    import alternativ7.engine3d.containers.BSPContainer;
    import alternativ7.engine3d.core.Object3DContainer;
    import alternativ7.engine3d.core.Camera3D;
    import alternativ7.engine3d.core.EllipsoidCollider;
    import alternativ7.engine3d.objects.Mesh;
    import alternativ7.engine3d.primitives.Plane;
    import alternativ7.engine3d.primitives.Box;
    import alternativ7.engine3d.primitives.Sphere;
    import alternativ7.engine3d.primitives.GeoSphere;
    import alternativ7.engine3d.core.View;
     import alternativ7.engine3d.materials.Material;
    import alternativ7.engine3d.materials.FillMaterial;
    import alternativ7.engine3d.materials.TextureMaterial;
    import alternativ7.engine3d.materials.NormalMapMaterial;
    import alternativ7.engine3d.materials.FlatShadingMaterial;
    import alternativ7.engine3d.materials.VertexLightMaterial;
    import alternativ7.engine3d.materials.AverageLightMaterial;
    import alternativ7.engine3d.materials.SphericalEnvironmentMaterial;
    import alternativ7.types.Texture;
    import alternativ7.engine3d.lights.AmbientLight;
    import alternativ7.engine3d.lights.DirectionalLight;
    import alternativ7.engine3d.lights.OmniLight;
    import alternativ7.engine3d.lights.SpotLight;
    import flash.display.Sprite;
    
    public class FlashTest extends Sprite {
        
        public var cam:Camera3D;
        public var cont:Object3DContainer = new ConflictContainer();
       // public var gBox:Box;
       
       
       public var mw:int = 512;
       public var mh:int = 512;
       public var vecMap:Vector.<int>;
        
       public var vecTile:Vector.<Mesh>;
       public var numTile:int = 512; //need at least 20*20 (400)
        
        public function FlashTest() {
            // write as3 code here..
               cam = new Camera3D();
                cam.view = new View(500,500); 
                cam.z = -128 + 32;
                cam.x = 128;
                cam.y = 128;
                
               addChild(cam.view);
                cont.addChild(cam);
                
                var bm:BitmapData;
                bm = new BitmapData(64,64,false,0);
                bm.noise(123213,0,16,3,true);
                
                var box:Box = new Box(128,128,128,1,1,1);
                box.z = 256;
                            box.setMaterialToAllFaces( new TextureMaterial( bm ) );
                cont.addChild(box);
                
                var p:Mesh;
                /*
                p = new Plane(1000, 1000, 8, 8);
    
                p.rotationX = 1.57;
                p.y = 200;
                cont.addChild(p);
                */
                
                graphics.clear();
                graphics.lineStyle(2,0);
                graphics.drawCircle(Math.random()*200, Math.random()*200,50);
                
                
                
                var i:int;
                var k:int;
                var yt:int;
                var num:int;
                num = mw * mh;
                vecMap = new Vector.<int>(num, true);
                for (i = 0; i < num; i++)
                {
                    vecMap[i] = Math.random() > 0.5 ? 1 : 0 ;
                 }//nexti
                 
                 vecTile = new Vector.<Mesh>(numTile,true);
                
                var mat:Material;
                mat = new  FillMaterial(0xFFffFFff*Math.random(), 1, 1, 0);
                
                for (i = 0; i < numTile; i++)
                {
                    //p = new Plane(8,8,1,1);
                    p = new Box(8,8,8,1,1,1);
                    p.setMaterialToAllFaces(mat);
                    p.visible = false;
                    cont.addChild(p);
                    vecTile[i] = p;
                }//nexti
                
                bm = new BitmapData(64,64,false,0);
                bm.noise(123123);
               
               /*
               for (i = 0; i < mh; i++)
               {
                   yt = i * mw;
                for (k = 0; k < mw; k++)
                {
                    p = new Plane(8,8,1,1);
                    p.x = k * 8;
                    p.y = i * 8;
                    p.setMaterialToAllFaces(new FillMaterial(vecMap[yt+k],1,1,0) );
                    cont.addChild(p);
                    
                }//nextk 
               }//nexti
               */
               
                  stage.addEventListener(Event.ENTER_FRAME, onEnter);  
                  stage.addEventListener(KeyboardEvent.KEY_DOWN, kdown);
                  stage.addEventListener(KeyboardEvent.KEY_UP, kup);    
               
               
        }//ctor
        
        public function drawMap(sx:Number, sy:Number):void
        {
            var tx:int, ty:int;
            var stx:int, sty:int;
            var i:int;
            var k:int;
            var p:Mesh;
            var t:int;
            var yt:int;
            var it:int;
            
            it = 0;
            stx = Math.floor(sx / 8);
            sty = Math.floor(sy / 8);
            
            for (i = 0; i < numTile; i++)
            {
                p = vecTile[i];
                p.visible = false;
            }//nexti
            
            ty = sty;
            for (i = 0; i < 20; i++, ty++)
            {
                if (ty < 0) { continue;}
                if (ty >= mh) { return; }
                
                yt = ty * mw;
                tx = stx;
                
                for (k = 0; k < 20; k++, tx++)
                {
                    if (tx < 0)  {continue;}
                    if (tx >= mw) { break; }
                    
                    t = vecMap[yt + tx];
                    if (t <= 0) { continue; }
                
                     p = vecTile[it];
                     p.x = tx * 8;
                     p.y = ty * 8;
                     p.visible = true;
                        
                        it++;if (it >= numTile) { return; }
                }//nextk
            }//nexti
            
        }//drawmap
        
        public function onEnter(e:Event):void
        {
            //ref
         //http://www.dakmm.com/?p=272
            if (cKeyMan.isKeyDown(39) ) { cam.x += 4;}
            if (cKeyMan.isKeyDown(37) ) { cam.x -= 4;}
            if (cKeyMan.isKeyDown(38) ) { cam.y -= 4;}
            if (cKeyMan.isKeyDown(40) ) { cam.y += 4;}
            
            //no frustum testing, guessing, trial and error all the way
           drawMap(cam.x-64-16, cam.y-64-16);
           // drawMap(128,128);
          //  trace(cam.x);
             cam.render();
            
            //if you want to rotate you need to bring the camera closer
            //so you don't see the edges 
           //  cam.rotationZ += 0.1;
             
        }//onenter
        
        public function kdown(e:KeyboardEvent):void
        {
         cKeyMan.setKey(e.keyCode, true);   
        }//kdown
        
        public function kup(e:KeyboardEvent):void
        {
          cKeyMan.setKey(e.keyCode, false);  
        }//kup
        
        
    }//flashtest
}//package


internal class cKeyMan
   {
       public function cKeyMan() {}//ctor (unused)
       
       public static var vecKey:Vector.<Boolean> = new Vector.<Boolean>(512,true);
       
       public static function setKey(k:int, b:Boolean):void
       {
           if (k < 0) return;
           if (k >= 512) return;
           vecKey[k] = b;
       }//setkey
       
       public static function isKeyDown(k:int):Boolean
       {
           if  (k < 0) return false;
           if (k >= 512) return false;
           return vecKey[k];
       }//iskey
       
   }//keyman 
    