/**
 * Copyright Nao_u ( http://wonderfl.net/user/Nao_u )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5YSa
 */

// ３点が作る円の中心と半径を求める
//    マウスドラッグで制御点を移動
//
//    それぞれの制御点をつなぐ線分の中点を通り、線分に垂直に
//    交わる直線の交点が３点が作る円の中心になる
//

package {    
    import flash.display.Sprite;    
    import flash.events.*;    
    [SWF(width="465", height="465", backgroundColor="0xFFFFFF", frameRate="60")]     
       
    public class FlashTest extends Sprite {    
        public function FlashTest() {    
            Main = this;    
            initialize();    
            stage.addEventListener(Event.ENTER_FRAME,update);     
            stage.addEventListener(KeyboardEvent.KEY_UP,   keyCheckUp);     
            stage.addEventListener(KeyboardEvent.KEY_DOWN, keyCheckDown);     
            stage.addEventListener(MouseEvent.MOUSE_UP,    MouseCheckUp);     
            stage.addEventListener(MouseEvent.MOUSE_DOWN,  MouseCheckDown);     
        }    
    }    
}            
   
import flash.display.Sprite;     
import flash.events.Event;    
import flash.events.KeyboardEvent;     
import flash.events.MouseEvent;     
import flash.ui.Keyboard;     
import flash.text.TextField;    
import flash.geom.*; 
var Main:Sprite;    
var SCREEN_W:Number = 465;   
var SCREEN_H:Number = 465;   
var Text:TextField   

var T:Number = 0.5;
var Mode:int = 0;
var Pnt:Vector.<ControlPoint> = new Vector.<ControlPoint>;

function initialize():void{    
    Text = new TextField();    
    Text.text = "----";  
    Text.autoSize = "left";  
    Main.addChild(Text);     
      
    graphicClear();  

    Pnt[0] = new ControlPoint( new Point(SCREEN_W/2-150, SCREEN_H/2) );
    Pnt[1] = new ControlPoint( new Point(SCREEN_W/2-100,   SCREEN_H/2-100) );
    Pnt[2] = new ControlPoint( new Point(SCREEN_W/2+0,   SCREEN_H/2-100) );

}    

// ２点間の距離を求める
function getDist( ax:Number, ay:Number, bx:Number, by:Number ):Number {
    var dx:Number = ax-bx;
    var dy:Number = ay-by;
  return Math.sqrt(dx*dx + dy*dy);
}

// 内積 (dot product) : a⋅b = |a||b|cosθ
function dot( ax:Number, ay:Number, bx:Number, by:Number ):Number {
  return (ax * bx + ay * by);
}

// 外積 (cross product) : a×b = |a||b|sinθ
function cross( ax:Number, ay:Number, bx:Number, by:Number ):Number {
  return (ax * by - ay * bx);
}

// 直線と点の距離を求める
function getLineCrossPoint( ax:Number, ay:Number, bx:Number, by:Number, px:Number, py:Number ):Number {
    var c:Number = cross(bx-ax, by-ay, px-ax, py-ay);
    var d:Number = getDist( ax, ay, bx, by );
    return Math.abs(c) / d;
}

// a1,a2を端点とする線分とb1,b2を端点とする線分の交点計算
function intersection_ls( a1x:Number, a1y:Number, a2x:Number, a2y:Number, b1x:Number, b1y:Number, b2x:Number, b2y:Number ):Number {

  var ax:Number = a2x - a1x;
  var ay:Number = a2y - a1y;
  var bx:Number = b2x - b1x;
  var by:Number = b2y - b1y;
  // 平行なら交わらない
  if( cross(a1x-a2x, a1y-a2y, b1x-b2x, b1y-b2y) == 0.0 ) return 0.0;
  var t:Number = cross(bx,by, b1x-a1x, b1y-a1y) / cross(bx,by, ax,ay);

  return t;
}

function update(e :Event):void{    
    graphicClear();  

    drawLine( Pnt[0].Sp.x, Pnt[0].Sp.y, Pnt[1].Sp.x, Pnt[1].Sp.y, 1.0, 0x0000ff ); 
    drawLine( Pnt[1].Sp.x, Pnt[1].Sp.y, Pnt[2].Sp.x, Pnt[2].Sp.y, 1.0, 0x0000ff ); 

    // ３点を(x0,y0)(x1,y1)(x2,y2)、(x0,y0)(x1,y1)を直線１、(x1,y1)(x2,y2)を直線２
    // 各中点を(p1x,p1y)(p2x,p2y)として
    var x0:Number = Pnt[0].Sp.x;
    var y0:Number = Pnt[0].Sp.y;
    var x1:Number = Pnt[1].Sp.x;
    var y1:Number = Pnt[1].Sp.y;
    var x2:Number = Pnt[2].Sp.x;
    var y2:Number = Pnt[2].Sp.y;

    var p1x:Number = (x0+x1)*0.5;
    var p1y:Number = (y0+y1)*0.5;
    var p2x:Number = (x1+x2)*0.5;
    var p2y:Number = (y1+y2)*0.5;
    
    // 中点の表示
    drawCircle( p1x, p1y, 2.5, 0x00 );
    drawCircle( p2x, p2y, 2.5, 0x00 );

    // 制御点間のベクトルに直行する直線の向きを求める
    var v1x:Number = y1-y0;
    var v1y:Number = -(x1-x0);
    var v2x:Number = y2-y1;
    var v2y:Number = -(x2-x1);

    // 中点を通って制御点間ベクトルに直行する直線同士の交点を求める
    var t:Number = intersection_ls( p1x, p1y, p1x+v1x, p1y+v1y, p2x, p2y, p2x+v2x, p2y+v2y );
    var cx:Number = p1x + (v1x) * t;
    var cy:Number = p1y + (v1y) * t;
    var rx:Number = cx - x2;
    var ry:Number = cy - y2;
    var r:Number  = Math.sqrt( rx*rx + ry*ry );

    // 交点・円の表示
    drawCircle( cx, cy, 3.5, 0x00 );
    drawLine( p1x, p1y, cx, cy, 1.0, 0xff0000 ); 
    drawLine( p2x, p2y, cx, cy, 1.0, 0x00ff00 ); 
    drawCircleLine( cx, cy, r, 0x00 );
 
    Text.text = "３点が作る円の中心を求める 　半径:"+r.toString();  

   updateKey();
} 



class ControlPoint{ 
    public var Sp:Sprite; 
    public var isEnable:Boolean = false;
    public var Pos:Point;
    public function ControlPoint( p:Point ){ 
        Sp=new Sprite();   
        Pos = p; 
        Sp.x = Pos.x; 
        Sp.y = Pos.y;
        setEnable( true );
        Main.stage.addChild(Sp);  

        Sp.addEventListener(MouseEvent.MOUSE_UP,   function (event:MouseEvent):void{ Sp.stopDrag(); }); 
        Sp.addEventListener(MouseEvent.MOUSE_DOWN, function (event:MouseEvent):void{ if( isEnable ) Sp.startDrag(); });     
    } 

    public function setEnable( flg:Boolean ):void{    
        if( flg == true && isEnable == false ){
            Sp.graphics.clear();
            Sp.graphics.lineStyle(1.4,0x000000);       
            Sp.graphics.beginFill(0xe0d000,1);   
            Sp.graphics.drawCircle(0,0,8.0);   
            Sp.graphics.endFill();   
        }else if( flg == false && isEnable == true ){
            Sp.graphics.clear();
        }
        isEnable = flg;
    }
} 


function graphicClear():void{  
    Main.graphics.clear();   
    Main.graphics.lineStyle(1.2,0xb0b040);       
    Main.graphics.moveTo( SCREEN_W/2,          0 );       
    Main.graphics.lineTo( SCREEN_W/2,   SCREEN_H );          
    Main.graphics.moveTo(          0, SCREEN_H/2 );       
    Main.graphics.lineTo(   SCREEN_W, SCREEN_H/2 );          
}  

function drawLine( sx:Number, sy:Number, ex:Number, ey:Number, size:Number, col:int ):void{    
    Main.graphics.lineStyle(size,col);       
    Main.graphics.moveTo( sx, sy );       
    Main.graphics.lineTo( ex, ey );          
}   

function drawCircle( x:Number, y:Number, size:Number, col:int ):void{    
    Main.graphics.lineStyle(1.0,0x000000);       
    Main.graphics.beginFill( col, 1 );    
    Main.graphics.drawCircle( x, y, size );    
    Main.graphics.endFill();    
}   

function drawCircleLine( x:Number, y:Number, size:Number, col:int ):void{    
    Main.graphics.lineStyle(1.0,0x000000);       
//    Main.graphics.beginFill( col, 1 );    
    Main.graphics.drawCircle( x, y, size );    
//    Main.graphics.endFill();    
} 
var KEY_UP:int    = 0x01;    
var KEY_DOWN:int  = 0x02;    
var KEY_LEFT:int  = 0x04;    
var KEY_RIGHT:int = 0x08;    
var KEY_UP_TRG:int    = 0x10;    
var KEY_DOWN_TRG:int  = 0x20;    
var KEY_LEFT_TRG:int  = 0x40;    
var KEY_RIGHT_TRG:int = 0x80;    
var KeyData:int;    
function keyCheckDown(event:KeyboardEvent):void {     
    switch (event.keyCode){     
        case Keyboard.UP:      KeyData |= KEY_UP|KEY_UP_TRG; break;    
        case Keyboard.DOWN:    KeyData |= KEY_DOWN|KEY_DOWN_TRG; break;    
        case Keyboard.LEFT:    KeyData |= KEY_LEFT|KEY_LEFT_TRG; break;    
        case Keyboard.RIGHT:   KeyData |= KEY_RIGHT|KEY_RIGHT_TRG; break;    
    }    
}

function keyCheckUp(event:KeyboardEvent):void {     
    switch (event.keyCode){     
        case Keyboard.UP:      KeyData &= ~KEY_UP; break;    
        case Keyboard.DOWN:    KeyData &= ~KEY_DOWN; break;    
        case Keyboard.LEFT:    KeyData &= ~KEY_LEFT; break;    
        case Keyboard.RIGHT:   KeyData &= ~KEY_RIGHT; break;    
    }    
}     

function updateKey():void{    
    KeyData &= ~(KEY_UP_TRG|KEY_DOWN_TRG|KEY_LEFT_TRG|KEY_RIGHT_TRG);
}             

var MOUSE_LEFT:int = 0x01;    
var MOUSE_LEFT_TRG:int = 0x02;    
var MouseData:int;    
function MouseCheckDown(event:MouseEvent):void{    
    MouseData |= MOUSE_LEFT;    
    MouseData |= MOUSE_LEFT_TRG;    
}             

function MouseCheckUp(event:MouseEvent):void{    
    MouseData &= ~MOUSE_LEFT;    
}             

function MouseUpdate():void{    
    MouseData &= ~MOUSE_LEFT_TRG;    
}  
