/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5YKI
 */

package {
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            // write as3 code here..
            
            myTri = new xTri();
            myTri.a.setValue(20,20, 0);
            myTri.b.setValue(400,100, 0);
            myTri.c.setValue(30,400, 0);
            
            
            stage.addEventListener(Event.ENTER_FRAME, onEnter);
        }//ctor
        
        public var myTri:xTri;
        public var cut:xCutter = new xCutter();
        
        public var ang:Number = 0;
        
        public function onEnter(e:Event):void
        {
            graphics.clear();
            graphics.lineStyle(2, 0);
           
           drawTri(myTri);
           
           ang += 0.034;
           
           cut.cx = 232-50;
           cut.cy = 232-50;
           
           cut.cnx = Math.cos(ang);
           cut.cny = Math.sin(ang);
           
           var n:int;
           
           n = cut.cutTri(myTri);
           
           if (n > 0)
           {
             graphics.beginFill(0xFF, 0.2);
             drawTri(cut.ret1);
             graphics.endFill();
             
             if (n > 1) {
                 graphics.beginFill(0xFF0000,0.2);
                  drawTri(cut.ret2);
                 graphics.endFill();
                  }   
           }
           
            
        }//onenter
        
        public function drawTri(m:xTri):void
        {
            graphics.moveTo(m.a.cx, m.a.cy);
            graphics.lineTo(m.b.cx, m.b.cy);
            graphics.lineTo(m.c.cx, m.c.cy);
            graphics.lineTo(m.a.cx, m.a.cy);
             
        }//drawtri
        
        
    }//classend
}


internal class xVert
{
  public var cx:Number = 0;
  public var cy:Number = 0;
  public var cz:Number = 0;
  
  public function copyVert(b:xVert):void  {     cx = b.cx; cy = b.cy; cz = b.cz;  }
  
  public function setValue(vx:Number, vy:Number, vz:Number):void
  { cx = vx; cy = vy; cz = vz;}
  
}//xvert

internal class xTri
{
  public var a:xVert = new xVert();
  public var b:xVert = new xVert();
  public var c:xVert = new xVert();
  
}//xtri

internal class xCutter
{

public var ret1:xTri = new xTri();
public var ret2:xTri = new xTri();

public var num:int = 0;

public var cx:Number = 0;
public var cy:Number = 0;
public var cz:Number = 0;

public var cnx:Number = 0;
public var cny:Number = 0;
public var cnz:Number = 0;


public function isFront(tri:xTri):int
{
    var ad:Number; var bd:Number; var cd:Number;
  
    ad = (tri.a.cx - cx) *cnx +  (tri.a.cy - cy) *cny +(tri.a.cz - cz) *cnz
    bd = (tri.b.cx - cx) *cnx +  (tri.b.cy - cy) *cny +(tri.b.cz - cz) *cnz  
    cd = (tri.c.cx - cx) *cnx +  (tri.c.cy - cy) *cny +(tri.c.cz - cz) *cnz
  
    if (ad > 0 && bd > 0 && cd > 0) { return 1; } //front of plane
    if (ad < 0 && bd < 0 && cd < 0) { return -1; } //behind plane
    return 0; //intersect    
}//isfront

public function cutTri(tri:xTri):int
{
  num = cutTriPlane(tri, cx, cy,cz, cnx, cny, cnz);
  return num;
}//cut


public static var tempOut:Vector.<xVert> = Vector.<xVert>([new xVert(), new xVert(), new xVert(), new xVert()]);

    public function cutTriPlane(tri:xTri,
    px:Number, py:Number, pz:Number,
    nx:Number, ny:Number, nz:Number):int
    {
      var vecOut:Vector.<xVert>;
      var it:int;
      var i:int;
      var ad:Number; var bd:Number; var cd:Number;
      var t:Number;
      var va:xVert; var vs:xVert;
      var da:Number; var ds:Number;
      var dw:xVert;
      
      vecOut = tempOut;
      
      
        ad = (tri.a.cx - px) *nx +  (tri.a.cy - py) *ny +(tri.a.cz - pz) *nz
        bd = (tri.b.cx - px) *nx +  (tri.b.cy - py) *ny +(tri.b.cz - pz) *nz
        cd = (tri.c.cx - px) *nx +  (tri.c.cy - py) *ny +(tri.c.cz - pz) *nz
      
        if (ad > 0 && bd > 0 && cd > 0) { return 0; } //front of plane
      
    
      it = 0;
    
      //todo -- unroll later (and by unroll i mean no loop really needed here)
      for (i = 0; i < 3; i++)
      {
        if (i == 0) 
        {
          va = tri.a;      vs = tri.c;      da = ad;      ds = cd;
        
        } else if (i == 1)
        {
          va = tri.b;      vs = tri.a;      da = bd;      ds = ad;
        
        } else 
        {
          va = tri.c;      vs = tri.b;      da = cd;      ds = bd;
        }
      
      
            if (da > 0 && ds > 0)
            {
              vecOut[it].copyVert(va);
              it += 1;
            }
            else if (da > 0 || ds > 0)
            {
              
                  t = da / (nx * (va.cx - vs.cx) + ny * (va.cy - vs.cy) +  nz * (va.cz - vs.cz) );
                  dw = vecOut[it];   
                          dw.cx = va.cx + (vs.cx - va.cx) * t;
                          dw.cy = va.cy + (vs.cy - va.cy) * t;
                          dw.cz = va.cz + (vs.cz - va.cz) * t;
                 
                       it += 1; 
                       
                  if (ds < 0)
                  {              
                    vecOut[it].copyVert(va);
                    it += 1;
                  }
            }//endif
            
      }//nexti
      
      if (it < 3) { return -1;}
      
      ret1.a.copyVert(vecOut[0]);
      ret1.b.copyVert(vecOut[1]);
      ret1.c.copyVert(vecOut[2]);
      
      if (it == 3) { return 1; }
      
      ret2.a.copyVert(vecOut[0]);
      ret2.b.copyVert(vecOut[2]);
      ret2.c.copyVert(vecOut[3]);
      
      
        return 2;
    }//cuttriplane

}//xcutter

