/**
 * Copyright nutsu ( http://wonderfl.net/user/nutsu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5Y5d
 */

// forked from alumican_net's [Sample] BoundaryResizer Demo
/**
 * 目的が似たクラス(FViewBox)があったので便乗しますた。
 * 描画目的なので出力がMatrixです。なので80行目あたりが主なあれです。
 * ※このクラスはあまり最適化はされてないです。これだけじゃないけど…
 * alumican.netさんに感謝。
 */
/**
 * フォーク元：
 * BoundaryResizerクラスを利用したリサイズ
 * 
 * このswfは下記URLで紹介している自作クラスのサンプルコードです
 * @see http://blog.alumican.net/2009/10/07_225251
 * 
 * @author alumican.net<Yukiya Okuda>
 */
package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Graphics;
	import flash.display.Loader;
	import flash.display.LoaderInfo;
	import flash.display.PixelSnapping;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Matrix;
	import flash.geom.Rectangle;
	import flash.net.URLRequest;
	import com.bit101.components.Label;
	import com.bit101.components.RadioButton;
	import com.bit101.components.PushButton;
	import flash.system.Security;
	import frocessing.geom.FViewBox;
	
	[SWF(width = 465, height = 465, backgroundColor = 0xffffff, frameRate = 30)]
	public class BoundaryResizerDemo extends Sprite
	{
		//----------------------------------------
		//CLASS CONSTANTS
		
		private const W:uint = 465;
		private const H:uint = 465;
		
		
		
		
		
		//----------------------------------------
		//VARIABLES
		
		private var _picture:Bitmap;
		private var _border:Sprite;
		
		private var viewbox:FViewBox;
		
		
		
		//----------------------------------------
		//METHODS
		
		private function _resize():void
		{			
			//USE VIEW BOX
			_picture.transform.matrix = viewbox.getTransformMatrix( _border.x, _border.y, _border.width, _border.height );
		}
		
		public function BoundaryResizerDemo():void 
		{
			Security.loadPolicyFile("http://swf.wonderfl.net/crossdomain.xml");
			
			var vBmd:BitmapData, hBmd:BitmapData;
			
			_picture = addChild(new Bitmap()) as Bitmap;
			var loader:Loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, function(e:Event):void
			{
				var bmd:BitmapData = new BitmapData(W, H, true, 0x00000000);
				bmd.draw(loader);
				var rect:Rectangle = bmd.getColorBoundsRect(0xffffffff, 0x00000000, false);
				var vb:FViewBox = new FViewBox( rect.x, rect.y, rect.width, rect.height );
				vb.scaleMode = FViewBox.SHOW_ALL;
				
				vBmd = new BitmapData(rect.width - 40, rect.height + 40, true, 0xff80ff80);
				vBmd.draw(bmd, vb.getTransformMatrix(0,0,vBmd.width,vBmd.height), null, null, null, true);
				
				hBmd = new BitmapData(rect.width + 100, rect.height - 80, true, 0xff80ff80);
				hBmd.draw(bmd, vb.getTransformMatrix(0,0,hBmd.width,hBmd.height), null, null, null, true);
				
				_picture.bitmapData = vBmd;
				_picture.smoothing = true;
				
				viewbox = new FViewBox( 0, 0, vBmd.width, vBmd.height );
				
				e.target.removeEventListener(e.type, arguments.callee);
				loader = null;
				
				_resize();
			} );
			loader.load(new URLRequest("http://swf.wonderfl.net/static/assets/checkmate04/AmateurAssets.swf"));
			
			_border = addChild(new Sprite()) as Sprite;
			var g:Graphics = _border.graphics;
			g.lineStyle(2, 0xff0000);
			g.drawRect(0, 0, 290, 290);
			_border.x = int((W - _border.width) / 2);
			_border.y = 60;
			
			var title:Label = new Label(this, 0, -8, "FViewBox Demo");
			title.scaleX = title.scaleY = 2;
			
			new PushButton(this, W - 99 - 10, 19 * 0 + 10, "Vertical Image"  , function():void { _picture.bitmapData = vBmd; _picture.smoothing = true; viewbox.width=vBmd.width; viewbox.height=vBmd.height; _resize(); } );
			new PushButton(this, W - 99 - 10, 19 * 1 + 10, "Horizontal Image", function():void { _picture.bitmapData = hBmd; _picture.smoothing = true; viewbox.width=hBmd.width; viewbox.height=hBmd.height; _resize(); } );
			
			var label0:Label = new Label(this, 10, H - 19 * 5 - 10, "scaleMode : NO_SCALE");
			new PushButton(this, 10, H - 19 * 4 - 10, "EXACT_FIT", function():void { viewbox.scaleMode = FViewBox.EXACT_FIT; _resize(); label0.text = "scaleMode : EXACT_FIT"; } );
			new PushButton(this, 10, H - 19 * 3 - 10, "SHOW_ALL" , function():void { viewbox.scaleMode = FViewBox.SHOW_ALL;  _resize(); label0.text = "scaleMode : SHOW_ALL";  } );
			new PushButton(this, 10, H - 19 * 2 - 10, "NO_BORDER", function():void { viewbox.scaleMode = FViewBox.NO_BORDER; _resize(); label0.text = "scaleMode : NO_BORDER"; } );
			new PushButton(this, 10, H - 19 * 1 - 10, "NO_SCALE" , function():void { viewbox.scaleMode = FViewBox.NO_SCALE;  _resize(); label0.text = "scaleMode : NO_SCALE";  } );
			
			var label1:Label = new Label(this, W - 99 * 3 - 10, H - 19 * 4 - 10, "align : CENTER");
			new PushButton(this, W - 99 * 3 - 10, H - 19 * 3 - 10, "TOP_LEFT"    , function():void { viewbox.align = FViewBox.TOP_LEFT;     _resize(); label1.text = "align : TOP_LEFT";     } );
			new PushButton(this, W - 99 * 2 - 10, H - 19 * 3 - 10, "TOP"         , function():void { viewbox.align = FViewBox.TOP;          _resize(); label1.text = "align : TOP";          } );
			new PushButton(this, W - 99 * 1 - 10, H - 19 * 3 - 10, "TOP_RIGHT"   , function():void { viewbox.align = FViewBox.TOP_RIGHT;    _resize(); label1.text = "align : TOP_RIGHT";    } );
			new PushButton(this, W - 99 * 3 - 10, H - 19 * 2 - 10, "LEFT"        , function():void { viewbox.align = FViewBox.LEFT;         _resize(); label1.text = "align : LEFT";         } );
			new PushButton(this, W - 99 * 2 - 10, H - 19 * 2 - 10, "CENTER"      , function():void { viewbox.align = FViewBox.CENTER;       _resize(); label1.text = "align : CENTER";       } );
			new PushButton(this, W - 99 * 1 - 10, H - 19 * 2 - 10, "RIGHT"       , function():void { viewbox.align = FViewBox.RIGHT;        _resize(); label1.text = "align : RIGHT";        } );
			new PushButton(this, W - 99 * 3 - 10, H - 19 * 1 - 10, "BOTTOM_LEFT" , function():void { viewbox.align = FViewBox.BOTTOM_LEFT;  _resize(); label1.text = "align : BOTTOM_LEFT";  } );
			new PushButton(this, W - 99 * 2 - 10, H - 19 * 1 - 10, "BOTTOM"      , function():void { viewbox.align = FViewBox.BOTTOM;       _resize(); label1.text = "align : BOTTOM";       } );
			new PushButton(this, W - 99 * 1 - 10, H - 19 * 1 - 10, "BOTTOM_RIGHT", function():void { viewbox.align = FViewBox.BOTTOM_RIGHT; _resize(); label1.text = "align : BOTTOM_RIGHT"; } );
		}
	}
}
