/**
 * Copyright Thy ( http://wonderfl.net/user/Thy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5Xu5
 */

package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.display.StageQuality;
	import flash.events.Event;
	import flash.events.MouseEvent;
	
	/**
	 * ...
	 * @author Thi
	 */
	public class Particulas extends Sprite 
	{
		
		public function Particulas():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
			stage.frameRate = 0
			stage.quality = StageQuality.LOW
			stage.addEventListener(MouseEvent.MOUSE_MOVE, ativar)
			//
			vars()
			
		}
		
		//_____________________________________________________________________________
		private function ativar(e:MouseEvent = null):void
		{
			stage.frameRate = 40
			stage.removeEventListener(MouseEvent.MOUSE_MOVE, ativar)
			stage.addEventListener(Event.MOUSE_LEAVE, desativar)
			stage.quality = StageQuality.BEST
			
		}
		
		private function desativar(e:Event = null):void
		{
			stage.frameRate = 0
			stage.addEventListener(MouseEvent.MOUSE_MOVE, ativar)
			stage.removeEventListener(Event.MOUSE_LEAVE, desativar)
			stage.quality = StageQuality.LOW
		}
		//_____________________________________________________________________________
		
		private var Sw:Number = stage.stageWidth, Sh:Number = stage.stageHeight
		
		private var numPart:int = 3
		private var Px:Vector.<Number> = new Vector.<Number>(numPart) // posição x
		private var Py:Vector.<Number> = new Vector.<Number>(numPart) // posição y
		private var Pvx:Vector.<Number> = new Vector.<Number>(numPart) // velo x
		private var Pvy:Vector.<Number> = new Vector.<Number>(numPart) // velo y
		private var Pc:Vector.<Number> = new Vector.<Number>(numPart) // cor
		private function vars():void
		{
			iniVector()
			iniStuff()
			addListeners()
		}
		
		private function iniVector():void
		{
			var i:int = 0
			while (i < numPart)
			{
				Px[int(i)] = Math.random() * Sw
				Py[int(i)] = Math.random() * Sh
				Pvx[int(i)] = Math.random() * 8 - 4
				Pvy[int(i)] = Math.random() * 8 - 4
				Pc[int(i)] = uint(Math.random() * 16777215)
				++i
			}
		}
		
		private var D:BitmapData
		private var B:Bitmap 
		
		private var scale:int = 2
		private var Sw1:Number = stage.stageWidth >> scale, Sh1:Number = stage.stageHeight >> scale
		
		private function iniStuff():void
		{
			D = new BitmapData(Sw1, Sh1, false, 0xFFFFFF)
			B = new Bitmap(D, "auto", true)
			B.scaleX = B.scaleY = 1 << scale
			stage.addChild(B)
		}
		
		private function addListeners():void
		{
			stage.addEventListener(Event.ENTER_FRAME, ef)
		}
		
		private function ef(e:Event = null):void
		{
			D.lock()
			particulasRefresh()
			D.unlock()
		}
		
		private function particulasRefresh():void
		{
			var i:int = 0
			while (i < numPart)
			{
				var X:Number = Px[int(i)]
				var Y:Number = Py[int(i)]
				var VX:Number = Pvx[int(i)]
				var VY:Number = Pvy[int(i)]
				var C:Number = Pc[int(i)]
				
				X += VX
				Y += VY
				X = X<0? X + Sw1 : X > Sw1? X - Sw1 : X
				Y = Y<0? Y + Sh1 : Y > Sh1? Y - Sh1 : Y
				
				D.setPixel(X, Y, C)
				
				Px[int(i)] = X
				Py[int(i)] = Y
				Pvx[int(i)] = VX
				Pvy[int(i)] = VY
				Pc[int(i)] = C
				
				++i
			}	
		}
	}
}