/**
 * Copyright Nyarineko ( http://wonderfl.net/user/Nyarineko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5XHl
 */

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.PixelSnapping;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Rectangle;
    
    [SWF(width = "465", height = "465", backgroundColor = "0xFFFFFF", frameRate = "60")]
    
    public class Main extends Sprite
    {
        private const WIDTH:Number = 465;
        private const HEIGH:Number = 465;
        
        private var _canvas:BitmapData;
        
        private var _fast:Particle;
            
        //------------------------------------------------------
        //コンストラクタ
        //------------------------------------------------------
        public function Main()
        {
            init();
        }
        
        //------------------------------------------------------
        //初期化
        //------------------------------------------------------
        private function init():void
        {
            _canvas = new BitmapData(WIDTH, HEIGH, true, 0x99FFFFFF);
            addChild(new Bitmap(_canvas)) as Bitmap;
            
            stage.addEventListener(Event.ENTER_FRAME,enterframeHandler);
            stage.addEventListener(MouseEvent.CLICK,onClick);
            
            //パーティクルを初期化
            _fast = new Particle();
            var p:Particle = _fast;
            for(var i:uint = 0;i < 10000;i++){
                if(i > 0){
                    p.next = new Particle();
                    p = p.next;
                }
                initParticle(p);
            }
        }
        
        private function onClick(e:MouseEvent):void
        {
            _canvas.fillRect(new Rectangle(0,0,WIDTH,HEIGH),0xffffffff);
            var p:Particle = _fast;
            while(p){
                initParticle(p);
                p = p.next;
            }
        }
        
        private function initParticle(p:Particle):void
        {
            p.x = Math.random() * WIDTH * 2 - WIDTH / 2;
            p.y = Math.random() * HEIGH * 2 - HEIGH / 2;
            p.cnt = 0;
            p.r = Math.random() * 0x1f + 0xE0;
            p.g = Math.random() * 0xff;
            p.b = Math.random() * 0x66 + 0x99;
            p.c = 0x99 << 24 | p.r << 16 | p.g << 8 | p.b;
        }
        
        //------------------------------------------------------
        //フレーム処理
        //------------------------------------------------------
        private function enterframeHandler(e:Event):void
        {
            update();
        }
        
        //フレーム処理：描画
        private function update():void {
            _canvas.lock();
            //_canvas.applyFilter(_canvas, _rect, new Point(), new BlurFilter(4, 4));
            var p:Particle = _fast;
            while(p){
                if(p.next && p.cnt < 1000){
                    p.x = p.x + (p.next.x - p.x) / 10;
                    p.y = p.y + (p.next.y - p.y) / 10;
                    if(Math.floor(p.cnt / 100) % 2 == 0){
                        p.c = 0x99 << 24 | p.r << 16 | p.g - (p.next.x - p.x)/4 << 8 | p.b - (p.next.y - p.y)/4;
                    }else{
                        p.c += (0x99ffffff - p.c) / 2;
                    }
                }else{
                    if(p.next){
                        p.x = p.x + (p.next.x - p.x) / 10;
                        p.y = p.y + (p.next.y - p.y) / 10;
                        if(Math.floor(p.cnt / 100) % 2 == 0){
                            p.c = 0x99 << 24 | p.r << 16 | p.g - (p.next.x - p.x)/4 << 8 | p.b - (p.next.y - p.y)/4;
                        }else{
                            p.c += (0x99ffffff - p.c) / 2;
                        }
                    }
                    p.c += (0x99ffffff - p.c) / 2;
                    p.x = p.x + ((WIDTH/2) - p.x) / 1000;
                    p.y = p.y + ((HEIGH/2) - p.y) / 1000;
                }
                _canvas.setPixel32(p.x,p.y,p.c);
                /*
                _canvas.setPixel32(p.x+1,p.y,p.c);
                _canvas.setPixel32(p.x-1,p.y,p.c);
                _canvas.setPixel32(p.x,p.y+1,p.c);
                _canvas.setPixel32(p.x,p.y-1,p.c);
                */
                p.cnt++;
                p = p.next;
            }
            _canvas.unlock();
        }
    }
}

class Particle
{
    public var x:Number;
    public var y:Number;
    public var vx:Number;
    public var vy:Number;
    public var c:uint;
    public var r:uint;
    public var g:uint;
    public var b:uint;
    public var next:Particle;
    public var cnt:Number;
    
    private const WIDTH:Number = 465;
    private const HEIGH:Number = 465;
        
    public function Particle()
    {
        this.vx = 0;
        this.vy = 0;
        this.cnt = 0;
    }
}