/**
 * Copyright albatrus_jp ( http://wonderfl.net/user/albatrus_jp )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5Wmn
 */

package {
	import flash.events.*;
	import org.papervision3d.lights.*;
	import org.papervision3d.materials.shadematerials.*;
	import org.papervision3d.materials.utils.*;
	import org.papervision3d.objects.primitives.*;
	import org.papervision3d.view.*;
	// ShadeMaterialSample クラス
	public class Material extends BasicView {
		public function Material() {
			// ライトを作成
			var light:PointLight3D = new PointLight3D(true, false);
			scene.addChild(light);
		
			// マテリアルを作成(使用したいマテリアルのコメントアウトを解除)
			var material:FlatShadeMaterial = new FlatShadeMaterial(light, 0xFFFFFF, 0x111111, 50);
			var material2:GouraudMaterial = new GouraudMaterial(light, 0xFFFFFF, 0x111111, 100);
			var material3:PhongMaterial = new PhongMaterial(light, 0xFFFFFF, 0x111111, 0);
			//var material:CellMaterial = new CellMaterial(light, 0xFFFFFF, 0x111111, 10);
			//var material:EnvMapMaterial = new EnvMapMaterial(light, new EnvImage(500,375), new EnvImage(500,375), 0x000000);
			
			// プリミティブオブジェクトの球体と直方体を作成
			var sphere:Sphere = new Sphere(material,200, 20, 20);
			var cube:Sphere = new Sphere(material3, 200,20,20);
			var sphere2:Sphere =new Sphere(material2,200,20,20);
			sphere.x = -350;
			cube.x = 350;
			cube.rotationX = -45;
			sphere2.y = 350;
			// 3Dシーンにプリミティブオブジェクトを表示
			scene.addChild(sphere);
			scene.addChild(cube);
			scene.addChild(sphere2);
			// レンダリング
			startRendering();
			
			// エンターフレームイベント
			addEventListener(Event.ENTER_FRAME, function(e:Event):void{
				// ライトの位置をマウスの座標と連動
				light.x =  2 * (mouseX - stage.stageWidth / 2);
				light.y = -2 * (mouseY - stage.stageHeight / 2);
				light.z = - 400;
			});
		}
	}
}