/**
 * Copyright kozaklukasz ( http://wonderfl.net/user/kozaklukasz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5Wd4
 */

package 
{
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.text.*;
    
    /**
     * ...
     * @author Kozak
     */
    public class M2 extends Sprite
    {
        private var _questions:Vector.<Sprite> = new Vector.<Sprite>();
        private var _answers:Vector.<Sprite> = new Vector.<Sprite>();
        private var _lines:Vector.<Line> = new Vector.<Line>();
        private var _startPoint:Object = {x:0, y:0, iQuestion:0};
        private var _container:Sprite;
        private var _data:XML;
        private var _drawLine:Shape;
        
        public function M2() 
        {
            _data = <data>
                        
                        <content>
                            <exercise>
                                <question>Pytanie 1</question>
                                <answer>Odpowiedz 1</answer>
                            </exercise>
                            <exercise>
                                <question>Pytanie 2</question>
                                <answer>Odpowiedz 2</answer>
                            </exercise>
                            <exercise>
                                <question>Pytanie 3</question>
                                <answer>Odpowiedz 3</answer>
                            </exercise>
                            <exercise>
                                <question>Pytanie 4</question>
                                <answer>Odpowiedz 4</answer>
                            </exercise>
                            <exercise>
                                <question>Pytanie 5</question>
                                <answer>Odpowiedz 5</answer>
                            </exercise>
                        </content>
                    </data>;
            
            
            _container = new Sprite();
            addChild(_container);
            
            var maskContainer:Sprite = new Sprite();
            addChild(maskContainer);
            maskContainer.graphics.beginFill(0x0);
            maskContainer.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            maskContainer.graphics.endFill();
            _container.mask = maskContainer;
            
            for (var i:int = 0; i < _data.content.exercise.length(); ++i)
            {
                var question:Sprite = new Sprite();
                _container.addChild(question);
                question.addEventListener(MouseEvent.MOUSE_DOWN, onDownQuestion);
                question.graphics.lineStyle(1, 0x333333);
                question.graphics.beginFill(0xDDDDDD);
                question.graphics.drawRect(0, 0, 200, 55);
                question.graphics.endFill();
                question.filters = [new DropShadowFilter(2.5, 45, 0x333333, 0.5)];
                question.name = "question" + i;
                
                var questionTf:TextField = new TextField();
                question.addChild(questionTf);
                questionTf.wordWrap = true;
                questionTf.text = _data.content.exercise[i].question;
                questionTf.width = question.width - 8;
                questionTf.height = question.height - 5;
                questionTf.x = 4;
                questionTf.y = question.height / 2 - questionTf.height / 2;
                
                question.y = i * 60;
                _questions.push(question);
                
                var answer:Sprite = new Sprite();
                _container.addChild(answer);
                answer.graphics.lineStyle(1, 0x333333);
                answer.graphics.beginFill(0xFFFFFF);
                answer.graphics.drawRect(0, 0, 200, 55);
                answer.graphics.endFill();
                answer.filters = [new DropShadowFilter(2.5, 45, 0x333333, 0.5)];
                
                var answerTf:TextField = new TextField();
                answer.addChild(answerTf);
                answerTf.wordWrap = true;
                answerTf.text = _data.content.exercise[i].answer;
                answerTf.width = answer.width - 8;
                answerTf.x = 4;
                answerTf.y = answer.height / 2 - answerTf.height / 2;
            
                answer.y = i * 60;
                answer.x = question.width + 115;
                _answers.push(answer);
            }
            
            var pos:Array = [];
            
            for (i = 0; i < _data.content.exercise.length(); ++i)
                pos.push(i);
            
                pos = shuffle(pos);
            for (i = 0; i < _questions.length; ++i)
                _questions[i].y = _answers[pos[i]].y;
            pos = shuffle(pos);
            for (i = 0; i < _answers.length; ++i)
                _answers[i].y = _questions[pos[i]].y;
                
            _drawLine = new Shape();
            _container.addChild(_drawLine);
            
            _container.y = stage.stageHeight / 2 - _container.height / 2;
            _container.x = stage.stageWidth / 2 - _container.width / 2;
        }
        
        private function onDownQuestion(event:MouseEvent):void 
        {
            _container.addChild(_drawLine);
            _startPoint.x = _container.mouseX;
            _startPoint.y = _container.mouseY;
            
            for (var i:int = 0; i < _questions.length; ++i)
                if (event.currentTarget.name == _questions[i].name)
                    _startPoint.iQuestion = i;
            
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMove);
            stage.addEventListener(MouseEvent.MOUSE_UP, onUp);
        }
        
        private function onMove(event:MouseEvent):void 
        {
            _drawLine.graphics.clear();
            _drawLine.graphics.lineStyle(1.5, 0xFF0000);
            _drawLine.graphics.moveTo(_startPoint.x, _startPoint.y);
            _drawLine.graphics.lineTo(_drawLine.mouseX, _drawLine.mouseY);
            _drawLine.graphics.beginFill(0xFF0000);
            _drawLine.graphics.drawCircle(_drawLine.mouseX, _drawLine.mouseY, 5);
        }
        
        private function onUp(event:MouseEvent):void 
        {
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMove);
            stage.removeEventListener(MouseEvent.MOUSE_UP, onUp);
            
            _drawLine.graphics.clear();
        
            var p:Point = new Point();
            var rec:Rectangle = new Rectangle();
            
            for (var i:int = 0; i < _answers.length; ++i)
            {
                p.x = _container.mouseX;
                p.y = _container.mouseY;
                
                rec.x = _answers[i].x; rec.y = _answers[i].y; 
                rec.width = _answers[i].width; rec.height = _answers[i].height; 
                
                if (hitTest(p, rec))
                {
                    for (var j:int = 0; j < _lines.length; ++j)
                    {
                        if (_lines[j].iQuestion == _startPoint.iQuestion)
                        {
                            _container.removeChild(_lines[j]);
                            _lines[j] = null;
                            
                            _lines.splice(j, 1);
                        }
                    }
                    
                    for (j = 0; j < _lines.length; ++j)
                    {
                        if (_lines[j].iAnswer == i)
                        {
                            _container.removeChild(_lines[j]);
                            _lines[j] = null;
                            
                            _lines.splice(j, 1);
                        }
                    }
                    
                    var line:Line = new Line();
                    _container.addChild(line);
                    _lines.push(line);
                    line.iAnswer = i;
                    line.iQuestion = _startPoint.iQuestion;
                    line.graphics.lineStyle(1.5, 0x626588);
                    
                    line.graphics.moveTo(_questions[_startPoint.iQuestion].x + _questions[_startPoint.iQuestion].width, _questions[_startPoint.iQuestion].y + _questions[_startPoint.iQuestion].height / 2);
                    line.graphics.lineTo(_questions[_startPoint.iQuestion].x + _questions[_startPoint.iQuestion].width + 10, _questions[_startPoint.iQuestion].y + _questions[_startPoint.iQuestion].height / 2);
                    
                    line.graphics.moveTo(_questions[_startPoint.iQuestion].x + _questions[_startPoint.iQuestion].width + 10, _questions[_startPoint.iQuestion].y + _questions[_startPoint.iQuestion].height / 2);
                    line.graphics.lineTo(_answers[i].x - 10, _answers[i].y + _answers[i].height / 2);
                    
                    line.graphics.moveTo(_answers[i].x - 10, _answers[i].y + _answers[i].height / 2);
                    line.graphics.lineTo(_answers[i].x, _answers[i].y + _answers[i].height / 2);
                }
            }
            
            
        }
        
        public static function shuffle( ar:Array ):Array 
        {
            var tmp:Array = [] ;
            var len:int   = ar.length;
            var index:int = len - 1 ;
            for (var i:int = 0; i < len; i++) 
            {
                tmp.push(pierce( ar, Math.round(Math.random() * index), false) );
                index-- ;
            }
            while(--len > -1) ar[len] = tmp[len]
            return ar ;
        } 
        
        public static function pierce(ar:Array, index:Number, flag:Boolean ):*
        {
            var item:* = ar[index] ;
            ar.splice(index, 1) ;
            return (flag) ? ar : item ;
        }
        
        private function hitTest(p:Point, rec:Rectangle):Boolean
        {
            return (p.x > rec.x && p.x < rec.x + rec.width && p.y > rec.y && p.y < rec.y + rec.height);
        }
        
        private function onClickCheckAnswer(event:MouseEvent):void 
        {
            
            var correct:Boolean = true;
            
            for (var i:int = 0; i < _lines.length; ++i)
            {
                if (_lines[i].iAnswer != _lines[i].iQuestion)
                    correct = false;
            }
            
            if (correct == false)
            {
                
            }
            else
            {
                var ct:ColorTransform = new ColorTransform();
            
                for (i = 0; i < _lines.length; ++i)
                {
                    if (_lines[i].iAnswer == _lines[i].iQuestion)
                    {
                        ct.color = 0x00FF00;
                        _lines[i].transform.colorTransform = ct;
                    }
                }
            }
        }
        
        private function onClickAlert(event:Event):void
        {
            if (event.target.name == "Powtórz")
            {
                for (var j:int = 0; j < _lines.length; ++j)
                {
                    _container.removeChild(_lines[j]);
                    _lines[j] = null;
                }
                
                _lines = null;
                _lines = new Vector.<Line>();
            }
            else
            {
                var ct:ColorTransform = new ColorTransform();
                
                for (var i:int = 0; i < _lines.length; ++i)
                {
                    ct.color = 0xB9BFD0;
                    _lines[i].transform.colorTransform = ct;
                    _lines[i].alpha = 0.65;
                }
                
                for (i = 0; i < _lines.length; ++i)
                {
                    var line:Line = new Line();
                    _container.addChild(line);
                    line.graphics.lineStyle(1.5, 0x00FF00);
                    
                    line.graphics.moveTo(_questions[_lines[i].iQuestion].x + _questions[_lines[i].iQuestion].width, _questions[_lines[i].iQuestion].y + _questions[_lines[i].iQuestion].height / 2);
                    line.graphics.lineTo(_questions[_lines[i].iQuestion].x + _questions[_lines[i].iQuestion].width + 10, _questions[_lines[i].iQuestion].y + _questions[_lines[i].iQuestion].height / 2);
                    
                    line.graphics.moveTo(_questions[_lines[i].iQuestion].x + _questions[_lines[i].iQuestion].width + 10, _questions[_lines[i].iQuestion].y + _questions[_lines[i].iQuestion].height / 2);
                    line.graphics.lineTo(_answers[_lines[i].iQuestion].x - 10, _answers[_lines[i].iQuestion].y + _answers[_lines[i].iQuestion].height / 2);
                    
                    line.graphics.moveTo(_answers[_lines[i].iQuestion].x - 10, _answers[_lines[i].iQuestion].y + _answers[_lines[i].iQuestion].height / 2);
                    line.graphics.lineTo(_answers[_lines[i].iQuestion].x, _answers[_lines[i].iQuestion].y + _answers[_lines[i].iQuestion].height / 2);
                }
                
                for (i = 0; i < _questions.length; ++i)
                    _questions[i].removeEventListener(MouseEvent.MOUSE_DOWN, onDownQuestion);
            }
        }
        
    }

}

final internal class Line extends flash.display.Sprite
{
    public var iAnswer:int;
    public var iQuestion:int;
}
