/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5WWk
 */

/*
 * 
 * 
*/
package 
{
    import flash.display.Sprite;
    import net.hires.debug.Stats;
    import flash.events.Event;
    import flash.events.NetStatusEvent;
    import flash.net.NetConnection;
    import flash.net.NetStream;
    import flash.media.Video;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.system.Security;
    import flash.geom.Matrix;
    import flash.events.MouseEvent;
    [SWF(backgroundColor="0x000000")]
    /**
     * ...
     * @author umhr
     */
    public class Main extends Sprite
    {
        private var baseURL:String = "";
        private var count:int;
        private var bmp_data : BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight , false , 0);
        //private var bmp : Bitmap = new Bitmap(bmp_data);
        private var stageWidth:int = stage.stageWidth;
        private var stageHeight:int = stage.stageHeight;
        private var sp:Sprite = Create.newSprite(null,[ ["buttonMode", true]]);
        
        
        function Main() {
            stage.scaleMode = "noScale";
            stage.align = "TL";
            //addChild(bmp);
            addChild(sp);
            addChild(new Stats());
            addEventListener(MouseEvent.CLICK,onClick);
            stage.addEventListener(Event.RESIZE, resizeHandler);
            var bitmap_array:Array = new Array();
            var imgLoadStatus:int = -1;
            
            if(isMztmjp()){
            }else{
                baseURL = "http://mztm.jp/wonderfl/";
                Security.loadPolicyFile("http://mztm.jp/crossdomain.xml");
            }
            var connection:NetConnection = new NetConnection();
            connection.connect(null);
            var netStream:NetStream = new NetStream(connection);
            netStream.addEventListener (NetStatusEvent.NET_STATUS ,NET_STATUS);
            function NET_STATUS (event : NetStatusEvent):void {
                if(event.info.code == "NetStream.Play.Stop"){
                    imgLoadStatus = 1;
                    video_obj.clear();
                }else if(event.info.code == "NetStream.Play.Start"){
                    imgLoadStatus = 0;
                }
            }
            netStream.client = new Object();
            netStream.play(baseURL+"medama2.flv");
            var video_obj : Video = new Video(160,120);
            video_obj.attachNetStream(netStream);
            video_obj.y = stageHeight/2-60;
            addChild(video_obj)
            
            //書き込み処理を行い続ける。
            stage.addEventListener(Event.ENTER_FRAME,ENTER_FRAME);
            
            var poz_array:Array = [0,0,0,0,0,0,0,0,0,0];
            
            function ENTER_FRAME(e:Event):void {
                
                if(imgLoadStatus > 0){
                }else if(imgLoadStatus == 0){
                    var bm1:BitmapData = new BitmapData(160,120);
                    bm1.draw(video_obj);
                    bitmap_array.push(new Bitmap(bm1));
                    video_obj.x += stageWidth/90;
                    return;
                }else if(imgLoadStatus == -1){
                    return;
                }
                
                count++;
                //Macのマウス座標を補正するために。
                var mouseX:Number = Math.min(Math.max(stage.mouseX,0),stageWidth);
                var mouseY:Number = Math.min(Math.max(stage.mouseY,0),stageHeight);
                
                var _x:Number;
                var r:int;
                var imgW:Number=0;
                var imgH:Number=0;
                var pozY:Number=0;
                var num:int;
                
                bmp_data.lock();
                var s:Number = stageHeight*(8.4546/465)
                for (var j:int = 0; j < 10; j++) {
                    pozY += imgH;
                    imgH = (j+1)*s;
                    imgW = 4*(imgH/3);
                    num = Math.ceil(stageWidth/imgW)+2;
                    //_x = (((mouseX - stageWidth / 2) / 200) * ((mouseY - (pozY + imgH / 2)) / 200) * count) % imgW;
                    poz_array[j] += (((mouseX - stageWidth / 2) / 80) * ((mouseY - (pozY + imgH / 2)) / 80) )
                    _x = poz_array[j] % imgW;
                    
                    for (var i:int = 0; i < num; i++) {
                        r = ((2-Math.atan2(mouseY-imgH/2-pozY+Math.random()*3,mouseX-imgW*i-_x+imgW/2+Math.random()*3)/Math.PI)*45)%90+Math.random()/4;
                        //Matrixで0.005を足しているのは、計算上のサイズだと隣の画像との境目が目立つ場合があるから。
                        bmp_data.draw(bitmap_array[r],new Matrix(imgH/120+0.005,0,0,imgH/120+0.005,imgW*i+_x-imgW,pozY));
                    }
                }
                
                bmp_data.unlock();
                Create.newSprite([,,,,sp],null,[["clear",null],["beginBitmapFill", [bmp_data]], ["drawRect", [0, 0, stageWidth,stageHeight]]]);
            }
        }
        private function isMztmjp():Boolean{
            var _str:String = stage.loaderInfo.url;
            return (_str.substr(0,5) == "file:" || _str.indexOf("mztm.jp") > -1);
        }
        private function onClick(e:MouseEvent = null):void{
            if(stage.displayState == "normal"){
                stage.displayState = "fullScreen";
            }else{
                stage.displayState = "normal";
            }
        }
        public function resizeHandler(e:Event = null):void {
              bmp_data.dispose();
            bmp_data = new BitmapData(stage.stageWidth, stage.stageHeight , false , 0);
            //bmp = new Bitmap(bmp_data);
            stageWidth = stage.stageWidth;
            stageHeight = stage.stageHeight;
        }
    }
}

import flash.display.DisplayObject;
import flash.display.Graphics;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.TextFormat;
import flash.display.Sprite;
import flash.display.Shape;
import flash.display.SimpleButton;
import flash.events.MouseEvent;
import flash.events.Event;
import flash.events.KeyboardEvent;


class Create{
    public static var defaultTextFormat:TextFormat = new TextFormat();
    
    public static function newSimpleButton(x_y_w_h_txt:Array = null,property:Array=null,graphics:Array=null):SimpleButton{
        var upState:Sprite = newSprite([x_y_w_h_txt[0],x_y_w_h_txt[1]],null,[["beginFill",[0xCCCCCC,1]],["drawRoundRect",[0,0,x_y_w_h_txt[2],x_y_w_h_txt[3],8]]]);
        upState.addChild(newShape([2,2],null,[["beginFill",[0xE5E5E5,1]],["drawRoundRect",[0,0,x_y_w_h_txt[2]-4,x_y_w_h_txt[3]-4,6]]]))
        var overState:Sprite = newSprite([x_y_w_h_txt[0],x_y_w_h_txt[1]],null,[["beginFill",[0xBBBBBB,1]],["drawRoundRect",[0,0,x_y_w_h_txt[2],x_y_w_h_txt[3],8]]]);
        overState.addChild(newShape([2,2],null,[["beginFill",[0xEEEEEE,1]],["drawRoundRect",[0,0,x_y_w_h_txt[2]-4,x_y_w_h_txt[3]-4,6]]]))
        var downState:Sprite = newSprite([x_y_w_h_txt[0],x_y_w_h_txt[1]],null,[["beginFill",[0xAAAAAA,1]],["drawRoundRect",[0,0,x_y_w_h_txt[2],x_y_w_h_txt[3],8]]]);
        downState.addChild(newShape([2,2],null,[["beginFill",[0xDDDDDD,1]],["drawRoundRect",[0,0,x_y_w_h_txt[2]-4,x_y_w_h_txt[3]-4,6]]]))
        var hitTestState:Shape = newShape([x_y_w_h_txt[0],x_y_w_h_txt[1]],null,[["beginFill",[0,1]],["drawRoundRect",[0,0,x_y_w_h_txt[2],x_y_w_h_txt[3],8]]]);
        if(x_y_w_h_txt[4]){
            upState.addChild(newTextField([0,2,x_y_w_h_txt[2],x_y_w_h_txt[3]-2],[["defaultTextFormat",new TextFormat("_sans", null, null, null, null, null, null, null, "center")],["text",x_y_w_h_txt[4]]]));
            overState.addChild(newTextField([0,2,x_y_w_h_txt[2],x_y_w_h_txt[3]-2],[["defaultTextFormat",new TextFormat("_sans", null, null, null, null, null, null, null, "center")],["text",x_y_w_h_txt[4]]]));
            downState.addChild(newTextField([0,3,x_y_w_h_txt[2],x_y_w_h_txt[3]-3],[["defaultTextFormat",new TextFormat("_sans", null, null, null, null, null, null, null, "center")],["text",x_y_w_h_txt[4]]]));
        }
        var sb:SimpleButton = new SimpleButton(upState,overState,downState,hitTestState);
        
        return sb;
    }
    
    public static function newShape(x_y_w_h_sh:Array = null,property:Array=null,graphics:Array=null):Shape{
        var i:int;
        var sh:Shape;
        if(x_y_w_h_sh && x_y_w_h_sh[4]){
            sh = x_y_w_h_sh[4];
        }else{
            sh = new Shape();
        }
        if(x_y_w_h_sh){
            if (x_y_w_h_sh[0]) { sh.x = x_y_w_h_sh[0] };
            if (x_y_w_h_sh[1]) { sh.y = x_y_w_h_sh[1] };
        }
        if(property){
            for (i = 0; i < property.length; i++) {
                if(property[i] && property[i].length > 1){
                    sh[property[i][0]] = property[i][1];
                }
            }
        }
        if(graphics){
            for (i = 0; i < graphics.length; i++) {
                if(graphics[i] && graphics[i].length > 1){
                    sh.graphics[graphics[i][0]].apply(null, graphics[i][1]);
                }
            }
            
        }
        if(x_y_w_h_sh){
            if (x_y_w_h_sh[2]) { sh.width = x_y_w_h_sh[2] };
            if (x_y_w_h_sh[3]) { sh.height = x_y_w_h_sh[3] };
        }
        return sh;
    }
    public static function newSprite(x_y_w_h_sp:Array = null,property:Array=null,graphics:Array=null,addChild:DisplayObject = null):Sprite{
        var i:int;
        var sp:Sprite;
        if(x_y_w_h_sp && x_y_w_h_sp[4]){
            sp = x_y_w_h_sp[4];
        }else{
            sp = new Sprite();
        }
        if(x_y_w_h_sp){
            if (x_y_w_h_sp[0]) { sp.x = x_y_w_h_sp[0] };
            if (x_y_w_h_sp[1]) { sp.y = x_y_w_h_sp[1] };
        }
        if(property){
            for (i = 0; i < property.length; i++) {
                if(property[i] && property[i].length > 1){
                    sp[property[i][0]] = property[i][1];
                }
            }
        }
        if(graphics){
            for (i = 0; i < graphics.length; i++) {
                if(graphics[i] && graphics[i].length > 1){
                    sp.graphics[graphics[i][0]].apply(null, graphics[i][1]);
                }
            }
            
        }
        if(addChild){
            sp.addChild(addChild);
        }
        if(x_y_w_h_sp){
            if (x_y_w_h_sp[2]) { sp.width = x_y_w_h_sp[2] };
            if (x_y_w_h_sp[3]) { sp.height = x_y_w_h_sp[3] };
        }
        return sp;
    }

    public static function newTextField(x_y_w_h_txt_color_alpha:Array = null,property:Array=null,method:Array=null):TextField{
        var i:int;
        var ta:TextField = new TextField();
        ta.defaultTextFormat = defaultTextFormat;
        if(x_y_w_h_txt_color_alpha){
            if (x_y_w_h_txt_color_alpha[0]) { ta.x = x_y_w_h_txt_color_alpha[0] };
            if (x_y_w_h_txt_color_alpha[1]) { ta.y = x_y_w_h_txt_color_alpha[1] };
            if (x_y_w_h_txt_color_alpha[2]) { ta.width = x_y_w_h_txt_color_alpha[2] };
            if (x_y_w_h_txt_color_alpha[3]) { ta.height = x_y_w_h_txt_color_alpha[3] };
            if (x_y_w_h_txt_color_alpha[4]) { ta.text = x_y_w_h_txt_color_alpha[4] };
            if (x_y_w_h_txt_color_alpha[5]) { ta.textColor = x_y_w_h_txt_color_alpha[5] };
            if (x_y_w_h_txt_color_alpha[6]) { ta.alpha = x_y_w_h_txt_color_alpha[6] };
        }
        if(property){
            for (i = 0; i < property.length; i++) {
                if(property[i] && property[i].length > 1){
                    ta[property[i][0]] = property[i][1];
                }
            }
        }
        if(method){
            for (i = 0; i < method.length; i++) {
                if(method[i] && method[i].length > 1){
                    ta[method[i][0]].apply(null, method[i][1]);
                }
            }
        }
        return ta;
    }
}
