/**
 * Copyright zahir ( http://wonderfl.net/user/zahir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5WTe
 */

/*
	自分的に使いやすいように
 */
package{
	import flash.display.Sprite;
	import flash.text.TextField;
	import flash.utils.ByteArray;
	
	import mx.utils.Base64Decoder;
	import mx.utils.Base64Encoder;

	public class MyBase64 extends Sprite{
    	private const codesetString:String = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    	private const orig:String = "abcdefg, あいうえお、hoge!";
		private var t:TextField = new TextField();
		public function MyBase64(){
			addChild(t);
			t.width = t.height = 465;
			
			var enc:Base64Encoder = new Base64Encoder();
			var dec:Base64Decoder = new Base64Decoder();
			var str:String = "";
			var b:ByteArray;
			
			/*
			t.appendText( "sdk付属Base64クラス\n" );
			enc.encode( orig );
			str = enc.toString();
			$("エンコード", str);
			dec.decode( str );
			b = dec.toByteArray();
			str = b.readUTFBytes( b.length );
			$("デコード", str);
			
			t.appendText("\n");
			
			enc.encodeUTFBytes( orig );
			str = enc.toString();
			$("エンコード(UTF)", str);
			dec.decode( str );
			b = dec.toByteArray();
			str = b.readUTFBytes( b.length );
			$("デコード(UTF)", str);
			
			t.appendText("\n\n");
			
			t.appendText("自作クラス\n");
			//*/
			
			str = Base64.encode( orig, "utf-8");
			$("エンコード", str);
			$("デコード", Base64.decodeMultiByte(str) );
			
			t.appendText("\n");
			
			str = Base64.encode( orig, Base64.SHIFT_JIS);
			$("エンコード(shift-jis)", str);
			$("デコード(shift-jis)", Base64.decodeMultiByte(str, Base64.SHIFT_JIS) );
			
			t.appendText("\n");
			
			str = Base64.encode( orig, Base64.EUC_JP);
			$("エンコード(euc)", str);
			$("デコード(euc)", Base64.decodeMultiByte(str, Base64.EUC_JP) );
			
			t.appendText("\n");
			t.appendText("useBreak\n");
			str = Base64.encode( 
				"いろはにほへと\n" + 
				"ちりぬるを\n" + 
				"わがよたれぞ\n" + 
				"つねならぬ\n" + 
				"ういのおくやま\n" + 
				"けふこえて\n" + 
				"あさきゆめみし\n" + 
				"えいもせず", Base64.UTF_8, true, 15);
			$("エンコード", "\n" + str);
			t.appendText("\n");
			$("デコード", Base64.decodeMultiByte(str) );
		}
		private function $(title:String, value:String):void{
			t.appendText( title + "  ::  " + value + "\n");
		}
	}
}

import __AS3__.vec.Vector;
import flash.utils.ByteArray;
import flash.utils.IDataInput;

class Base64{
	static public const EUC_JP:String = "euc-jp";
	static public const SHIFT_JIS:String = "shift-jis";
	static public const UTF_8:String = "utf-8";
	
	static private var encList:Vector.<String> = Vector.<String>([
		"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z",
		"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "z", "y", "z",
		"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "+", "/"
	]);
	
	static private var decList:Vector.<int> = Vector.<int>([
		64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
		64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
		64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 62, 64, 64, 64, 63,
		52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 64, 64, 64, 64, 64, 64,
		64, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14,
		15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 64, 64, 64, 64, 64,
		64, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40,
		41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 64, 64, 64, 64,
		64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
		64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
		64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
		64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
		64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
		64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
		64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
		64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64
	]);
	
	static public function decode( string:String ):ByteArray{
		var i:int = 0, len:int = string.length, count:int = 0;
		var arr:Array = [];
		var b:ByteArray = new ByteArray();
		for(;i<len;i++){
			var c:int = string.charCodeAt( i );
			if( c == 61) arr[ count++ ] = -1;
			else if( decList[c] != 64) arr[ count++ ] = decList[c];
			else continue;
			
			if(count == 4){
				count = 0;
				b.writeByte( (arr[0]<<2) | ((arr[1] & 0xFF) >> 4) );
				if(arr[2] == -1) break;
				b.writeByte( (arr[1]<<4) | ((arr[2] & 0xFF) >> 2) );
				if(arr[3] == -1) break;
				b.writeByte( (arr[2]<<6) | arr[3] );
			}
		}
		b.position = 0;
		return b;
	}
	// ByteArrayをいちいち処理するのが面倒なので
	static public function decodeMultiByte( string:String, charset:String = "utf-8"):String{
		var b:ByteArray = decode( string );
		return b.readMultiByte( b.length, charset );
	}
	
	static public function encode( string:String , charset:String = "utf-8", useBreak:Boolean = false, periodic:int = 10):String{
		var b:ByteArray = new ByteArray();
		b.writeMultiByte( string, charset );
		return encodeBytes( b , useBreak, periodic);
	}
	static public function encodeBytes( input:IDataInput , useBreak:Boolean = false, periodic:int = 10):String{
		var code:String = "";
		var b:ByteArray = new ByteArray();
		(input as ByteArray).position = 0;
		input.readBytes( b );
		b.position = 0;
		var len:int = b.length;
		var br:int = 0;
		periodic = (periodic < 0) ? 0 : periodic;
		while( b.bytesAvailable ){
			var _a:int = b.readUnsignedByte() & 0xFF;
			if( b.bytesAvailable == 0){
				code += encList[ _a >> 2 ];
				code += encList[ ( _a & 0x03 ) << 4 ];
				code += "==";
				break;
			} var _b:int = b.readUnsignedByte();
			if( b.bytesAvailable == 0 ){
				code += encList[ _a >> 2 ];
				code += encList[ (( _a & 0x03 ) << 4) | (( _b & 0xF0 )  >> 4  )];
				code += encList[ ( _b & 0x0F ) << 2 ];
				code += "=";
				break;
			}var _c:int = b.readUnsignedByte();
			code += encList[ _a >> 2 ];
			code += encList[ (( _a & 0x03 ) << 4) | (( _b & 0xF0 )  >> 4  ) ];
			code += encList[ (( _b & 0x0F ) << 2 ) | (( _c & 0xC0 ) >> 6 ) ];
			code += encList[ _c & 0x3F ];
			if(useBreak){
				br++;
				code += (br%periodic) ? "" : "\n";
			}
		}
		return code;
	}
}
