/**
 * Copyright selflash ( http://wonderfl.net/user/selflash )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5Vok
 */

// forked from poiasd's ゴムっぽい
// forked from poiasd's Chain
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.events.MouseEvent;

    [SWF (width = "465", height = "465", frameRate = "30", backgroundColor = "0x333333")]

    public class Chain extends Sprite {
        public const LINK_LENGTH:uint = 3;
        public const DELAY:Number = 1;
        
        public const JOINT_COUNT:uint = 100;
        public var jointList:Array = [];
        
        public function Chain ():void {
            for (var i:int = 0; i < JOINT_COUNT; i++) {
                var xx:Number  = Math.random() * stage.stageWidth;
                var yy:Number = Math.random() * stage.stageHeight;
                jointList[i] = new Point(xx, yy);
            }
                        
            addEventListener(Event.ENTER_FRAME, _loop);
            //stage.addEventListener(MouseEvent.MOUSE_MOVE, _mouseEventHandler);
        }
        
        private function _loop(event:Event):void {
            //先端
            var p:Point = jointList[0];
            p.x = mouseX;
            p.y = mouseY;
            
            graphics.clear();
            graphics.lineStyle(2, 0x000000, 0.5);
            graphics.moveTo(p.x, p.y);
            
            var l:int = jointList.length;
            for (var i:int = 0; i < l - 1; i++) {
                graphics.lineStyle(2 + i * 0.35, 0x000000, 1 - i*0.015);
                _chaseJoint(jointList[i], jointList [i + 1]);
                graphics.lineTo(jointList [i + 1].x, jointList[i + 1].y);
            }
            //if(l == 2) return; 
            //jointList.shift();
        }
        
        private function _chaseJoint (joint1:Point, joint2:Point):void {
            var dx:Number = joint1.x - joint2.x;
            var dy:Number = joint1.y - joint2.y;
            var d:Number = Math.sqrt(dx * dx + dy * dy);
            var rate:Number = (d - LINK_LENGTH) / d * DELAY;
            rate = (Math.abs(rate) < 0.1) ? 0 : rate;
            joint2.x += dx * rate;
            joint2.y += dy * rate;
        }
        
        private function _mouseEventHandler($event:MouseEvent):void {
            var l:int = jointList.length;
            jointList.push(new Point(jointList[l-1].x, jointList[l-1].y));            
        }

    }
}