/**
 * Copyright ultranoir ( http://wonderfl.net/user/ultranoir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5UiW
 */

// forked from terra1119's forked from: forked from: papervision test
// forked from terra1119's forked from: papervision test
// forked from terra1119's papervision test
package {
	import flash.display.Stage;
	import flash.display.StageScaleMode;
	import flash.display.StageAlign;
	import flash.display.StageQuality;
	import flash.display.Sprite;
	//import flash.display.MovieClip;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.geom.Matrix;
	import flash.geom.Rectangle;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.ProgressEvent;

	
	import org.papervision3d.view.BasicView;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.Plane;
	import org.papervision3d.materials.ColorMaterial;
	import org.papervision3d.events.InteractiveScene3DEvent;
	import org.papervision3d.materials.special.ParticleMaterial;
	import org.papervision3d.objects.special.ParticleField;
	
	//import org.papervision3d.view.stats.StatsView;

	import caurina.transitions.Tweener;
	
	//import myClass.XMLLoader;

	public class Main extends BasicView {

		private const DISTANCE:Number=500;
		private var theta:Number;
		private var no:int;
		private var flg:Boolean=false;
		private var selectedId:int=0;
		private var objs:Array;
		private var oldCameraX:Number;
		private var oldCameraY:Number;
		private var oldCameraZ:Number;
		private var oldRotX:Number;
		private var oldRotY:Number;
		private var oldRotZ:Number;
		private var nowPlane:Plane;
		//private var photoCloseBtn:closeBtn;

		private var array:Array=[];
		//private var imgLoader:ImgGroupLoader;
		private const contentsMax:int=30;
		
		public function Main() {
			stage.scaleMode=StageScaleMode.NO_SCALE;
			stage.align=StageAlign.TOP_LEFT;
			stage.quality=StageQuality.MEDIUM;
			super(0,0,true,true);
			buttonMode=false;
			//init();
			worldInit();
		}
                /*
		private function init() {
			//var sv:StatsView = new StatsView(renderer);
			//addChild(sv);
			imgLoader= new ImgGroupLoader();
			for (var i:int=0; i<contentsMax; i++) {
				imgLoader.addFile(String(i)+".jpg");
			}
			imgLoader.addEventListener(ProgressEvent.PROGRESS, _onProgress);
			imgLoader.addEventListener(Event.COMPLETE, _onComplete);
			imgLoader.start();
		}
		
		private function _onProgress(e:ProgressEvent):void {
			trace(Math.floor((e.bytesLoaded / e.bytesTotal) * 100));
		}
		
		private function _onComplete(e:Event):void {
			var il:ImgGroupLoader = e.target as ImgGroupLoader;
			il.removeEventListener(ProgressEvent.PROGRESS, _onProgress);
			il.removeEventListener(Event.COMPLETE, _onComplete);
			var bmpArray:Array=il.data();
			for(var i:int=0; i<contentsMax; i++){
				bmpArray[i].smoothing=true;
				var newBmp:BitmapData=fixBmp(bmpArray[i].bitmapData);
				array[i]=new Bitmap(newBmp);
			}
 			il=null;
			worldInit();
		}
		
		private function fixBmp(bmp:BitmapData):BitmapData{
			var bmpWidth:uint=720;
			var bmpHeight:uint=540;
			var xFixNum = bmpWidth/bmp.width;
			var yFixNum = bmpHeight/bmp.height;
			var fixScale:Number=Math.min(xFixNum, yFixNum);
			var newBmp:BitmapData=new BitmapData(bmpWidth,bmpHeight,false, 0x000000);
			var mat:Matrix = new Matrix();
			var xx:int=int((bmpWidth-bmp.width*fixScale)*.5);
			var yy:int=int((bmpHeight-bmp.height*fixScale)*.5);
			mat.scale(fixScale,fixScale);
			mat.translate(xx,yy);
			newBmp.draw(bmp,mat);
			bmp.dispose();
			return newBmp;
		}
		*/
		private function worldInit():void {
			no=0;
			theta=0;

			camera.z=-1000;
			camera.focus=500;
			camera.zoom=1;
			camera.target=DisplayObject3D.ZERO;
			var particleMat:ParticleMaterial=new ParticleMaterial(0xFFFFFF,0.4);
			var particles:ParticleField=new ParticleField(particleMat,500,1,2000,2000,2000);
			scene.addChild(particles);

			objs = [];

			for (var i:int=0; i<contentsMax; i++) {
				var material:ColorMaterial=new ColorMaterial(0xFFFFFF*Math.random());
				material.doubleSided=true;
				material.interactive=true;
				var obj:Plane=new Plane(material,80,60,1,1);
				scene.addChild(obj);
				obj.x=0;
				obj.y=0;
				obj.z=0;
				obj.alpha=0;
				obj.useOwnContainer=true;
				obj.name=String(i);
				obj.addEventListener(InteractiveScene3DEvent.OBJECT_CLICK, onClickHandler);
				obj.addEventListener(InteractiveScene3DEvent.OBJECT_OVER, onMouseOverHandler);
				obj.addEventListener(InteractiveScene3DEvent.OBJECT_OUT, onMouseOutHandler);
				objs[i]=obj;
			}
			startRendering();
			spread();
			
		}

		//リスナー
		override protected function onRenderTick(e:Event = null):void {
			if (! flg) {
				camera.x=DISTANCE*Math.sin(theta*Math.PI/180);
				camera.y=DISTANCE*Math.cos(theta*Math.PI/180);
				camera.z=DISTANCE*Math.cos(theta*Math.PI/180);
				theta+=0.4;
			}
			super.onRenderTick(e);
		}
		
		private function onClickHandler(e:Event):void {
			var i:int;
			
			if (! flg) {
				nowPlane=e.target as Plane;
				oldCameraX=camera.x;
				oldCameraY=camera.y;
				oldCameraZ=camera.z;
				oldRotX=nowPlane.rotationX;
				oldRotY=nowPlane.rotationY;
				oldRotZ=nowPlane.rotationZ;
				nowPlane.rotationX=0;
				nowPlane.rotationY=0;
				nowPlane.rotationZ=0;
				flg=true;
				
				var target:DisplayObject3D = new DisplayObject3D();
				target.copyTransform(nowPlane);
				target.moveBackward(56);
				// カメラを移動させる
				Tweener.addTween(camera, {x:target.x,y:target.y,z:target.z,time:1,transition:"easeInOut",onStart:onClickCameraStart,onComplete:onClickCameraComplete});
				for (i=0; i<contentsMax; i++) {
					Tweener.addTween(objs[i], {alpha:0,time:1,scale:1,transition:"easeInOut",onStart:onClickPlaneMoveStart,onStartParams:[objs[i]],onComplete:onClickPlaneMoveComplete,onCompleteParams:[objs[i]]});
				}
				// カメラのターゲットを移動させる
				Tweener.addTween(camera.target, {x:e.target.x,y:e.target.y,z:e.target.z,time:1,transition:"easeInOut",onStart:onClickCameraStart,onComplete:onClickCameraTargetComplete,onCompleteParams:[camera.target]});
				Tweener.addTween(nowPlane, {alpha:1,time:1,transition:"easeInOut",onStart:onClickPlaneMoveStart,onStartParams:[e.target],onComplete:onChanePlane,onCompleteParams:[nowPlane]});
			} else {
				stage.quality=StageQuality.MEDIUM;
				for (i=0; i<contentsMax; i++) {
					Tweener.addTween(objs[i], {alpha:1,time:1,transition:"easeInOut",onStart:onClickPlaneMoveStart,onStartParams:[objs[i]],onComplete:onClickPlaneMoveComplete,onCompleteParams:[objs[i]]});
				}
				nowPlane.rotationX=oldRotX;
				nowPlane.rotationY=oldRotY;
				nowPlane.rotationZ=oldRotZ;
				Tweener.addTween(camera, {x:oldCameraX,y:oldCameraY,z:oldCameraZ,focus:500,zoom:1,time:1,transition:"easeInOut",onStart:onClickCameraStart,onComplete:onClickFlgCameraComplete});
				Tweener.addTween(camera.target, {x:DisplayObject3D.ZERO.x,y:DisplayObject3D.ZERO.y,z:DisplayObject3D.ZERO.z,time:1,transition:"easeInOut",onComplete:onClickCameraTargetComplete,onCompleteParams:[camera.target]});
				
			}
		}
		
		private function onClickCameraStart():void{
			
		}
		
		private function onClickCameraComplete():void{
			Tweener.removeTweens(camera);
		}
		private function onClickFlgCameraComplete():void{
			Tweener.removeTweens(camera);
			flg=false;
		}
		
		private function onClickCameraTargetComplete(target:*):void{
			Tweener.removeTweens(target);
		}
		
		private function onClickPlaneMoveStart(plane:Plane):void{
			plane.removeEventListener(InteractiveScene3DEvent.OBJECT_CLICK, onClickHandler);
			plane.removeEventListener(InteractiveScene3DEvent.OBJECT_OVER, onMouseOverHandler);
			plane.removeEventListener(InteractiveScene3DEvent.OBJECT_OUT, onMouseOutHandler);
		}
		
		private function onClickPlaneMoveComplete(plane:Plane):void{
			plane.addEventListener(InteractiveScene3DEvent.OBJECT_CLICK, onClickHandler);
			plane.addEventListener(InteractiveScene3DEvent.OBJECT_OVER, onMouseOverHandler);
			plane.addEventListener(InteractiveScene3DEvent.OBJECT_OUT, onMouseOutHandler);
		}
		
		private function onChanePlane(plane:Plane):void{
			plane.addEventListener(InteractiveScene3DEvent.OBJECT_CLICK, onClickHandler);
			plane.addEventListener(InteractiveScene3DEvent.OBJECT_OVER, onMouseOverHandler);
			plane.addEventListener(InteractiveScene3DEvent.OBJECT_OUT, onMouseOutHandler);
			stage.quality=StageQuality.HIGH;
			//changePhoto();
		}
		
		private function onMouseOverHandler(e:InteractiveScene3DEvent):void {
			if (! flg) {
				Tweener.addTween(e.target, {time:0.4,scale:1.5,transition:"easeOutBack"});
			}
		}
		private function onMouseOutHandler(e:InteractiveScene3DEvent):void {
			if (! flg) {
				Tweener.addTween(e.target, {time:0.4,scale:1,transition:"easeOutBack"});
			}
		}

		private function onBtnRollOverHandler(e:MouseEvent):void {
			Tweener.addTween(e.target, {alpha:0.7,time:0.5,transition:"easeInOut"});
		}

		private function onBtnRollOutHandler(e:MouseEvent):void {
			Tweener.addTween(e.target, {alpha:1,time:0.5,transition:"easeInOut"});
		}

		private function spread():void {
			var i:int;
			var r:Number;
			var yPos:int;
			switch (no) {
				case 0 :
					for (i=0; i<contentsMax; i++) {
						Tweener.addTween(objs[i], {time:1,delay:0.02 * i,
						x:Math.random() * 2000 - 1000,
						y:Math.random() * 2000 - 1000,
						z:Math.random() * 2000 - 1000,
						rotationX:Math.random() * 360, 
						rotationY:Math.random() * 360, 
						rotationZ:Math.random() * 360,
						alpha:1,
						scale:1,
						transition:"easeOutBack",
						onStart:onPlaneMoveStart,
						onComplete:onPlaneMoveComplete,
						onCompleteParams:[i]
						});
					}
					break;
				case 1 :
					for (i=0; i<contentsMax; i++) {
						r=360/contentsMax*i;
						Tweener.addTween(objs[i], {
						time:1,
						delay:0.02 * i,
						x:Math.cos(r * 3 * Math.PI / 180) * 200,
						y:Math.sin(r * 3 * Math.PI / 180) * 200,
						z:i * 30 - 500,
						rotationX:0, 
						rotationY:0, 
						rotationZ:0,
						scale:1,
						transition:"easeOutBack",
						onStart:onPlaneMoveStart,
						onComplete:onPlaneMoveComplete,
						onCompleteParams:[i]
						});
					}
					break;
				case 2 :
					for (i=0; i<contentsMax; i++) {
						r=360/contentsMax*i;
						Tweener.addTween(objs[i], {
						time:1,
						delay:0.02 * i,
						x:Math.cos(r * Math.PI / 180) * 500,
						y:0,
						z:Math.sin(r * Math.PI / 180) * 500,
						rotationX:0, 
						rotationY:0, 
						rotationZ:0,
						scale:1,
						transition:"easeOutBack",
						onStart:onPlaneMoveStart,
						onComplete:onPlaneMoveComplete,
						onCompleteParams:[i]
						});
					}
					break;
				case 3 :
					var anglePer:Number = ((Math.PI*2) * (contentsMax/10)) / contentsMax;
					yPos=0;
					for (i=0; i<contentsMax; i++) {
						Tweener.addTween(objs[i], {
						time:1,
						delay:0.02 * i,
						x:Math.cos(i * anglePer) * 300,
						y:yPos-300,
						z:Math.sin(i * anglePer) * 300,
						rotationX:0, 
						rotationY:(-i*anglePer) * (180/Math.PI) + 270, 
						rotationZ:0,
						scale:1,
						transition:"easeOutBack",
						onStart:onPlaneMoveStart,
						onComplete:onPlaneMoveComplete,
						onCompleteParams:[i]
						});
						if( (i+1) % 10 == 0 ){
							yPos += 115;
						}
					}
					break;
				case 4 :
					var xPos:int=0;
					yPos=0;
					for (i=0; i<contentsMax; i++) {
						Tweener.addTween(objs[i], {
						time:1,
						delay:0.02 * i,
						x:xPos*140-700,
						y:yPos-300,
						z:0,
						rotationX:0, 
						rotationY:0, 
						rotationZ:0,
						scale:1,
						transition:"easeOutBack",
						onStart:onPlaneMoveStart,
						onComplete:onPlaneMoveComplete,
						onCompleteParams:[i]
						});
						xPos++;
						if( (i+1) % 10 == 0 ){
							yPos += 110;
							xPos=0;
						}
					}
					break;
				}
			no=int(Math.random()*5);
		}
		
		private function onPlaneMoveStart():void{
			for (var i:int=0; i<contentsMax; i++) {
				objs[i].removeEventListener(InteractiveScene3DEvent.OBJECT_CLICK, onClickHandler);
				objs[i].removeEventListener(InteractiveScene3DEvent.OBJECT_OVER, onMouseOverHandler);
				objs[i].removeEventListener(InteractiveScene3DEvent.OBJECT_OUT, onMouseOutHandler);
			}
		}
		
		private function onPlaneMoveComplete(i:int):void{
			objs[i].addEventListener(InteractiveScene3DEvent.OBJECT_CLICK, onClickHandler);
			objs[i].addEventListener(InteractiveScene3DEvent.OBJECT_OVER, onMouseOverHandler);
			objs[i].addEventListener(InteractiveScene3DEvent.OBJECT_OUT, onMouseOutHandler);
		}
		
		private function removeEndTween(target:*):void{
			Tweener.removeTweens(target);
		}
		/*
		private function changePhoto(id:int):void{
			photoCloseBtn=new closeBtn();
			photoCloseBtn.x=795;
			photoCloseBtn.y=35;
			photoCloseBtn.alpha=0;
			photoCloseBtn.buttonMode=true;
			photoCloseBtn.addEventListener(MouseEvent.CLICK,onCloseClick,false, 0, true);
			photoCloseBtn.addEventListener(MouseEvent.ROLL_OVER,onCloseOVER,false, 0, true);
			photoCloseBtn.addEventListener(MouseEvent.ROLL_OUT,onCloseOUT,false, 0, true);
			addChild(photoCloseBtn);
			Tweener.addTween(photoCloseBtn, {alpha:1,time:1,transition:"easeInOut",onComplete:removeEndTween,onCompleteParams:[photoCloseBtn]});
		}
		
		private function onCloseClick(e:MouseEvent):void{
			stage.quality=StageQuality.MEDIUM;
			
			for (var i:int=0; i<contentsMax; i++) {
				Tweener.addTween(objs[i], {alpha:1,time:1,transition:"easeInOut",onStart:onClickPlaneMoveStart,onStartParams:[objs[i]],onComplete:onClickPlaneMoveComplete,onCompleteParams:[objs[i]]});
			}
			nowPlane.rotationX=oldRotX;
			nowPlane.rotationY=oldRotY;
			nowPlane.rotationZ=oldRotZ;
			Tweener.addTween(camera, {x:oldCameraX,y:oldCameraY,z:oldCameraZ,focus:500,zoom:1,time:1,transition:"easeInOut",onStart:onClickCameraStart,onComplete:onClickFlgCameraComplete});
			Tweener.addTween(camera.target, {x:DisplayObject3D.ZERO.x,y:DisplayObject3D.ZERO.y,z:DisplayObject3D.ZERO.z,time:1,transition:"easeInOut",onComplete:onClickCameraTargetComplete,onCompleteParams:[camera.target]});
			
			if(photoCloseBtn!==null){
				photoCloseBtn.removeEventListener(MouseEvent.CLICK,onCloseClick);
				removeChild(photoCloseBtn);
				photoCloseBtn=null;
			}
		}
		
		private function onCloseOVER(e:MouseEvent):void{
			Tweener.addTween(e.target, { alpha:0.5,time:0.6,transition:"easeInOut", onComplete:removeEndTween,onCompleteParams:[e.target]});
		}
		
		private function onCloseOUT(e:MouseEvent):void{
			Tweener.addTween(e.target, { alpha:1,time:0.6,transition:"easeInOut", onComplete:removeEndTween,onCompleteParams:[e.target]});
		}
*/
	}
}
/*
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Loader;
import flash.events.Event;
import flash.events.EventDispatcher;
import flash.events.IOErrorEvent;
import flash.events.ProgressEvent;
import flash.net.URLRequest;

	class ImgGroupLoader extends EventDispatcher{
		private var loader:Loader;
		private var array:Array;
		private var returnArray:Array = [];
		
		public function ImgGroupLoader():void {
			loader = new Loader();
			array = [];
		}
		public function addFile(fileName:String):void{
			array.push(fileName);
		}
		public function start():void{
			var url:URLRequest = new URLRequest(array[returnArray.length]);
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE,onComplete);
			loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR,onIoerror);
			loader.load(url);
		}
		private function onIoerror(e:IOErrorEvent):void {
			dispatchEvent(e);
		}
		private function onComplete(e:Event):void{
			var _bmp:Bitmap = _loader.content as Bitmap;
			returnArray.push(_bmp);
			if (array.length == returnArray.length) {
				loader.contentLoaderInfo.removeEventListener (IOErrorEvent.IO_ERROR,onIoerror);
				loader.contentLoaderInfo.removeEventListener (Event.COMPLETE,onComplete);
				dispatchEvent(new Event(Event.COMPLETE));
			} else {
				dispatchEvent(new ProgressEvent(ProgressEvent.PROGRESS, false, false, returnArray.length, dataArray.length));
				start();
			}
		}
		public function get data():Array{
			return returnArray;
		}
	}
	*/