/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5Uby
 */

package
{
    import flash.display.*;
    import flash.system.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.text.*;
    
    [SWF(frameRate = 60, width = 465, height = 465)]
    public class Main extends Sprite
    {
        public function Main()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        }
        
        public function _init() :void
        {
            graphics.lineStyle (1, 0, 1);
            graphics.beginFill (0, 0.1);
            graphics.drawRect  (0, 0, 464, 464);
            graphics.endFill   ();    
        }

        public function addedToStage($e:Event) :void
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
            Buffer.buildContext(this);
            
            _init();
        }
    }
}

import flash.display.*;
import flash.system.*;
import flash.events.*;
import flash.geom.*;
import flash.text.*;

class Buffer
{
    public static var globalOutput :Output;
    
    public static var gridScatter :Boolean;
    public static var gridContext :Object;
    public static var gridMargin :Point;
    public static var gridScale :Point;
    public static var gridColor :Array;
    public static var gridNodes :Array;
    public static var gridCount :int;
    public static var nodeSize :int;
    public static var nodeNorm :int;
    public static var nodeRand :int;
    
    public static function buildContext($context:Object) :void
    {
        globalOutput = new Output("0")

        gridMargin = new Point();
        gridScale = new Point();
       
        gridContext = $context;
        gridScatter = false;
        gridMargin.x = 1.75;
        gridMargin.y = 2;
        gridScale.x = 12;
        gridScale.y = 12;
        gridNodes = [];
        gridCount = 0;
        nodeSize = 30;
        nodeNorm = 0;
        nodeRand = 0;
        gridColor = [0xCCCCCC, 0xBFBFBF, 0xB3B3B3, 0xA6A6A6, 0x999999, 0x8C8C8C, 0x808080, 0x737373, 0x666666, 0x595959, 0x4D4D4D, 0x404040,
                     0xFF9999, 0xFF8080, 0xFF6666, 0xFF4D4D, 0xFF3333, 0xFF1A1A, 0xFF0000, 0xE60000, 0xCC0000, 0xB30000, 0x990000, 0x800000,
                     0xFFCE99, 0xFFC180, 0xFFB566, 0xFFA94D, 0xFF9C33, 0xFF901A, 0xFF8400, 0xE67700, 0xCC6900, 0xB35C00, 0x994F00, 0x804200,
                     0xFFFF99, 0xFFFF80, 0xFFFF66, 0xFFFF4D, 0xFFFF33, 0xFFFF1A, 0xFFFF00, 0xE6E600, 0xCCCC00, 0xB3B300, 0x999900, 0x808000,
                     0xCFFF99, 0xC3FF80, 0xB8FF66, 0xACFF4D, 0xA0FF33, 0x94FF1A, 0x88FF00, 0x7AE600, 0x6DCC00, 0x5FB300, 0x529900, 0x448000,
                     0x99FF99, 0x80FF80, 0x66FF66, 0x4DFF4D, 0x33FF33, 0x1AFF1A, 0x00FF00, 0x00E600, 0x00CC00, 0x00B300, 0x009900, 0x008000,
                     0x99FFCF, 0x80FFC3, 0x66FFB8, 0x4DFFAC, 0x33FFA0, 0x1AFF94, 0x00FF88, 0x00E67A, 0x00CC6D, 0x00B35F, 0x009952, 0x008044,
                     0x99FFFF, 0x80FFFF, 0x66FFFF, 0x4DFFFF, 0x33FFFF, 0x1AFFFF, 0x00FFFF, 0x00E6E6, 0x00CCCC, 0x00B3B3, 0x009999, 0x008080,
                     0x99CFFF, 0x80C3FF, 0x66B8FF, 0x4DACFF, 0x33A0FF, 0x1A94FF, 0x0088FF, 0x007AE6, 0x006DCC, 0x005FB3, 0x005299, 0x004480,
                     0x9999FF, 0x8080FF, 0x6666FF, 0x4D4DFF, 0x3333FF, 0x1A1AFF, 0x0000FF, 0x0000E6, 0x0000CC, 0x0000B3, 0x000099, 0x000080,
                     0xCF99FF, 0xC380FF, 0xB866FF, 0xAC4DFF, 0xA033FF, 0x941AFF, 0x8800FF, 0x7A00E6, 0x6D00CC, 0x5F00B3, 0x520099, 0x440080,
                     0xFF99FF, 0xFF80FF, 0xFF66FF, 0xFF4DFF, 0xFF33FF, 0xFF1AFF, 0xFF00FF, 0xE600E6, 0xCC00CC, 0xB300B3, 0x990099, 0x800080];
             
        for (var $x:Number = gridMargin.x; $x < (gridScale.x + gridMargin.x); $x++)
        {  
            gridNodes[$x] = [];
            
            for (var $y:Number = gridMargin.y; $y < (gridScale.y + gridMargin.y); $y++)
            {
                gridNodes[$x][$y] = new GridNode($x, $y, nodeSize, nodeColumn(gridCount), gridColor[gridCount]);
                $context.addChild(gridNodes[$x][$y]);
                gridCount ++;
            }
        }
        
        $context.addChild(globalOutput);
    }
    
    private static function nodeColumn($i:Number) :int
    {
        var column_:int = 0;
        
        for (var $:int = 0; $ < 144; $+=12)
        {
            if ($i >= $ && $i < $+12)
            {
                ++column_;
            }
        }
        
        return column_;
    }
    
    public static function gridBehavior() :void
    {
        for (var $x:Number = gridMargin.x; $x < (gridScale.x + gridMargin.x); $x++)
        {  
            for (var $y:Number = gridMargin.y; $y < (gridScale.y + gridMargin.y); $y++)
            {
                gridNodes[$x][$y].assignBehavior();
            }
        }
    }
    
    public static function parseNodeStatus($n:GridNode) :void
    {
        var $enumNodes :int = 0;
        
        for (var $x:Number = gridMargin.x; $x < (gridScale.x + gridMargin.x); $x++)
        {  
            for (var $y:Number = gridMargin.y; $y < (gridScale.y + gridMargin.y); $y++)
            {
                switch (gridNodes[$x][$y].status)
                {
                    case 1: //scattered
                        $enumNodes++;
                        nodeRand = $enumNodes;
                        
                        if (gridNodes[$x][$y].column != $n.column)
                        {
                            $n.mouseEnabled = false;
                            $n.alpha = 0.2;
                        }

                        break;
                    case 2: //normalized
                        break;
                    case 3: //completed
                        break;
                }
            }
        }
    }
}

class GridNode extends Sprite
{    
    protected var _x :Number;
    protected var _y :Number;
    protected var _rand :Point;
    protected var _norm :Point;
    protected var _line :Number;
    protected var _color :Number;
    protected var _alpha :Number;
    protected var _width :Number;
    protected var _height :Number;
    protected var _status :int;
    protected var _column :int;

    private var globalBegin :Point;
    private var globalCurrent :Point;
    private var localCalc :Point;
    
    public function GridNode($x:Number, $y:Number, $scale:Number, $column:int, $color:Number)
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _rand = new Point();
        _norm = new Point();
        
        _x = _norm.x = ($x * $scale);
        _y = _norm.y = ($y * $scale);
        _rand.x = int(Math.random() * (465 - $scale));
        _rand.y = int(Math.random() * (465 - $scale));
        _width = _height = $scale;
        _column = $column;
        _color = $color;
        _status = 0;
        _alpha = 1;
        _line = 0;
        
        globalBegin = new Point();
        globalCurrent = new Point();
        localCalc = new Point();
    }
    
    public function _init() :void
    {
        graphics.clear     ();
        graphics.lineStyle (1, 0xFFFFFF, _line);
        
        graphics.beginFill (_color, _alpha);
        graphics.drawRect  (_x, _y, _width, _height);
        graphics.endFill   ();
    }
    
    public function addedToStage($e:Event) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _init();
        
        addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
    }
    
    public function onMouseDown($e:MouseEvent) :void
    {      
        _line = 0.9; _init();
        parent.setChildIndex(this, (parent.numChildren - 2));
        globalBegin = new Point($e.stageX, $e.stageY);

        stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
    }
    
    public function onMouseMove($e:MouseEvent) :void
    {
        globalCurrent = new Point($e.stageX, $e.stageY);
        localCalc = Point(globalCurrent.subtract(globalBegin));
        
        x = (x + localCalc.x);
        y = (y + localCalc.y);
        
        globalBegin = globalCurrent;
    }
    
    public function onMouseUp($e:MouseEvent) :void
    {
        stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
        stage.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        
        _line = 0; _init();
        globalBegin = null;
        
        Buffer.gridBehavior();
    }
    
    public function assignBehavior() :void
    {
        switch (Buffer.gridScatter)
        {
            case true:
                addEventListener(Event.ENTER_FRAME, normalizeOnFrame);
                break;
            case false:
                addEventListener(Event.ENTER_FRAME, scatterOnFrame);
                break;
        }
    }
    
    public function scatterOnFrame($e:Event) :void
    {
        if  (((x < (_rand.x-0.01)) || (x > (_rand.x+0.01))) && ((y < _rand.y-0.01) || (y > _rand.y+0.01)))
        {
            x += ((_rand.x - x) / 6); y += ((_rand.y - y) / 6);
        }else{
            removeEventListener(Event.ENTER_FRAME, scatterOnFrame);
            
            x = _rand.x;
            y = _rand.y;
            _status = 1;
            Buffer.parseNodeStatus(this);
        }
    }
    
    public function normalizeOnFrame($e:Event) :void
    {
    //    if  (((x < regX-0.00001) || (x > regX+0.00001)) && ((y < regY-0.00001) || (y > regY+0.00001))) {x += ((x - regX)/3); y -= ((y - regY)/3);}
    //    else {removeEventListener(Event.ENTER_FRAME, normalizeOnFrame); x = regX; y = regY; isNormalized = true; mouseEnabled = false; Buffer.parseProgress()}    
    }
    
    public function get fill() :Number
    { return _color }
    public function get randoms() :Point
    { return _rand }
    public function get normals() :Point
    { return _norm }
    public function get status() :int
    { return _status }
    public function get column() :int
    { return _column }
    public override function get alpha() :Number
    { return _alpha }
    public override function get x() :Number
    { return _x }
    public override function get y() :Number
    { return _y }
    public override function get width() :Number
    { return _width }
    public override function get height() :Number
    { return _height }

    public function set fill($:Number) :void
    { _color = $; _init() }
    public function set randoms($:Point) :void
    { _rand = $ }
    public function set normals($:Point) :void
    { _norm = $ }
    public function set status($:int) :void
    { _status = $ }
    public function set column($:int) :void
    { _column = $ }
    public override function set alpha($:Number) :void
    { _alpha = $; _init() }
    public override function set x($:Number) :void
    { _x = $; _init() }
    public override function set y($:Number) :void
    { _y = $; _init() }
    public override function set width($:Number) :void
    { _width = $; _init() }
    public override function set height($:Number) :void
    { _height = $; _init() }
}

class Output extends TextField
{
    private var textFormat :TextFormat;
    
    protected var _x :Number;
    protected var _y :Number;
    protected var _font :String;
    protected var _content :String;
        
    public function Output($content:String, $x:Number = 1, $y:Number = 0, $font:String = "Helvetica")
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _x = $x;
        _y = $y;
        _font = $font;
        _content = $content;
        
        multiline = true;
        autoSize = "left";
        selectable = mouseEnabled = false;
        antiAliasType = AntiAliasType.ADVANCED;
    }
    
    public function _init() :void
    {
        x = _x;
        y = _y;
        text = _content;
        
        textFormat = new TextFormat(_font);
        setTextFormat(textFormat);
    }
    
    public function addedToStage($e:Event) :void
    {
       removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
       
       _init(); 
    }
    
    public function get font() :String
    { return _font }
    public function get nWidth() :Number
    { return width }
    
    public function set font($:String) :void
    { _font = $; _init() }
    public function set content($:String) :void
    { _content = $; _init() }
}
