/**
 * Copyright smirnov48 ( http://wonderfl.net/user/smirnov48 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5UQ6
 */

package {
    import flash.utils.getTimer;
    import flash.text.TextField;
    import flash.geom.Point;
    import flash.events.Event;
    import flash.ui.Keyboard;
    import flash.events.KeyboardEvent;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        private var screenData:BitmapData;
        private var playerSpawns:Array = new Array();
        private var fruitSpawns:Array = new Array();
        private var ghostSpawns:Array = new Array();
        private var ghosts:Array = new Array();
        private var player:Point = new Point();
        private var log:TextField = new TextField();
        private var lastTurnTime:int = 0;
        /*
            0 - empty
            1 - wall
            2 - pacman start
            3 - fruit
            4 - enemy spawn
            5 - pillow
            6 - tablet(on init in alll empty cells)
        */
        private var level:Array = [
            [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
            [1,5,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,5,1],
            [1,0,1,1,0,1,1,1,0,0,0,0,1,1,1,0,1,1,0,1],
            [1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1],
            [1,0,1,1,0,1,1,0,1,1,1,1,0,1,1,0,1,1,0,1],
            [1,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,1],
            [1,1,1,2,1,1,0,1,1,0,0,1,1,0,1,1,2,1,1,1],
            [1,0,0,0,0,0,0,1,4,0,4,0,1,0,0,0,0,0,0,1],
            [1,0,1,1,0,1,0,1,0,4,0,4,1,0,1,0,1,1,0,1],
            [1,0,0,1,0,0,0,1,1,1,1,1,1,0,0,0,1,0,0,1],
            [1,1,0,1,0,1,0,0,1,3,3,1,0,0,1,0,1,0,1,1],
            [1,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,1],
            [1,0,1,1,1,1,1,1,0,1,1,0,1,1,1,1,1,1,0,1],
            [1,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,1],
            [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]           
        ];
        public function FlashTest() {
            screenData = new BitmapData(20,15,false,0);
            var screen:Bitmap  = new Bitmap(screenData);
            screen.width = 320;
            screen.height = 240;
            addChild(screen);
            init();
            spawnPlayer();
            spawnGhosts();
            addEventListener(Event.ENTER_FRAME, tick);
            stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
            addChild(log);
        }
        private function onKeyUp(e:KeyboardEvent):void {
                lastTurnTime = getTimer();
                movePlayer(e.keyCode);
                moveGhosts();
        }
        private function init():void {
            for (var i:int = 0; i < level.length; i++) {
                for (var j:int = 0; j < level[0].length; j++) {
                   if (level[i][j]==0) {
                       level[i][j] = 6;
                   }
                    if (level[i][j]==2) {
                        playerSpawns.push(new Point(i,j));
                        level[i][j] = 6;
                    }
                    if (level[i][j]==3) {
                        fruitSpawns.push(new Point(i,j));
                        level[i][j] = 6;
                    }
                    if (level[i][j]==4) {
                        ghostSpawns.push(new Point(i,j));
                        level[i][j] = 6;
                    }
                }
            }
        }
        private function spawnPlayer():void {
            var position:int = Math.floor(Math.random() * playerSpawns.length);
            player = playerSpawns[position].clone();
            level[player.x][player.y] = 0;
        } 
        private function spawnGhosts():void {
            for (var i:int = 0; i < ghostSpawns.length; i++) {
                ghosts.push(ghostSpawns[i].clone());
            }            
        }       
        private function tick(e:Event):void {
            if (getTimer() - lastTurnTime > 1000) {
                lastTurnTime = getTimer();
                moveGhosts();
            }
            drawMap();
            drawGhosts();
            drawPlayer();
        }
        private function movePlayer(keyCode:uint):void {
                var x:int = player.x;
                var y:int = player.y;
                if (keyCode == Keyboard.UP) {
                    x--;
                }
                if (keyCode == Keyboard.DOWN) {
                    x++;
                }
                if (keyCode == Keyboard.LEFT) {
                    y--;
                }
                if (keyCode == Keyboard.RIGHT) {
                    y++;
                }
                if (level[x][y] != 1) {
                    player.x = x;
                    player.y = y;
                    level[x][y] = 0;
                }
        }
        private function moveGhosts():void {
            for (var i:int = 0; i < ghosts.length; i++) {
                var ghost:Point  = ghosts[i] as Point;
                var x:int = ghost.x;
                var y:int = ghost.y;
                var isVert:Boolean = Math.floor(Math.random()*10)<5;
                if (isVert) { 
                    var isUp:Boolean= Math.floor(Math.random()*10)<5;
                    if (isUp) {
                        x--;
                    } else {
                        x++;
                    }
                } else {
                    var isLeft:Boolean = Math.floor(Math.random()*10)<5;
                    if (isLeft) {
                        y++;
                    } else {
                        y--;
                    }
                }
                if (level[x][y] != 1 && !isThereAGhost(x,y)) {
                   ghost.x = x;
                   ghost.y = y; 
                }
            }
        }
        private function isThereAGhost(x:int, y:int):Boolean {
            for (var i:int = 0; i < ghosts.length; i++) {
                if (ghosts[i].x == x && ghosts[i].y == y) {
                    return true;
                }
            }
            return false;
        }
        private function drawPlayer():void {
            screenData.setPixel(player.y, player.x, 0xFFFF00);
        }
        private function drawGhosts():void {
            for (var i:int = 0; i < ghosts.length; i++) {
                screenData.setPixel(ghosts[i].y, ghosts[i].x, 0xFF0000);
            }
        }
        private function drawMap():void {
            for (var i:int = 0; i < level.length; i++) {
                for (var j:int = 0; j < level[0].length; j++) {
                   if (level[i][j]==0) {
                        screenData.setPixel(j,i,0x000000);
                    }
                    if (level[i][j]==1) {
                        screenData.setPixel(j,i,0x00FFFF);
                    }
                    if (level[i][j]==2) {
                        screenData.setPixel(j,i,0xFFFF00);
                    }
                    if (level[i][j]==3) {
                        screenData.setPixel(j,i,0xFF00FF);
                    }
                    if (level[i][j]==4) {
                        screenData.setPixel(j,i,0xFF0000);
                    }
                    if (level[i][j]==5) {
                        screenData.setPixel(j,i,0x0000FF);
                    }
                    if (level[i][j]==6) {
                        screenData.setPixel(j,i,0xFFFFFF);
                    }
                }
            }
        }
    }
}