/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5Txe
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.media.Sound;
    import flash.net.URLRequest;

    public class SimpleSoundPlayer extends Sprite {
        private const URL_OF_SOUND_FILE:String = "http://www.iamas.ac.jp/~mayfair/tmp/snare.mp3";

        private var _sound:Sound;

        public function SimpleSoundPlayer() {
            _sound = new Sound();
            _sound.addEventListener(Event.COMPLETE, onLoadComplete);
            _sound.load(new URLRequest(URL_OF_SOUND_FILE));
        }

        private function onLoadComplete(e:Event):void {
            // サンプルのロードが完了したらマウスダウンで再生するように
            // イベントリスナをセットする
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
        }

        private function onMouseDown(e:MouseEvent):void {
            // MP3にエンコードした時に頭に空白が入ってしまうため
            // スタートポイントを30ms後にしてレスポンスを改善する
            _sound.play(30);
        }
    }
}
