/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5Tvc
 */

package {
  import flash.display.Sprite;

  import funnel.*;
  import funnel.ui.*;

  public class MeasurePressure extends Sprite {
    private var arduino:Arduino;

    // 感圧センサに接続したピン
    private var sensorPin:Pin;

    // LED
    private var led:LED;

    public function MeasurePressure() {
      // LEDに接続したピンのモードをPWMにセット
      var config:Configuration = Arduino.FIRMATA;
      config.setDigitalPinMode(9, PWM);
      arduino = new Arduino(config);

      // LEDのインスタンスを生成
      led = new LED(arduino.digitalPin(9));

      // 感圧センサに接続したピンを表す変数を初期化
      sensorPin = arduino.analogPin(0);
      sensorPin.addEventListener(PinEvent.CHANGE, onChange);
    }

    // センサの値が変化する度に以下を実行
    private function onChange(e:PinEvent):void {
      // センサの値に応じてLEDの輝度をセット
      led.intensity = sensorPin.value;
    }
  }
}