/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5Tpj
 */

package {
    import caurina.transitions.Tweener;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        private var _frame:uint;
        
        public function FlashTest() {
            _frame = 0;
            this.addEventListener(Event.ENTER_FRAME, proc);
        }
        
        private function proc(e:Event):void {
            if (_frame == 0) {
                _frame = 2 + (Math.random() * 8);
                createRing();
            }
            else {
                --_frame;
            }

        }
        
        private function createRing():void {
            var r:Ring = new Ring();
            r.x = Math.random() * 300 + 80;
            r.y = Math.random() * 300 + 80;
            var scale:Number = 0.25 + (0.75 * Math.random());
            var width:Number = 1.0 * scale;
            var height:Number = 0.25 * scale;
            r.scaleX = 0.01 * width;
            r.scaleY = 0.01 * height;
            r.alpha = 0.4;
            this.addChild(r);
            
            var endScale:Number = 2.5;
            Tweener.addTween(r,
            {
                scaleX:endScale * width,
                scaleY:endScale * height,
                alpha:0,
                time:60,
                useFrames:true,
                onComplete:function():void { this.removeChild(r); }
            });
        }

    }
}

import flash.display.Sprite;
import flash.display.LineScaleMode;

class Ring extends Sprite
{
    public function Ring() {
        this.graphics.lineStyle(
            3,
            0x000000,
            1,
            true,
            LineScaleMode.NORMAL);
        this.graphics.drawCircle(0, 0, 100);
    }
}
