/**
 * Copyright ongaeshi ( http://wonderfl.net/user/ongaeshi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5TXM
 */

// forked from umhr's Twitterの検索
// 矢印キーでスクロールスピードを調整出来ます
/*
 * Twitter Search API Method: search
 * http://apiwiki.twitter.com/Twitter-Search-API-Method%3A-search
 * 
 * Twitter API 仕様書 (勝手に日本語訳シリーズ)
 * http://watcher.moe-nifty.com/memo/2007/04/twitter_api.html
 * */
package {
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.IOErrorEvent;
	import flash.events.KeyboardEvent;
	import flash.events.MouseEvent;
	import flash.events.TextEvent;
	import flash.net.URLRequest;
	import flash.net.URLLoader;
	import flash.text.TextField;
	import flash.text.TextFieldType;
	import flash.text.TextFormat;
	import flash.net.navigateToURL;
	import caurina.transitions.Tweener;

	/**
	 * ...
	 * @author umhr
	 */
	[SWF(backgroundColor = "0x590073", frameRate = "120")]
	
	public class Main extends Sprite {
		private var _resultStage:Sprite = new Sprite();

                private var c_SearchBackGround:uint = 0xFF00E9;
                private var c_SearchText:uint = 0xFFFFFF;
		private var c_TailBackGround:uint = 0x590073;

                private var c_TitleBackGround:uint = 0xACFF80;
                private var c_TitleBorder:uint = 0x0C58E8;
                private var c_TitleText:uint = 0x0C58E8;

                private var c_ResultBackGround:uint = 0x00FBFF;
                private var c_ResultBorder:uint = 0xFF00E9;
                private var c_ResultText:uint = 0x590073;

		private var tfY:int = 0;

		private var speed_:int = 1;

		private var speedBar_:TextField;

		public function Main():void {
			//ヘッダーのサーチエリア
			//背景
			var titleArea:Shape = new Shape();
			titleArea.graphics.beginFill(c_SearchBackGround);
			titleArea.graphics.drawRect(0, 0, 465, 23);
			// titleArea.graphics.beginFill(c_TailBackGround);
			// titleArea.graphics.drawRect(0, 23, 465, 465);
			addChild(titleArea);

			//Searchの文字
			var searchWord:TextField = new TextField();
			searchWord.text = "検索:";
			searchWord.width = 33;
			searchWord.height = 18;
			searchWord.x = 2;
			searchWord.y = 2;
			searchWord.textColor = c_SearchText;
			addChild(searchWord);
			//テキスト入力欄。キーボードのキーを押し上げた際にonKeyUpが実行される
			var title:TextField = new TextField();
			title.text = "ヤクルト";
			title.width = 426;
			title.height = 18;
			title.x = 36;
			title.y = 2;
			title.border = true;
			title.borderColor = c_TitleBorder;
			title.background = true;
			title.backgroundColor = c_TitleBackGround;
                        title.textColor = c_TitleText;
			title.type = TextFieldType.INPUT;
			title.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
			addChild(title);

			//検索結果を配置するSpriteをaddChild
			_resultStage.y = 25;
			addChildAt(_resultStage, 0);
			
			//初期状態で検索結果画面が出るように、検索を実行する。
			search(title.text);

			// スピード制御
			stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);

			//　スピード表示
			speedBar_ = new TextField();
			var format:TextFormat = new TextFormat();
			format.size = 30;
			speedBar_.defaultTextFormat = format;
			speedBar_.width = 465;
			speedBar_.y = stage.stageHeight * 0.5 - Number(format.size);
			speedBar_.autoSize = "center";
			speedBar_.background = true;
			speedBar_.backgroundColor = 0x000000;
			speedBar_.border = true;
                        speedBar_.textColor = 0xFFFFFF;
			speedBar_.alpha = 0;
			speedBar_.text = "";
			addChild(speedBar_);
		}
		
		private function onKeyUp(e:KeyboardEvent):void {
			//Enterキーのキーコード13だったら、searchメソッドを実行。引数には適すと入力欄の文字列
			if (e.keyCode == 13) {
				search(e.currentTarget.text)
				speed_ = 1;
			}
		}
		
		public function search(searchWord:String):void {
			//検索APIにリクエストを投げる
			//http://search.twitter.com/crossdomain.xml上で許可をしているので
			//特に指定しなくても自動的に確認して、許可を得られる
			var myURLLoader:URLLoader = new URLLoader();
			myURLLoader.addEventListener(Event.COMPLETE, onCompleteXML);
			myURLLoader.addEventListener(IOErrorEvent.IO_ERROR, onIoError);
			// 検索オプション
			var xmlURL:String = "http://search.twitter.com/search.atom?q=";
			//encodeURIComponent()を使うことによって、#や日本語にも対応
			xmlURL += encodeURIComponent(searchWord);		//*1
			// 日本語のみ
			xmlURL += "&lang=ja"; 
			// 件数表示
			xmlURL += "&rpp=100";
			// 検索結果のうち、指定したIDより大きな値のIDの発言のみを返す
			// xmlURL += "&since_id=7584851355";
			// 読み込み
			myURLLoader.load(new URLRequest(xmlURL));
		}
		
		public function onIoError(e:IOErrorEvent):void {
			trace(e.type);
		}
        
		private function onCompleteXML(e:Event):void {
			//eventListenerを削除
			e.currentTarget.removeEventListener(Event.COMPLETE, onCompleteXML);
			//_resultStage上のオブジェクトを全て削除
			while (_resultStage.numChildren) {
				_resultStage.removeChildAt(0);
			}
			
			//XML型にキャスト
			var myXML:XML = new XML(e.currentTarget.data);
//			trace("========");
//			trace(myXML);
			//namespaceを設定
			default xml namespace = new Namespace("http://www.w3.org/2005/Atom");		//*2
			
			//ヘッダーの下
			tfY = 0;
			//要素を取り出して、textFieldを作りならべる
			var itemLength:int = myXML.entry.length();
			
			for (var i:int = 0; i < itemLength; i++) {
				//xmlからlink,authorName,titleの各値を取得
				var link:String = myXML.entry[i].link[0].@href;
				var authorName:String = myXML.entry[i].author.name;
				var title:String = myXML.entry[i].title;
				//アイコン画像のURLを取得
				var imgURL:String = myXML.entry[i].link[1].@href;
				//bmpフォーマットのアイコン画像を使っている人も少なくないため、Flashで使えるファイルの拡張子かどうかを判別
				var extention:String = imgURL.substr( -4);
				extention = extention.toLowerCase();
				if (extention != ".jpg" && extention != ".gif" && extention != ".png") {
					//Flashで使える画像の拡張子ではなかった場合にはデフォルトアイコンを指定
					imgURL = "http://s.twimg.com/a/1254440757/images/default_profile_mini.png";
				}
				//画像のファイル名が日本語などの規定外の文字である場合を考慮しエンコードする
				imgURL = encodeURI(imgURL);		//*3
				//小さい画像で十分なので、名前を差し替える
				imgURL = imgURL.replace(/_normal\./, "_mini\.");
				
				//得られた各値をhtmlTextに入るように整形
				var htmldata:String = "";
				htmldata = "<a href='" + link + "' target='_blank'>";
				htmldata += "<img src='" + imgURL + "' width='24' height='24' />";
				htmldata += "<b>" + authorName + "</b> " + title + "</a>";
				
				//検索結果のテキストフィールド
				var myTextField:TextField = new TextField();
				myTextField.width = 460;
				myTextField.x = 2;
				myTextField.wordWrap = true;
				myTextField.background = true;
				myTextField.backgroundColor = c_ResultBackGround;
				myTextField.border = true;
				myTextField.borderColor = c_ResultBorder;
                                myTextField.textColor = c_ResultText;
				myTextField.htmlText = htmldata;
				myTextField.autoSize = "left";
				
				//テキストフィールドのy座標はtfYに加算していくことにより、決定
				myTextField.y = tfY;
				tfY += myTextField.height + 3;
				_resultStage.addChild(myTextField);

				//スクロール
				myTextField.addEventListener(Event.ENTER_FRAME, updateText);
				
			}
		}

		private function updateText(e:Event):void {
		    e.target.y -= speed_;

		    var size:int = Math.max(tfY, 465);
		    
		    if (e.target.y + e.target.height < -24)
		      e.target.y += size + 100;

		    if (e.target.y > size)
		      e.target.y -= size + 100;
		}

		private function onKeyDown(e:KeyboardEvent):void {
		    if (e.keyCode == 38) {
			speed_ -= 1;

			if (speed_ < -10)
			  speed_ = -10;

 			updateSpeedBar();
			  
		    } else if (e.keyCode == 40) {
			speed_ += 1;

			if (speed_ > 10)
			  speed_ = 10;

 			updateSpeedBar();
		    }
		}

		private function updateSpeedBar():void {
		    speedBar_.text = speed_.toString();
		    speedBar_.alpha = 1;
		    Tweener.addTween(speedBar_, {time:1, alpha:0, transition:"linear"});
		}
	}
}