/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5Szy
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.net.*
    import flash.text.*;
    import flash.media.*;
    import flash.ui.*;
    import flash.system.Capabilities;

    public class FlashTest extends Sprite {
        private var url:String = "rtmfp://p2p.rtmfp.net/3ea2ccfc17227d122a776d41-31e9e4d71a17/";
        
        private var gs:GroupSpecifier;//接続グループ機能制限
        private var nc:NetConnection;
        private var group:NetGroup;
        private var groupName:String;   
        private var user:userList = new userList();    
        private var userCnt:int = 1;
        
        private var so:SharedObject;
        
        private var txt1:TextField = new TextField();
        private var txt2:TextField = new TextField();
        public function FlashTest() {
            // write as3 code here..
            addChild(txt1);
            txt1.border = true;
            txt1.text = url;
            txt1.width = 450;
            txt1.height = 300;
            
            addChild(txt2);
            txt2.addEventListener(KeyboardEvent.KEY_UP,onEnterKey);
            txt2.type ="input";
            txt2.border = true;
            txt2.width = 450;
            txt2.y = 300;
            /*
            txt1.appendText("\n"+Capabilities.os);
            txt1.appendText(" "+Capabilities.language);
            txt1.appendText(" "+Capabilities.screenResolutionX);
            txt1.appendText(" "+Capabilities.screenResolutionY);
            */
            //SOロード
            try{
                so = SharedObject.getLocal("log");
            }
            catch(e:Error){
                
            }

            var date:Date = new Date();
            if(so.data.cnt){
                txt1.appendText("\nSOロード");
                so.data.cnt++;
                txt1.appendText(" cnt:"+so.data.cnt);
                so.flush();
            }
            else{
                txt1.appendText("\nSO作成");
                so.data.cnt = 1;
                so.data.date = date.getTime();
                so.flush();
            }


            
            init();
            doConnect();
        }
        
        private var _netConnection:NetConnection;
 
        private function doConnect():void{
        　　nc = new NetConnection();
        　　nc.addEventListener(NetStatusEvent.NET_STATUS, netStatusHandler);//通信イベント
        　　nc.connect(url);
        }
 
        //通信イベント
        private function netStatusHandler(event:NetStatusEvent):void {
            var now:Date = new Date();
            //txt1.appendText("\n"+now.toLocaleTimeString());
            //txt1.appendText("    info.code : "+event.info.code);
            switch (event.info.code) {
                case "NetConnection.Connect.Success"://接続確立
                    txt1.appendText("\nRTMFP通信準備完了");
                    //onConnect();
                    groupConnect();
                    break;
                case "NetConnection.Connect.Failed":// 接続に失敗した
                    txt1.appendText("\n接続失敗");
                    break;
                case "NetConnection.Connect.Closed":// 接続が閉じられた
                    txt1.appendText("\nRTMFP通信終了");
                    break;
                case "NetGroup.Connect.Rejected":
                    txt1.appendText("\n"+event.info.group); 
                    break;
                case "NetGroup.Connect.Success"://グループ接続確立
                    txt1.appendText("\nグループへ接続");
                    txt1.appendText("\n"+groupName);
                    break;
                case "NetGroup.Neighbor.Connect"://メンバー接続
                    txt1.appendText("\nメンバー接続");
                    txt1.appendText("\nPeerID:"+event.info.peerID);
                    txt1.appendText("\nネイバー："+event.info.neighbor+"\n");
                    user.addUser(event.info.peerID,userCnt.toString());
                    userCnt++;
                    txt1.appendText("\nName: "+user.list[event.info.peerID]); 
                    var message:Object = new Object();
                    message.text = "１対１通信可能";
                    var s:String = group.sendToNearest(message,event.info.neighbor);
                    ping(event.info.neighbor);
                    if(s == NetGroupSendResult.SENT)txt1.appendText("\nネイバー送信済み");
                    else txt1.appendText("\n"+s);
                    
                    break;
                case "NetGroup.Neighbor.Disconnect"://メンバー切断
                    txt1.appendText("\nメンバー切断");
                    //txt1.appendText("\nPeerID:"+event.info.peerID);
                    //txt1.appendText("\nネイバー："+event.info.neighbor+"\n");
                    txt1.appendText("  Name: "+user.list[event.info.peerID]+"\n");
                    break;
                    
                // ポストデータ到着の通知
                case "NetGroup.Posting.Notify":
                    txt1.appendText("\n"+event.info.message.text);
                    //onPosting(event.info.messageID, event.info.message);
                    break;
                case "NetGroup.SendTo.Notify"://個別通信
                    //txt1.appendText("\n"+event.info.message.text);
                    if(event.info.message.ping==1){//ping受信
                        var mes:Object = event.info.message;
                        mes.ping = 2;
                        group.sendToNearest(mes,event.info.from);
                    }
                    else if(event.info.message.ping==2){
                        var time2:int = now.time - event.info.message.time.time;
                        txt2.text = "ping:"+time2;
                        ping(event.info.from);
                        
                    }


                    break;
            }
            txt1.scrollV = txt1.numLines;//オートスクロール
        }
        private function onEnterKey(e:KeyboardEvent):void{
            if(e.keyCode == Keyboard.ENTER){
                var now:Date = new Date();
                txt1.appendText("\n"+now.toLocaleTimeString()+" post");
                txt1.appendText("\n"+txt2.text);
                aaa();
                txt2.text = "";
                txt1.scrollV = txt1.numLines;//オートスクロール
            }

        }

        private function aaa():void{
            // 送信用オブジェクトの生成
            var message:Object = new Object;
            
            // データの設定
            //message.user = userNameText.text;
            message.text = txt2.text;
            //message.sequence = sequenceNumber++;
            message.sender = nc.nearID;
            // post() の実行
            group.post(message);
        }

        
        private function init():void{
            // グループ機能制限
            groupName = new String();
            groupName = "net.wonderfl.ozmap.test111"
            gs = new GroupSpecifier(groupName);//接続グループ名
            gs.postingEnabled = true;//ポスティング許可
            gs.ipMulticastMemberUpdatesEnabled = true;//IP情報のマルチキャスト許可
            gs.multicastEnabled = true;//NetStreamによるストリーミング許可
            gs.objectReplicationEnabled = true;//オブジェクトの複製許可
            gs.routingEnabled = true;//NetGroupでの転送メソッド許可
            gs.serverChannelEnabled = true;//メンバーへサーバーチャンネルを開く権限を付与
        }
        
        private function groupConnect():void{
            group = new NetGroup(nc, gs.groupspecWithAuthorizations());
            group.addEventListener(NetStatusEvent.NET_STATUS, netStatusHandler);
        }

        
        private function onConnect():void {
            txt1.appendText("\nnearID: " + nc.nearID);//クライアントID
            txt1.appendText("\nfarID:" + nc.farID);//接続先(Stratus)ID
            
        }
 
       //IDを略語に置き換える
        //未登録なIDならリストにIDを追加する
        //追加したIDに略語（ハンドルネーム)を与える
        //SOを利用してクライアントPCを識別する
        //ハンドルネームはクライアントPCに１つ割り当てる
        //セッション数が増えたらハンドルネームの後に数字を割り当てる
        private function ping(address:String,timeout:int=0):String{
            var message:Object = new Object();
            //タイムアウトの指定　sec
            if(0 < timeout){
                
            }
 
            message.ping = 1;
            var time:Date = new Date();
            message.time = time;
            return group.sendToNearest(message,address);        
        }


        
    }
}

class userList{
    public var list:Object;
    public function userList(){
        list = new Object();
        
    }
    public function addUser(id:String,name:String=""):void{
        //未登録なら追加
        if( list.hasOwnProperty(id)==false ){
            list[id] = name;
        }

    }

 
}
