/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5So5
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.utils.Timer;
    import frocessing.color.ColorHSV;
    public class QuasimondoSunFlower extends Sprite {
        static private const SEED_AMOUNT:Number = 500;
        static public const STATE_ONE_STEP:String = "stateManual";
        static public const STATE_STEP_BY_STEP:String = "stateAutomatic";
        private var i:int;
        private var state:String = STATE_STEP_BY_STEP;
        private var _radius:int=0;
        private var _padding:int=0;
        private var divergence:Number;
        private const C_X:Number = 200;
        private const C_Y:Number = 200;
        private var x_previous:Number=C_X;
        private var y_previous:Number=C_Y;
        private var lineSprite:Sprite;
        private var bitmapData:BitmapData;
        private var rect:Rectangle;
        private var point:Point;
        private var blurFilter:BlurFilter;
        private var seedSprite:Sprite;
        private var timer:Timer;

        public function QuasimondoSunFlower() {
            point =    new Point;
            blurFilter = new BlurFilter(2,2,10);
            var bitmap:Bitmap = Bitmap(addChild(new Bitmap(new BitmapData(465,465,true,0))));
            lineSprite = Sprite(addChild(new Sprite));
            seedSprite = Sprite(addChild(new Sprite));
            bitmapData = BitmapData(bitmap.bitmapData);
            rect =          bitmapData.rect;
            renderSpiral( SEED_AMOUNT, 7, 4, 0);
            //renderSpiral( 120, 10, 5, 1);
            addEventListener(Event.REMOVED_FROM_STAGE, onRemovedFromStage);
        }
        
        private function onRemovedFromStage(e:Event):void 
        {
            trace( "QuasimondoSunFlower.onRemovedFromStage > e : " + e );
            removeEventListener(Event.REMOVED_FROM_STAGE, onRemovedFromStage);
            timer.removeEventListener(TimerEvent.TIMER, onTimer);
            timer.removeEventListener(TimerEvent.TIMER, continueBluring);
            timer = null;
        }
        
        
        
        private function renderSpiral( count:int, radius:int, padding:int, magicAngleIndex:uint = 0 ):void
        {
        _padding = padding;
        _radius = radius;
        
            var g:Graphics = seedSprite.graphics;
            g.lineStyle(0,0);
            lineSprite.graphics.moveTo(C_X, C_Y);
            divergence = [137.50776,99.50078,222.492][magicAngleIndex % 3] / 180 * Math.PI;
            switch (state) 
            {
                case STATE_STEP_BY_STEP:
                    timer = new Timer(100);
                    timer.addEventListener(TimerEvent.TIMER, onTimer);
                    timer.start();
                break;
                case STATE_ONE_STEP:
                    for ( i = 1; i <= count; doIncrementI() )
                    {
                        doSaw();
                    }
                break;
                default:
                
                break;
            }
        }
        
        private function doIncrementI():void 
        {
            i++
        }
        
        
        private function onTimer(e:TimerEvent):void 
        {
            doIncrementI();
            trace( "i : " + i );
            doSaw()
            if (i > SEED_AMOUNT)
            {
                Timer(e.target).removeEventListener(TimerEvent.TIMER, onTimer);
                    timer.addEventListener(TimerEvent.TIMER, continueBluring);
                    timer.start();
                    lineSprite.graphics.clear()
            }
        }
        
        private function doSaw():void 
        {
            var g:Graphics = seedSprite.graphics;
            var lg:Graphics = lineSprite.graphics;
            lg.clear();
            lg.lineStyle(_radius*2);
            var r:Number = (_radius + _padding) * Math.sqrt( i ) - _radius * 0.3;
            var a:Number = divergence * i;
            g.beginFill((new ColorHSV(360 * i / SEED_AMOUNT)).value);
            var x_current:Number = C_X + Math.cos( a ) * r;
            var y_current:Number = C_Y + Math.sin( a ) * r;
            lg.moveTo(x_previous, y_previous);
            x_previous = x_current;
            y_previous = y_current;
            lg.lineTo(x_current, y_current);
            g.drawCircle(x_current ,y_current , _radius);
            g.endFill();
            continueBluring(null);
        }
        
        private function continueBluring(e:TimerEvent):void 
        {
            bitmapData.draw(lineSprite);
            bitmapData.applyFilter(bitmapData, rect, point , blurFilter );
            if (e!=null)
            {
                if (Timer(e.target).currentCount>100) 
                {
                    trace( "Timer(e.target).currentCount : " + Timer(e.target).currentCount );
                    Timer(e.target).removeEventListener(TimerEvent.TIMER,continueBluring)
                }
            }
        }
        
        

    }
}