/**
 * Copyright NullBaySea ( http://wonderfl.net/user/NullBaySea )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5Sk9
 */

// use a container to contain a camera video
// if press capture. the video replaced by the bitmapdata. 
// !!!!!! the bitmap image is SMALLER (USING THE MATRIX OBJECT)
// if press reset the camera video back again

package {
    import flash.display.MovieClip;
    import flash.media.Camera;
    import flash.media.Video;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.geom.Matrix;
    import flash.geom.Point;
    // fullscreen
    import flash.display.Stage
    import flash.display.StageDisplayState

    public class Main extends MovieClip {
        // data for the camera
        private var CameraObj:Camera;
        private var VideoObj:Video;
        private var VidW:int = 640;
        private var VidH:int = 480;
        // data for the bitmapdata
        private var BitmapDataStage:BitmapData;
        private var BitmapStage:Bitmap;
        private var BitW:int = 1024;
        private var BitH:int = 768;
        private var ScaleRatio:Number = .05;
        private var tx:int = Math.floor(VidW * ScaleRatio);
        private var ty:int = Math.floor(VidH * ScaleRatio);
        private var k:int = 0;
        private var row:int = 32;
        private var total:int = row*32;
        // for the bitmap size transformation
        private var MatrixTransform:Matrix;
        // a bitmap array to store 100 image
        private var BitmapDataArray :Array = new Array();
        //
        public function Main() {
            if (stage != null) {
                init();
            } else {
                addEventListener(Event.ADDED_TO_STAGE , on_ADDED_TO_STAGE);
                addEventListener(Event.REMOVED_FROM_STAGE , on_REMOVED_FROM_STAGE );
            }
        }
        public function on_ADDED_TO_STAGE(e:Event):void {
            init();
        }
        public function init():void {
            // fullscreen
            stage.displayState = StageDisplayState.FULL_SCREEN;
            // Camera Object
            CameraObj = Camera.getCamera();
            CameraObj.setMode(VidW,VidH,30,true);
            // Video Object that holds the Camera Object;
            VideoObj = new Video(CameraObj.width,CameraObj.height);
            VideoObj.attachCamera(CameraObj);
            // BITMAP on stage
            BitmapDataStage = new BitmapData(BitW,BitH,false,0x000000);
            BitmapStage = new Bitmap(BitmapDataStage);
            // BITMAPDATA sssss to store time
            for (var i:int = 0; i<total; i++) {
                var BMPD:BitmapData = new BitmapData(tx,ty,false,0x000000);
                BitmapDataArray.push(BMPD);
            }
            //;
            addChild(BitmapStage);
            //
            addEventListener(Event.ENTER_FRAME , on_ENTER_FRAME,  false , 0 ,true);
        }
        public function on_ENTER_FRAME(e:Event):void {
            // shift 1-99 to 0-98
            for (var i:int = 0; i<total-1; i++) {
                BitmapDataArray[i] = BitmapDataArray[i + 1];
            }
            // change 99th bitmapdata
            var BMPD:BitmapData = new BitmapData(tx,ty,false,0x000000);
            MatrixTransform = new Matrix();
            MatrixTransform.scale(ScaleRatio,ScaleRatio);
            BMPD.draw(VideoObj,MatrixTransform);
            BitmapDataArray[total - 1] = BMPD;
            //
            // scale the image first 
            for (var k:int = 0; k<total; k++) {
                var BMP_cache:BitmapData = BitmapDataArray[k] as BitmapData;
                BitmapDataStage.copyPixels(BMP_cache,BMP_cache.rect,new Point(tx*(k%row) , ty *(k-k%row)/row) ,null,null,false);
            }
            //;
            k++;
            if (k == total) {
                k = 0;
            }
        }
        public function on_REMOVED_FROM_STAGE(e:Event):void {
            removeEventListener(Event.ADDED_TO_STAGE , on_ADDED_TO_STAGE);
            removeEventListener(Event.REMOVED_FROM_STAGE , on_REMOVED_FROM_STAGE );
        }
    }
}