/**
 * Copyright tkinjo ( http://wonderfl.net/user/tkinjo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5SVS
 */

package  
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    
    [SWF(width="465", height="465", backgroundColor="0xffffff", frameRate="60")] 
    /**
     * ...
     * @author tkinjo
     */
    public class Main extends Sprite
    {
        private var canvas:Bitmap;
        private var canvasBitmapData:BitmapData;
        
        private var brush:Sprite;
        private var drawBrushMatrix:Matrix;
        
        public function Main() 
        {
            // setup canvas
            canvasBitmapData = new BitmapData( stage.stageWidth, stage.stageHeight );
            canvas = new Bitmap( canvasBitmapData );
            addChild( canvas );
            
            // setup brush
            brush = new Sprite();
            brush.graphics.beginFill( 0x0 );
            brush.graphics.drawCircle( 0, 0, 5 );
            brush.graphics.endFill();
            
            drawBrushMatrix = new Matrix();
            
            stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
        }
        
        private function mouseMoveHandler( event:MouseEvent ):void {
            
            if ( !event.buttonDown )
                return;
            
            drawBrushMatrix.identity();
            drawBrushMatrix.translate( event.stageX, event.stageY );
            canvasBitmapData.draw( brush, drawBrushMatrix );
        }
    }
}