/**
 * Copyright nikukyu ( http://wonderfl.net/user/nikukyu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5R6D
 */

/**
    オブジェクト破壊[破片]
    
    DisplayObjectを破壊します。

    オブジェクトをクリックすると壊れます。
    マウスカーソルを文字に合わせるとオブジェクトが増えます。
    
    DestroyObject(Chips)
    
    Destroy DisplayObjects.
    
    click object to destroy.
    mouseover on text to generate new object.
    
    update : 2011/01/26
        透過がうまくいかなかったのを修正    
    
*/
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.DisplayObject;
    import flash.display.GradientType;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.net.URLRequest;
    import flash.text.TextField;
    
    [SWF(backgroundColor='#FFFFFF', frameRate='30', width='465', height='465')]       
    
    public class Main extends Sprite 
    {
        private const IMAGE_URL:String              = "http://assets.wonderfl.net/images/related_images/9/90/9034/90344cebd2d15b48162d8090ef4df0fb856c94de";
        
        private var _loader:Loader;
        
        private var _image_base:Bitmap;
        
        private var _crack_field:CrackField;
        
        public function Main()
        {
            Security.allowDomain("assets.wonderfl.net");
            Security.loadPolicyFile("http://assets.wonderfl.net/crossdomain.xml");

            var url:URLRequest            = new URLRequest( IMAGE_URL );
            _loader                        = new Loader();
            _loader.contentLoaderInfo.addEventListener( Event.COMPLETE, onLoad ) ;
            _loader.load( url );
        }
        
        public function onLoad( e:Event ):void
        {
            _image_base                    = e.target.content;
            
            // create initial Object
            createGradientObject();
            createBitmapObject();
            
            // create CrackField
            _crack_field                = new CrackField();
            addChild( _crack_field );
            
            var text_add_bo:TextField    = new TextField();
            text_add_bo.text            = "add Bitmap object";
            text_add_bo.textColor        = 0x000000;
            text_add_bo.height            = 20;
            text_add_bo.addEventListener( MouseEvent.ROLL_OVER, createBitmapObject );
            addChild( text_add_bo );
            
            var text_add_go:TextField    = new TextField();
            text_add_go.text            = "add Gradient object";
            text_add_go.textColor        = 0x000000;
            text_add_go.x                = 200;
            text_add_go.height            = 20;
            text_add_go.addEventListener( MouseEvent.ROLL_OVER, createGradientObject );
            addChild( text_add_go );
            
            stage.addEventListener( Event.ENTER_FRAME, update );
        }
        
        private function createBitmapObject( e:MouseEvent = null ):void
        {
            var bitmap_data:BitmapData    = new BitmapData( _image_base.width, _image_base.height, true, 0x00ffffff );
            bitmap_data.draw( _image_base );
            var object:Sprite            = new Sprite();
            object.addChild( new Bitmap( bitmap_data ) );
            object.x                    = Math.floor( Math.random() * (465 - 128) );
            object.y                    = Math.floor( Math.random() * (465 - 128) );
            object.addEventListener( MouseEvent.CLICK, onClickObject );
            addChild( object );
        }
        
        private function createGradientObject( e:MouseEvent = null ):void
        {
            var object:Sprite            = new Sprite();
            var radius:int                = Math.floor( Math.random() * 100 );
            object.graphics.beginGradientFill( GradientType.LINEAR, [ Math.floor( Math.random() * 0xffffff ), Math.floor( Math.random() * 0xffffff ) ], [ 1, 1 ], [ 0, 255 ] );
            object.graphics.drawCircle( radius, radius, radius );
            object.graphics.endFill();
            object.x                    = Math.floor( Math.random() * (465 - radius*2) );
            object.y                    = Math.floor( Math.random() * (465 - radius*2) );
            object.addEventListener( MouseEvent.CLICK, onClickObject );
            addChild( object );
        }
        
        private function onClickObject( e:MouseEvent ):void 
        {
            // crack
            _crack_field.crack( e.target as DisplayObject );
            
            // remove cracked object
            removeChild( e.target as DisplayObject );
        }
        
        private function update( e:Event ):void 
        {
            // forward crack field
            setChildIndex( _crack_field, numChildren - 1 );
            
            // calculate chips
            _crack_field.update();
        }
    }
}


import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.BlendMode;
import flash.display.DisplayObject;
import flash.display.InterpolationMethod;
import flash.display.Sprite;
import flash.geom.Matrix;


class CrackField extends Sprite 
{
    private const CRACK_DIVISION:int            = 4;
    private const GRAVITY:int                    = 2;
    
    public function crack( object:DisplayObject ):void
    {
        for ( var i:int = 0; i < CRACK_DIVISION * CRACK_DIVISION; ++i )
        {
            var bitmap_data:BitmapData            = new BitmapData( object.width / CRACK_DIVISION, object.height / CRACK_DIVISION, true, 0x00ffffff );
            var m:Matrix                        = new Matrix();
            var x:int                            = (int)( i % CRACK_DIVISION ) * object.width / CRACK_DIVISION;
            var y:int                            = (int)( i / CRACK_DIVISION ) * object.width / CRACK_DIVISION;
            m.translate( -x, -y );
            bitmap_data.draw( object, m, null, BlendMode.NORMAL );
            
            var crack_object:CrackObject        = addChild( new CrackObject( bitmap_data ) ) as CrackObject;
            crack_object.x                        = object.x + x;
            crack_object.y                        = object.y + y;
            crack_object.speed_x                = Math.floor( Math.random() * 20 ) - 10;
            crack_object.speed_y                = Math.floor( Math.random() * 20 ) - 20;
            crack_object.rotate_x                = Math.floor( Math.random() * 20 ) - 10;
            crack_object.rotate_y                = Math.floor( Math.random() * 20 ) - 10;
            crack_object.rotate_z                = Math.floor( Math.random() * 20 ) - 10;
            addChild( crack_object );
        }
    }
    
    public function update():void
    {
        for ( var i:int = 0; i < numChildren; ++i )
        {
            var crack_object:CrackObject        = getChildAt( i ) as CrackObject;
            crack_object.x                        += crack_object.speed_x;
            crack_object.y                        += crack_object.speed_y;
            crack_object.rotationX                += crack_object.rotate_x;
            crack_object.rotationY                += crack_object.rotate_y;
            crack_object.rotationZ                += crack_object.rotate_z;
            crack_object.speed_y                += GRAVITY;
            
            if ( stage.stageHeight < crack_object.y - ( ( crack_object.height < crack_object.width ) ? crack_object.width : crack_object.height ) )
            {
                removeChild( crack_object );
            }
        }
    }
}

import flash.display.Bitmap;
import flash.display.BitmapData;

class CrackObject extends Bitmap
{
    public var speed_x:int;
    public var speed_y:int;
    public var rotate_x:int;
    public var rotate_y:int;
    public var rotate_z:int;
    
    public function CrackObject( bitmapData:BitmapData = null, pixelSnapping:String = "auto", smoothing:Boolean = false )
    {
        super( bitmapData, pixelSnapping, smoothing );
    }
}