/**
 * Copyright set0 ( http://wonderfl.net/user/set0 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5Qir
 */

package  
{
	import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
	
    [SWF(width=465, height=465, frameRate=60, backgroundColor=0x000000)]
    public class FlashTest13 extends Sprite
	{
		private var spark_list:Array = [];
		private var buffer:BitmapData = new BitmapData(465, 465, false, 0x000000);
		private var screen:Bitmap = new Bitmap(buffer);
		
		private var old_x:Number = 0;
		private var old_y:Number = 0;

		public function FlashTest13()
		{			
			addChild(screen);
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		
		private function onEnterFrame(e:Event):void
		{
			spark_list.push(new Spark(old_x, old_y, stage.mouseX, stage.mouseY));
			
			old_x = stage.mouseX;
			old_y = stage.mouseY;
			
			var max:int = spark_list.length;
			buffer.colorTransform(buffer.rect, new ColorTransform(0, 0, 0, 0, 0, 0, 0, 0));

			for (var i:int = 0; i < max; i++) {
				buffer.copyPixels(spark_list[i].bottom_bmp, spark_list[i].bottom_bmp.rect, new Point(spark_list[i].x, spark_list[i].y));
				
				if (spark_list[i].move() === false) {
					spark_list.splice(i, 1);
					i--;
					max--;
				}
			}
			
			for (i = 0; i < max; i++) {
				buffer.copyPixels(spark_list[i].top_bmp, spark_list[i].top_bmp.rect, new Point(spark_list[i].x, spark_list[i].y));
			}
		}
    }
}

import flash.display.*;
import flash.geom.*;
import flash.filters.*;

class Spark
{
    public var top_bmp:BitmapData;
	public var middle_bmp:BitmapData;
	public var bottom_bmp:BitmapData;
	public var x:Number;
	public var y:Number;
	public var life:Number = 40;

    public function Spark(old_x:Number, old_y:Number, x:Number, y:Number)
    {
		var width:Number = old_x - x == 0 ? 30 : Math.abs(old_x - x) + 30;
		var height:Number = old_y - y == 0 ? 30 :Math.abs(old_y - y) + 30;
		var from_x:Number;
		var from_y:Number;
		var to_x:Number;
		var to_y:Number;
		
		if (x > old_x) {
			this.x = old_x - (old_x / Math.abs(old_x)) * 15;
		} else {
			this.x = x - (x / Math.abs(x)) * 15;
		}
		
		if (y > old_y) {
			this.y = old_y - (old_y / Math.abs(old_y)) * 15;
		} else {
			this.y = y - (y / Math.abs(y)) * 15;
		}
		
        this.top_bmp = new BitmapData(width, height, true, 0xffffff);
		
		from_x = x - this.x;
		from_y = y - this.y;
		to_x = old_x -this.x;
		to_y = old_y -this.y;
		
		var top_shape:Shape = new Shape();
		top_shape.graphics.lineStyle(10, 0xffffff);
		top_shape.graphics.moveTo(from_x, from_y);
		top_shape.graphics.lineTo(to_x , to_y);
		top_shape.filters = [new GlowFilter(0xffffff, 0.8, 8, 8, 2)];
		
		this.top_bmp.draw(top_shape);
		
		var bottom_shape:Shape = new Shape();
		bottom_shape.graphics.lineStyle(12, 0xffffff);
		bottom_shape.graphics.moveTo(from_x, from_y);
		bottom_shape.graphics.lineTo(to_x , to_y);
		bottom_shape.filters = [new GlowFilter(0x0099ff, 0.8, 8, 8, 2)];
		
		this.bottom_bmp = new BitmapData(width, height, true, 0x000000);
		this.bottom_bmp.draw(bottom_shape);

    }
	
	public function move():Boolean
	{
		life--;
		
		if (life <= 0) {
			return false;
		}
		
		return true;
	}
}
