/**
 * Copyright _ryotaros ( http://wonderfl.net/user/_ryotaros )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5QTo
 */

package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.events.Event;
    
    public class FlashTest extends Sprite {
    		
    		public var scrollArea:Box;
    		public var scrollBar:Box;
    		public var scrollBarshadow:Box;
    		public var element:Box;
    		public var elementArea:Sprite;
    		public var elements:Array;
    		
    		public var elNum:int = 20;		
    		public var bardist:Number;
    		public var elementAreaDist:Number;
    		public var targetDist:Number;
    		public var ElementAreaLength:Number;
    		public var scrollBarPoint:Number;
    
        public function FlashTest() {
            init();
        }
    
    		public function init():void{
    			 scrollArea = new Box(0,0,200,350); 
    			 scrollArea.x = 100;
    			 scrollArea.y = 50;
    			 addChild(scrollArea);
    			 
    			 scrollBarshadow = new Box(0, 0, 15, scrollArea.height , 1 , 0xCCCCCC);
    			 scrollBar = new Box(0, 0, 15, 100, 1, 0x000000);
    			 scrollBarshadow.x = scrollBar.x = scrollArea.x + scrollArea.width + 10;
    			 scrollBarshadow.y = scrollArea.y;
    			 scrollBar.y = scrollArea.y + scrollArea.height - scrollBar.height;
    			 addChild(scrollBarshadow);
    			 addChild(scrollBar);
    			 
    			 bardist = scrollArea.height - scrollBar.height;

    			 elements = [];
    			 elementArea = new Sprite();
    			 elementArea.x = scrollArea.x;
    			 
    			 addChild(elementArea);
    			  
    			 for(var i:int = 0;i < elNum; i++ ){
    			 	element = new Box(00,0,100,100,1,0xFFFF00);
    			 	elements.push(element);
    			 	element.x = 10;
    			 	if (i == 0) { element.y = 5;}
    			 	       else { element.y = elements[i-1].y + element.height + 10;}
    			 	elementArea.addChild(element);
    			 } 			 
    			 elementAreaDist = elementArea.height - scrollArea.height + 10;
   		 	
   		 	 elementArea.y -= elementArea.height - scrollArea.height; 
   		 	 elementArea.mask = scrollArea;
   		 	 
   		 	 addEventListener(Event.ENTER_FRAME, xinitMoveScroll);
    			 
    		}
    		
    		public function xinitMoveScroll(e:Event):void{
    			var vy:Number = (scrollArea.y - scrollBar.y) / 10; 
    			var vy2:Number= ((scrollArea.y) - elementArea.y) /10;
    			scrollBar.y += vy;
    			elementArea.y += vy2;
    			
    			if((scrollBar.y-scrollArea.y) < 0.1 && (elementArea.y - scrollArea.y) < 0){
    				scrollBar.y = scrollArea.y;
    				elementArea.y = scrollArea.y;
    				removeEventListener(Event.ENTER_FRAME, xinitMoveScroll);
    				scrollBar.addEventListener(MouseEvent.MOUSE_DOWN, _scrollbarHandler);
    				stage.addEventListener(MouseEvent.MOUSE_UP, _scrollbarUpHandler);
    			}
    		}
    		
    		public function _scrollbarHandler(e:MouseEvent):void{
    			scrollBarPoint = scrollBar.height - (scrollBar.y + scrollBar.height - mouseY);
    			addEventListener(Event.ENTER_FRAME, _onScrollArea );
    		}
    		public function _scrollbarUpHandler(e:MouseEvent):void{
    			removeEventListener(Event.ENTER_FRAME, _onScrollArea );
    		}
    		 
    		public function _onScrollArea(e:Event = null):void{
    			scrollBar.y = mouseY - scrollBarPoint;
    			if(scrollBar.y + scrollBar.height  > scrollArea.y + scrollArea.height) {
    				scrollBar.y = scrollArea.y + scrollArea.height - scrollBar.height;
    			}
    			if(scrollBar.y < scrollArea.y ) {
    				scrollBar.y = scrollArea.y;	
    			}
    			targetDist = scrollArea.y - (elementAreaDist * ((scrollBar.y - scrollArea.y)/bardist)); 
    			elementArea.y += (targetDist - elementArea.y) * 0.2; 
    			
    		}
    }
}

import flash.display.Sprite;
class Box extends Sprite {
	public function Box(x:Number,y:Number,width:Number = 20,height:Number = 20,line:Number = 1,color:uint = 0xFF0000):void{
    			with(this.graphics) {
    				beginFill(color);
    				lineStyle(line);
    				drawRect(x,y,width,height);
    				endFill();
    			}
    		}   
	
}