/**
 * Copyright matacat ( http://wonderfl.net/user/matacat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5Q07
 */

// forked from Nyarineko's Pentagon
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.ui.Keyboard;
    
    [SWF(width = 465, height = 465, frameRate = 60)]
    
    public class Main extends Sprite
    {
    // consts for adjustment
        
        // 図形ごとの頂点の数. The number of vertices per shape.
        private const VERTEX:int = 5;
        
        // 頂点間の角度倍率. The multiplier of angles between vertices.
        // ex) (VERTEX == 5 && ANGLE == 2) -> ☆
        private const ANGLE:Number = 1;
        
        // 連なる図形の数. The number of shapes lining up.
        private const CELL:int = 24;
        
        // 繋がりの硬さ. (0, 1]の区間で指定. 1に近いほどすばやく追従する.
        // ただし追従する図形は必ず1フレーム遅れる.
        // The stiffness of joins. The interval is (0, 1].
        // The closer it gets to 1, the faster shapes follow,
        // but shapes delay 1 frame certainly.
        private const STIFF:Number = 1 / 2;
        
        // 図形の半径の最小値.
        // The minimum of radius of shapes.
        private const R_MIN:Number = 50;
        
        // 半径拡大率. 半径はこの値とマウス速度の積に比例する.
        // The multiplier of the radius. The radius is proportional to
        // the product of this value and the velocity of mouse.
        private const R_MUL:Number = 1 / 4;
        
        // 1フレームあたりに増える回転角.
        // The angle of rotation increments shapes' rotation every frame.
        private const OMEGA:Number = Math.PI * 2 / 360;
        
        // 線の色と太さ. The color and thickness of lines.
        private const COLOR:uint   = 0x99CCFF;
        private const THICK:Number = 2;
        
        // エフェクト関係. Effect-related consts.
        private const BLUR:BlurFilter   = new BlurFilter(8, 8);
        private const CT:ColorTransform = new ColorTransform(0.98, 0.95, 0.99);
        
        
    // consts for calculate; it's NOT recommended to modify them
        
        private const CX:Number     = stage.stageWidth / 2;
        private const CY:Number     = stage.stageHeight / 2;
        private const PI2:Number    = Math.PI * 2;
        private const LENGTH:Number = VERTEX * CELL * 2;
        private const HALF:int      = (VERTEX + 1) * CELL;
        private const DELTA:Number  = PI2 * ANGLE / VERTEX;
        
        private var frame:Shape          = new Shape();
        private var cmds:Vector.<int>    = new Vector.<int>(LENGTH, true);
        private var data:Vector.<Number> = new Vector.<Number>(LENGTH * 2, true);
        
        private var mx:Number  = stage.mouseX;
        private var my:Number  = stage.mouseY;
        private var rot:Number = 0;
        private var dir:int    = 1;
        
        private var bmData:BitmapData  = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x000000);
        private var buffer:BitmapData  = bmData.clone();
        private var origin:Point       = new Point();
        private var dontRender:Boolean = false;
        
        public function Main()
        {
            var i:int, j:int;
            
            cmds[0] = 1;
            data[0] = CX;
            data[1] = CY;
            for (i = 1; i < LENGTH; i++) {
                if ( (i >= HALF) && ((i - HALF) % CELL == 0) ) {
                    cmds[i] = 1;
                } else {
                    cmds[i] = 2;
                }
                j = i * 2;
                data[j]   = CX;
                data[++j] = CY;
            }
            
            addChild(new Bitmap(bmData));
            
            stage.addEventListener(MouseEvent.CLICK, onClick);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onClick(e:MouseEvent):void
        {
            dir ^= -2;
        }
        
        private function onKeyDown(e:KeyboardEvent):void
        {
            if (e.keyCode == Keyboard.SPACE) dontRender = !dontRender;
        }
        
        private function onEnterFrame(e:Event):void
        {
            if (dontRender) return;
            
            var i:int, j:int, k:int;
            
            for (i = LENGTH - 1; i > VERTEX; i--) {
                j = i * 2;
                if (i >= HALF) {
                    if ((i - HALF) % CELL != 0) {
                        k = j - 2;
                        data[j]   += (data[k]   - data[j]) * STIFF;
                        data[++j] += (data[++k] - data[j]) * STIFF;
                    }
                } else {
                    k = j - (VERTEX + 1) * 2;
                    data[j]   += (data[k]   - data[j]) * STIFF;
                    data[++j] += (data[++k] - data[j]) * STIFF;
                }
            }
            
            var nx:Number = stage.mouseX;
            var ny:Number = stage.mouseY;
            mx = nx - mx;
            my = ny - my;
            
            var dr:Number = Math.sqrt(mx * mx + my * my) * R_MUL + R_MIN;
            
            for (i = 0; i < VERTEX; i++) {
                j = i * 2;
                data[j]   = Math.cos(i * DELTA + rot) * dr + nx;
                data[++j] = Math.sin(i * DELTA + rot) * dr + ny;
                if (i == 0) {
                    j = VERTEX * 2;
                    data[j]   = data[0];
                    data[++j] = data[1];
                } else {
                    k = ((i - 1) * CELL + HALF) * 2;
                    data[k]   = data[--j];
                    data[++k] = data[++j];
                }
            }
            
            mx   = nx;
            my   = ny;
            rot += OMEGA * dir;
            
            frame.graphics.clear();
            frame.graphics.lineStyle(THICK, COLOR);
            frame.graphics.drawPath(cmds, data);
            
            buffer.applyFilter(bmData, bmData.rect, origin, BLUR);
            buffer.colorTransform(buffer.rect, CT);
            buffer.draw(frame);
            bmData.copyPixels(buffer, buffer.rect, origin);
        }
    }
}
