/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5PWv
 */

// forked from LawrieCape's 50 Red AS3 - lawriecape.co.uk/theBlog
package
{
    import flash.display.*;
    import flash.events.*;
    import flash.text.TextField;
        import flash.text.TextFormat;
        import gs.*;

    public class Main extends Sprite
    {
        /// - Variables - ///
        public var randomRotationSetting:int  = Math.round(Math.random()*100);
        public var scoreVar:int               = 0;
        public var scaleDivider:int           = Math.round(Math.random()*10000);

                public var c1:int = Math.random()*0xffffff;
                public var c2:int = Math.random()*0xffffff;

        public function Main(){
            addEventListener('addedToStage', function(e:Event):void{
                stage.scaleMode = 'noScale';
                stage.align = 'TL';
                stage.frameRate = 30;
            });
            
            
            //Make 250 balls -
            for (var i:int =0; i<250; i++) {
                var h:MovieClip = new MovieClip();    
            if (i%2) {
            //Make it red
            h.graphics.beginFill( c1, 1);
            //And add a listener to call the clickRed function when it is clicked.
            h.addEventListener(MouseEvent.MOUSE_DOWN, clickRed);
            } else {
            //Otherwise make it blue
            //And add the clickBlue function instead.
            h.graphics.beginFill( c2, 1);
            h.addEventListener(MouseEvent.MOUSE_DOWN, clickBlue);
            }
            //Setting the button mode to true makes flash use the hand icon
            h.buttonMode = true;
            //Draw a circle, at position x:0,y:-50,with a radius of 10.
            h.graphics.drawCircle(0,-50,10);
            //And center it on stage 
            h.x = 250;
            h.y = 250;
            //And set it's number to i - the step through the for loop.
            h.myNum= i;
            //Set the ball's rotation -
            h.rotationZ = i * randomRotationSetting;
            h.rotationY = (180 / 250) * i
            h.z = i;
            //Set the ball's scale -
            h.gotoScale =(i*i)/scaleDivider;//i/100;
            //Add an event listener to update the ball's position every frame -
            h.addEventListener(Event.ENTER_FRAME, updatePosition);
                        h.alpha =0;
                        TweenLite.to(h,30,{alpha:1, scaleX:h.gotoScale,scaleY:h.gotoScale });
            addChild(h);
            //trace(h.stage)
            }
            
        /// - Scores text box - ///
        //Create a new text field on the stage
        var tf:TextField = new TextField();
            tf.name = "tf";
                    tf.width = stage.stageWidth;
                    tf.selectable = false;
                    tf.text = "Only click the circles that are this color";
                var tForm:TextFormat = new TextFormat();
                    tForm.color = c1;
                    tf.setTextFormat(tForm);

            addChild(tf);        
        }

        public function updatePosition(e:Event):void {
            //Rotate the current ball by an amount calculated from it's number - 
            e.currentTarget.rotationZ += (Math.PI * (e.currentTarget.myNum / 2)) / 50;
            e.currentTarget.rotationY += (e.currentTarget.myNum / 200)
        }
        /// - Click Handlers - ///
        //These are called when the balls are clicked -
        public function clickRed(e:Event):void {
            //Make a reference to the current ball
            var ball:Object = e.currentTarget;
            //Remove the listeners from the ball before we destroy it - 
            ball.removeEventListener(Event.ENTER_FRAME, updatePosition);
            ball.removeEventListener(MouseEvent.MOUSE_DOWN, clickRed);
            //Remove the ball from the display list.
            ball.parent.removeChild(ball);
            trace("Win a point!");
            //Add a point to the score variable 
            scoreVar+=1;
            //Call the update score function
            updateScore();
        }

        public function clickBlue(e:Event):void {
            //As with the above function - except we are removing the clickBlue listener
            //and subtracting a point
            var ball:Object = e.currentTarget;
            ball.removeEventListener(Event.ENTER_FRAME, updatePosition);
            ball.removeEventListener(MouseEvent.MOUSE_DOWN, clickBlue);
            ball.parent.removeChild(ball);
            trace("Lose a point!");
            scoreVar-=1;
            updateScore();
        }
        //This is called to update the scores text
        public function updateScore():void {
            var tf:Object = getChildByName("tf");
            tf.text = "Score = "+scoreVar;
            //If your score is higher than 50 - you win the game!
            if (scoreVar>=10) {
            tf.text = "You have won the game!";
            }
        }
    }
}
