/**
 * Copyright widged ( http://wonderfl.net/user/widged )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5Osw
 */

/**
 * G. W. Bush Bobblehead
 * Adapted from a Flash MX demo by Senocular
 * http://www.senocular.com/flash/source/?id=0.90
 * Original noticed specified "All source files and downloads 
 * on this site are completely free to use any way you see fit 
 * for personal or commercial use"
 * 
 * Ported to Actionscript 3 
 */
package
{
    import flash.display.Sprite;
    import flash.display.Loader;
    import flash.system.LoaderContext;
    import flash.net.URLRequest;
    
    import org.osmf.events.LoadEvent;
    
    [SWF(width = "465", height = "465", backgroundColor='#FFFFFF')]
    public class WobblyHead extends Sprite
    {
        private var head:Sprite, bodyLoader:Loader;
        public function WobblyHead()
        {
            bodyLoader = new Loader();
            bodyLoader.load(new URLRequest("http://widged.com/labs/wonderfl/body.png"), new LoaderContext(true));
            bodyLoader.y = 40;
            addChild(bodyLoader);

            head = new Head(); 
            head.y = 40;
            addChild(head);
        }
        
    }
}

import flash.display.Loader;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.geom.Point;
import flash.net.URLRequest;
import flash.system.LoaderContext;

class Head extends Sprite
{
    private var _headOrigin:Point;
    private var _bobbing:WobblyPhysics;
    private var _nodding:WobblyPhysics;
    private var headLoader:Loader, bodyLoader:Loader;
    
    public function Head()
    {
        loadImage();        
    }
    
    private function loadImage():void
    {
        headLoader = new Loader();
        headLoader.load(new URLRequest("http://widged.com/labs/wonderfl/head.png"), new LoaderContext(true));
        headLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, onHeadLoaded);
        addChild(headLoader);
    }

    private function onHeadLoaded(event:Event):void
    {
        _headOrigin = new Point(this.x,this.y);
        _bobbing = new WobblyPhysics(30,  .7, .99 );
        _nodding = new WobblyPhysics(30, 1.2, .985);
        this.addEventListener(MouseEvent.CLICK, resetWobble);
    }
    
    private function resetWobble(event:Event = null):void
    {
        this.addEventListener(Event.ENTER_FRAME, updateWobble);
        _bobbing.reset(); _nodding.reset();
    }
    
    private function updateWobble(event:Event = null):void
    {
        if (_bobbing.enabled){
            this.y = _headOrigin.y + _bobbing.value;
            _bobbing.update()
        } 
        
        if (_nodding.enabled){
            this.rotation = _nodding.value;
            _nodding.update()
        }
        
        if(!_bobbing.enabled && !_nodding.enabled) 
        {
            this.removeEventListener(Event.ENTER_FRAME, updateWobble);
        }
    }    
}


class WobblyPhysics
{
    // range of motion; bobbing up and down movement, nodding, rotation side to side
    private var _range:Number;
    // force to be applied to each bobbing and nodding when the head is hit
    private var _hit:Number;    
    // rate of dampening - how fast the bobbing or nodding slows down after a hit
    private var _dampening:Number;    
    // angle for sine curve.  starts at 0, increases from there
    private var _angle:Number;
    // 0-1, percentage of force left in bobbing motion hitting the head puts force at 1.  Each frame
    // thereafter brings force down by _damp %.  When force is 0, theres no movement left
    private var _force:Number;
    
    public function WobblyPhysics(range:Number, hit:Number, dampening:Number)
    {
        _range     = range;
        _hit       = hit;
        _dampening = dampening;
        _angle     = 0;
        _force     = 0;
    }

    public function get enabled():Boolean
    {
        return Math.round(_force*10) != 0;
    }

    public function get value():Number
    {
        var val:Number = Math.sin(_angle)*_force*_range/2;
        return val;
    }
    public function update():void
    {
        _angle += _hit * _force;
        _force *= _dampening; 
    }
    
    public function reset():void
    {
        _angle = 0;
        _force = 1;
    }
    
}

